/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.architectury.event.events.GuiEvent;
import me.shedaniel.architectury.event.events.RecipeUpdateEvent;
import me.shedaniel.architectury.event.events.client.ClientScreenInputEvent;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.registry.ReloadListeners;
import me.shedaniel.architectury.utils.Env;
import me.shedaniel.rei.PluginDetector;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.client.REIHelper;
import me.shedaniel.rei.api.client.REIOverlay;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.entry.type.BuiltinEntryTypes;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.fluid.FluidSupportProvider;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.PluginView;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.plugins.REIServerPlugin;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoRegistry;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.ClientInternals;
import me.shedaniel.rei.impl.Internals;
import me.shedaniel.rei.impl.client.REIHelperImpl;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.entry.type.types.RenderingEntryDefinition;
import me.shedaniel.rei.impl.client.favorites.FavoriteEntryTypeRegistryImpl;
import me.shedaniel.rei.impl.client.gui.ContainerScreenOverlay;
import me.shedaniel.rei.impl.client.gui.widget.InternalWidgets;
import me.shedaniel.rei.impl.client.gui.widget.QueuedTooltip;
import me.shedaniel.rei.impl.client.registry.category.CategoryRegistryImpl;
import me.shedaniel.rei.impl.client.registry.display.DisplayRegistryImpl;
import me.shedaniel.rei.impl.client.registry.screen.ScreenRegistryImpl;
import me.shedaniel.rei.impl.client.search.SearchProviderImpl;
import me.shedaniel.rei.impl.client.subsets.SubsetsRegistryImpl;
import me.shedaniel.rei.impl.client.transfer.TransferHandlerRegistryImpl;
import me.shedaniel.rei.impl.client.view.ViewsImpl;
import me.shedaniel.rei.impl.common.category.CategoryIdentifierImpl;
import me.shedaniel.rei.impl.common.display.DisplaySerializerRegistryImpl;
import me.shedaniel.rei.impl.common.entry.EmptyEntryStack;
import me.shedaniel.rei.impl.common.entry.EntryIngredientImpl;
import me.shedaniel.rei.impl.common.entry.TypedEntryStack;
import me.shedaniel.rei.impl.common.entry.comparison.ItemComparatorRegistryImpl;
import me.shedaniel.rei.impl.common.entry.comparison.NbtHasherProviderImpl;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryImpl;
import me.shedaniel.rei.impl.common.entry.type.EntryTypeDeferred;
import me.shedaniel.rei.impl.common.entry.type.EntryTypeRegistryImpl;
import me.shedaniel.rei.impl.common.entry.type.types.EmptyEntryDefinition;
import me.shedaniel.rei.impl.common.fluid.FluidSupportProviderImpl;
import me.shedaniel.rei.impl.common.plugins.PluginManagerImpl;
import me.shedaniel.rei.impl.common.registry.RecipeManagerContextImpl;
import me.shedaniel.rei.impl.common.transfer.MenuInfoRegistryImpl;
import me.shedaniel.rei.impl.common.util.IssuesDetector;
import me.shedaniel.rei.plugin.test.REITestPlugin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.recipebook.GhostRecipe;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.client.gui.recipebook.RecipeBookGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CraftingScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.container.Slot;
import net.minecraft.inventory.container.WorkbenchContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class RoughlyEnoughItemsCore {
    @ApiStatus.Internal
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"REI");
    private static ExecutorService reloadPlugins;
    @ApiStatus.Experimental
    public static boolean isLeftMousePressed;

    public static void attachCommonInternals() {
        CategoryIdentifierImpl.attach();
        Internals.attachInstance(new Function<ResourceLocation, EntryType<?>>(){
            ResourceLocation RENDERING_ID = new ResourceLocation("rendering");
            private Map<ResourceLocation, EntryType<?>> typeCache = new ConcurrentHashMap();
            private EntryType<Unit> empty;
            @OnlyIn(value=Dist.CLIENT)
            private EntryType<Renderer> render;

            @Override
            public EntryType<?> apply(ResourceLocation id) {
                if (id.equals((Object)BuiltinEntryTypes.EMPTY_ID)) {
                    return this.typeCache.computeIfAbsent(id, this::emptyType);
                }
                if (id.equals((Object)this.RENDERING_ID) && Platform.getEnv() == Dist.CLIENT) {
                    return this.typeCache.computeIfAbsent(id, this::renderingType);
                }
                return this.typeCache.computeIfAbsent(id, EntryTypeDeferred::new);
            }

            public EntryType<Unit> emptyType(final ResourceLocation id) {
                if (this.empty == null) {
                    this.empty = new EntryType<Unit>(){

                        @Override
                        public ResourceLocation getId() {
                            return id;
                        }

                        @Override
                        public EntryDefinition<Unit> getDefinition() {
                            return EmptyEntryDefinition.EMPTY;
                        }
                    };
                }
                return this.empty;
            }

            @OnlyIn(value=Dist.CLIENT)
            public EntryType<Renderer> renderingType(final ResourceLocation id) {
                if (this.render == null) {
                    this.render = new EntryType<Renderer>(){

                        @Override
                        public ResourceLocation getId() {
                            return id;
                        }

                        @Override
                        public EntryDefinition<Renderer> getDefinition() {
                            return RenderingEntryDefinition.RENDERING;
                        }
                    };
                }
                return this.render;
            }
        }, "entryTypeDeferred");
        Internals.attachInstance(new Internals.EntryStackProvider(){

            @Override
            public EntryStack<Unit> empty() {
                return EmptyEntryStack.EMPTY;
            }

            @Override
            public <T> EntryStack<T> of(EntryDefinition<T> definition, T value) {
                if (Objects.equals(definition.getType().getId(), BuiltinEntryTypes.EMPTY_ID)) {
                    return this.empty().cast();
                }
                return new TypedEntryStack<T>(definition, value);
            }
        }, Internals.EntryStackProvider.class);
        Internals.attachInstance(new NbtHasherProviderImpl(), Internals.NbtHasherProvider.class);
        Internals.attachInstance(EntryIngredientImpl.provide(), Internals.EntryIngredientProvider.class);
        Internals.attachInstanceSupplier(new PluginManagerImpl<REIPlugin>(REIPlugin.class, UnaryOperator.identity(), usedTime -> LOGGER.info("Reloaded Plugin Manager [%s] with %d entry types, %d item comparators and %d fluid support providers in %dms.", (Object)REIPlugin.class.getSimpleName(), (Object)EntryTypeRegistry.getInstance().values().size(), (Object)ItemComparatorRegistry.getInstance().comparatorSize(), (Object)FluidSupportProvider.getInstance().size(), (Object)usedTime), new EntryTypeRegistryImpl(), new RecipeManagerContextImpl(RecipeManagerContextImpl.supplier()), new ItemComparatorRegistryImpl(), new DisplaySerializerRegistryImpl(), new FluidSupportProviderImpl()), "commonPluginManager");
        Internals.attachInstanceSupplier(new PluginManagerImpl<REIServerPlugin>(REIServerPlugin.class, view -> view.then(PluginView.getInstance()), usedTime -> LOGGER.info("Reloaded Plugin Manager [%s] with %d menu infos in %dms.", (Object)REIServerPlugin.class.getSimpleName(), (Object)MenuInfoRegistry.getInstance().infoSize(), (Object)usedTime), new MenuInfoRegistryImpl()), "serverPluginManager");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void attachClientInternals() {
        InternalWidgets.attach();
        EmptyEntryDefinition.EmptyRenderer emptyEntryRenderer = new EmptyEntryDefinition.EmptyRenderer();
        ClientInternals.attachInstance(() -> emptyEntryRenderer, "emptyEntryRenderer");
        ClientInternals.attachInstance((supplier, toJson) -> new FavoriteEntry((Supplier)supplier, (Supplier)toJson){
            FavoriteEntry value = null;
            final /* synthetic */ Supplier val$supplier;
            final /* synthetic */ Supplier val$toJson;
            {
                this.val$supplier = supplier;
                this.val$toJson = supplier2;
            }

            @Override
            public FavoriteEntry getUnwrapped() {
                if (this.value == null) {
                    this.value = (FavoriteEntry)this.val$supplier.get();
                }
                return Objects.requireNonNull(this.value).getUnwrapped();
            }

            @Override
            public UUID getUuid() {
                return this.getUnwrapped().getUuid();
            }

            @Override
            public boolean isInvalid() {
                try {
                    return this.getUnwrapped().isInvalid();
                }
                catch (Exception e) {
                    return true;
                }
            }

            @Override
            public Renderer getRenderer(boolean showcase) {
                return this.getUnwrapped().getRenderer(showcase);
            }

            @Override
            public boolean doAction(int button) {
                return this.getUnwrapped().doAction(button);
            }

            @Override
            public Optional<Supplier<Collection<FavoriteMenuEntry>>> getMenuEntries() {
                return this.getUnwrapped().getMenuEntries();
            }

            @Override
            public long hashIgnoreAmount() {
                return this.getUnwrapped().hashIgnoreAmount();
            }

            @Override
            public FavoriteEntry copy() {
                return FavoriteEntry.delegate(this.val$supplier, this.val$toJson);
            }

            @Override
            public ResourceLocation getType() {
                return this.getUnwrapped().getType();
            }

            @Override
            public CompoundNBT save(CompoundNBT tag) {
                if (this.val$toJson == null) {
                    return this.getUnwrapped().save(tag);
                }
                return tag.func_197643_a((CompoundNBT)this.val$toJson.get());
            }

            @Override
            public boolean isSame(FavoriteEntry other) {
                return this.getUnwrapped().isSame(other.getUnwrapped());
            }
        }, "delegateFavoriteEntry");
        ClientInternals.attachInstance(object -> {
            String type = object.func_74779_i("type");
            ResourceLocation id = new ResourceLocation(type);
            return (FavoriteEntry)Objects.requireNonNull(Objects.requireNonNull(FavoriteEntryType.registry().get(id)).read((CompoundNBT)object));
        }, "favoriteEntryFromJson");
        ClientInternals.attachInstance(QueuedTooltip::create, "tooltipProvider");
        ClientInternals.attachInstance(successful -> new ClickArea.Result((Boolean)successful){
            private List categories = Lists.newArrayList();
            final /* synthetic */ Boolean val$successful;
            {
                this.val$successful = bl;
            }

            @Override
            public ClickArea.Result category(CategoryIdentifier<?> category) {
                this.categories.add(category);
                return this;
            }

            @Override
            public boolean isSuccessful() {
                return this.val$successful;
            }

            @Override
            public Stream<CategoryIdentifier<?>> getCategories() {
                return this.categories.stream();
            }
        }, "clickAreaHandlerResult");
        ClientInternals.attachInstanceSupplier(new PluginManagerImpl<REIClientPlugin>(REIClientPlugin.class, view -> view.then(PluginView.getInstance()), usedTime -> LOGGER.info("Reloaded Plugin Manager [%s] with %d entries, %d displays, %d display visibility predicates, %d categories (%s), %d exclusion zones and %d overlay deciders in %dms.", (Object)REIClientPlugin.class.getSimpleName(), (Object)EntryRegistry.getInstance().size(), (Object)DisplayRegistry.getInstance().displaySize(), (Object)DisplayRegistry.getInstance().getVisibilityPredicates().size(), (Object)CategoryRegistry.getInstance().size(), (Object)CategoryRegistry.getInstance().stream().map(CategoryRegistry.CategoryConfiguration::getCategory).map(DisplayCategory::getTitle).map(ITextComponent::getString).collect(Collectors.joining(", ")), (Object)ScreenRegistry.getInstance().exclusionZones().getZonesCount(), (Object)ScreenRegistry.getInstance().getDeciders().size(), (Object)usedTime), new ViewsImpl(), new SearchProviderImpl(), new ConfigManagerImpl(), new CategoryRegistryImpl(), new DisplayRegistryImpl(), new ScreenRegistryImpl(), new EntryRegistryImpl(), new FavoriteEntryTypeRegistryImpl(), new SubsetsRegistryImpl(), new TransferHandlerRegistryImpl(), new REIHelperImpl()), "clientPluginManager");
    }

    @OnlyIn(value=Dist.CLIENT)
    @ApiStatus.Internal
    public static void reloadPlugins(MutableLong lastReload) {
        if (lastReload != null) {
            if (lastReload.getValue() > 0L && System.currentTimeMillis() - lastReload.getValue() <= 5000L) {
                LOGGER.warn("Suppressing Reload Plugins!");
                return;
            }
            lastReload.setValue(System.currentTimeMillis());
        }
        if (ConfigObject.getInstance().doesRegisterRecipesInAnotherThread()) {
            CompletableFuture.runAsync(RoughlyEnoughItemsCore::_reloadPlugins, reloadPlugins);
        } else {
            RoughlyEnoughItemsCore._reloadPlugins();
        }
    }

    private static void _reloadPlugins() {
        try {
            for (PluginManager<REIPlugin<?>> instance : PluginManager.getActiveInstances()) {
                instance.startReload();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void onInitialize() {
        PluginDetector.detectCommonPlugins();
        PluginDetector.detectServerPlugins();
        RoughlyEnoughItemsNetwork.onInitialize();
        if (Platform.getEnvironment() == Env.SERVER) {
            MutableLong lastReload = new MutableLong(-1L);
            ReloadListeners.registerReloadListener((ResourcePackType)ResourcePackType.SERVER_DATA, (preparationBarrier, resourceManager, profilerFiller, profilerFiller2, executor, executor2) -> preparationBarrier.func_216872_a((Object)Unit.INSTANCE).thenRunAsync(RoughlyEnoughItemsCore::_reloadPlugins, executor2));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onInitializeClient() {
        IssuesDetector.detect();
        this.registerEvents();
        PluginDetector.detectClientPlugins();
        this.loadTestPlugins();
        Minecraft client = Minecraft.func_71410_x();
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)RoughlyEnoughItemsNetwork.CREATE_ITEMS_MESSAGE_PACKET, (buf, context) -> {
            ItemStack stack = buf.func_150791_c();
            String player = buf.func_150789_c(Short.MAX_VALUE);
            if (client.field_71439_g != null) {
                client.field_71439_g.func_146105_b((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"text.rei.cheat_items", (Object[])new Object[0]).replaceAll("\\{item_name}", EntryStacks.of(stack.func_77946_l()).asFormattedText().getString()).replaceAll("\\{item_count}", stack.func_77946_l().func_190916_E() + "").replaceAll("\\{player_name}", player)), false);
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)RoughlyEnoughItemsNetwork.NOT_ENOUGH_ITEMS_PACKET, (buf, context) -> {
            Screen currentScreen = Minecraft.func_71410_x().field_71462_r;
            if (currentScreen instanceof CraftingScreen) {
                RecipeBookGui recipeBookGui = ((IRecipeShownListener)currentScreen).func_194310_f();
                GhostRecipe ghostSlots = recipeBookGui.field_191915_z;
                ghostSlots.func_192682_a();
                ArrayList input = Lists.newArrayList();
                int mapSize = buf.readInt();
                for (int i = 0; i < mapSize; ++i) {
                    ArrayList list = Lists.newArrayList();
                    int count = buf.readInt();
                    for (int j = 0; j < count; ++j) {
                        list.add(buf.func_150791_c());
                    }
                    input.add(list);
                }
                ghostSlots.func_194187_a(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221574_b}), 381203812, 12738291);
                WorkbenchContainer container = (WorkbenchContainer)((CraftingScreen)currentScreen).func_212873_a_();
                for (int i = 0; i < input.size(); ++i) {
                    List stacks = (List)input.get(i);
                    if (stacks.isEmpty()) continue;
                    Slot slot = container.func_75139_a(i + container.func_201767_f() + 1);
                    ghostSlots.func_194187_a(Ingredient.func_193369_a((ItemStack[])stacks.toArray(new ItemStack[0])), slot.field_75223_e, slot.field_75221_f);
                }
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private void loadTestPlugins() {
        if (System.getProperty("rei.test", "false").equals("true")) {
            PluginView.getClientInstance().registerPlugin(new REITestPlugin());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean shouldReturn(Screen screen) {
        if (!REIHelper.getInstance().getOverlay().isPresent()) {
            return true;
        }
        if (screen == null) {
            return true;
        }
        if (screen != Minecraft.func_71410_x().field_71462_r) {
            return true;
        }
        return RoughlyEnoughItemsCore._shouldReturn(screen);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean _shouldReturn(Screen screen) {
        try {
            Class<?> screenClass = screen.getClass();
            for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders()) {
                ActionResultType result;
                if (!decider.isHandingScreen(screen.getClass()) || (result = decider.shouldScreenBeOverlaid(screenClass)) == ActionResultType.PASS) continue;
                return result == ActionResultType.FAIL || REIHelper.getInstance().getPreviousScreen() == null;
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerEvents() {
        Minecraft client = Minecraft.func_71410_x();
        ResourceLocation recipeButtonTex = new ResourceLocation("textures/gui/recipe_button.png");
        MutableLong lastReload = new MutableLong(-1L);
        RecipeUpdateEvent.EVENT.register(recipeManager -> RoughlyEnoughItemsCore.reloadPlugins(lastReload));
        GuiEvent.INIT_POST.register((screen, widgets, children) -> {
            REIHelperImpl.getInstance().setPreviousScreen(screen);
            if (ConfigObject.getInstance().doesDisableRecipeBook() && screen instanceof ContainerScreen) {
                widgets.removeIf(widget -> widget instanceof ImageButton && ((ImageButton)widget).field_191750_o.equals((Object)recipeButtonTex));
            }
        });
        ClientScreenInputEvent.MOUSE_CLICKED_PRE.register((minecraftClient, screen, mouseX, mouseY, button) -> {
            isLeftMousePressed = true;
            if (RoughlyEnoughItemsCore.shouldReturn(screen)) {
                return ActionResultType.PASS;
            }
            this.resetFocused(screen);
            if (REIHelper.getInstance().getOverlay().get().func_231044_a_(mouseX, mouseY, button)) {
                if (button == 0) {
                    screen.func_231037_b__(true);
                }
                this.resetFocused(screen);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        });
        ClientScreenInputEvent.MOUSE_RELEASED_PRE.register((minecraftClient, screen, mouseX, mouseY, button) -> {
            isLeftMousePressed = false;
            if (RoughlyEnoughItemsCore.shouldReturn(screen)) {
                return ActionResultType.PASS;
            }
            this.resetFocused(screen);
            if (REIHelper.getInstance().isOverlayVisible() && REIHelper.getInstance().getOverlay().get().func_231048_c_(mouseX, mouseY, button) && this.resetFocused(screen)) {
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        });
        ClientScreenInputEvent.MOUSE_SCROLLED_PRE.register((minecraftClient, screen, mouseX, mouseY, amount) -> {
            if (RoughlyEnoughItemsCore.shouldReturn(screen)) {
                return ActionResultType.PASS;
            }
            this.resetFocused(screen);
            if (REIHelper.getInstance().isOverlayVisible() && REIHelper.getInstance().getOverlay().get().func_231043_a_(mouseX, mouseY, amount) && this.resetFocused(screen)) {
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        });
        ClientScreenInputEvent.CHAR_TYPED_PRE.register((minecraftClient, screen, character, keyCode) -> {
            if (RoughlyEnoughItemsCore.shouldReturn(screen)) {
                return ActionResultType.PASS;
            }
            this.resetFocused(screen);
            if (REIHelper.getInstance().getOverlay().get().func_231042_a_(character, keyCode) && this.resetFocused(screen)) {
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        });
        GuiEvent.RENDER_POST.register((screen, matrices, mouseX, mouseY, delta) -> {
            if (RoughlyEnoughItemsCore.shouldReturn(screen)) {
                return;
            }
            this.resetFocused(screen);
            REIHelper.getInstance().getOverlay().get().func_230430_a_(matrices, mouseX, mouseY, delta);
            ((ContainerScreenOverlay)REIHelper.getInstance().getOverlay().get()).lateRender(matrices, mouseX, mouseY, delta);
            this.resetFocused(screen);
        });
        ClientScreenInputEvent.MOUSE_DRAGGED_PRE.register((minecraftClient, screen, mouseX1, mouseY1, button, mouseX2, mouseY2) -> {
            if (RoughlyEnoughItemsCore.shouldReturn(screen)) {
                return ActionResultType.PASS;
            }
            this.resetFocused(screen);
            if (REIHelper.getInstance().getOverlay().get().func_231045_a_(mouseX1, mouseY1, button, mouseX2, mouseY2) && this.resetFocused(screen)) {
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        });
        ClientScreenInputEvent.KEY_PRESSED_PRE.register((minecraftClient, screen, i, i1, i2) -> {
            if (RoughlyEnoughItemsCore.shouldReturn(screen)) {
                return ActionResultType.PASS;
            }
            if (screen instanceof ContainerScreen && ConfigObject.getInstance().doesDisableRecipeBook() && ConfigObject.getInstance().doesFixTabCloseContainer() && i == 258 && minecraftClient.field_71474_y.field_151445_Q.func_197976_a(i, i1)) {
                minecraftClient.field_71439_g.func_71053_j();
                return ActionResultType.SUCCESS;
            }
            if (screen.func_241217_q_() != null && screen.func_241217_q_() instanceof TextFieldWidget || screen.func_241217_q_() instanceof RecipeBookGui && ((RecipeBookGui)screen.func_241217_q_()).field_193962_q != null && ((RecipeBookGui)screen.func_241217_q_()).field_193962_q.func_230999_j_()) {
                return ActionResultType.PASS;
            }
            this.resetFocused(screen);
            if (REIHelper.getInstance().getOverlay().get().func_231046_a_(i, i1, i2) && this.resetFocused(screen)) {
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean resetFocused(Screen screen) {
        if (screen.func_241217_q_() instanceof REIOverlay || screen.func_241217_q_() == screen) {
            screen.func_231035_a_(null);
        }
        return true;
    }

    static {
        isLeftMousePressed = false;
        RoughlyEnoughItemsCore.attachCommonInternals();
        if (Platform.getEnvironment() == Env.CLIENT) {
            reloadPlugins = Executors.newSingleThreadScheduledExecutor(r -> {
                Thread thread = new Thread(r, "REI-ReloadPlugins");
                thread.setDaemon(true);
                return thread;
            });
            RoughlyEnoughItemsCore.attachClientInternals();
        }
    }
}

