/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.favorites;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.ClientInternals;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class FavoriteEntry {
    public static final String TYPE_KEY = "type";
    private final UUID uuid = UUID.randomUUID();

    public static FavoriteEntry delegate(Supplier<FavoriteEntry> supplier, @Nullable Supplier<CompoundNBT> toJson) {
        return ClientInternals.delegateFavoriteEntry(supplier, toJson);
    }

    @Nullable
    public static FavoriteEntry read(CompoundNBT object) {
        return ClientInternals.favoriteEntryFromJson(object);
    }

    public static FavoriteEntry fromEntryStack(EntryStack<?> stack) {
        return FavoriteEntry.delegate(() -> FavoriteEntryType.registry().get(FavoriteEntryType.ENTRY_STACK).fromArgs(stack), null);
    }

    public static boolean isEntryInvalid(@Nullable FavoriteEntry entry) {
        return entry == null || entry.isInvalid();
    }

    public CompoundNBT save(CompoundNBT tag) {
        tag.func_74778_a(TYPE_KEY, this.getType().toString());
        return Objects.requireNonNull(Objects.requireNonNull(FavoriteEntryType.registry().get(this.getType())).save(this, tag));
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public abstract boolean isInvalid();

    public abstract Renderer getRenderer(boolean var1);

    public abstract boolean doAction(int var1);

    public Optional<Supplier<Collection<FavoriteMenuEntry>>> getMenuEntries() {
        return Optional.empty();
    }

    public abstract long hashIgnoreAmount();

    public abstract FavoriteEntry copy();

    public abstract ResourceLocation getType();

    public boolean equals(Object o) {
        FavoriteEntry thatUnwrapped;
        if (this == o) {
            return true;
        }
        if (!(o instanceof FavoriteEntry)) {
            return false;
        }
        FavoriteEntry that = (FavoriteEntry)o;
        FavoriteEntry unwrapped = this.getUnwrapped();
        return unwrapped == (thatUnwrapped = that.getUnwrapped()) || unwrapped.isSame(thatUnwrapped);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.getType().hashCode();
        result = 31 * result + Long.hashCode(this.hashIgnoreAmount());
        return result;
    }

    public abstract boolean isSame(FavoriteEntry var1);

    public FavoriteEntry getUnwrapped() {
        return this;
    }
}

