/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.drag;

import java.util.function.Function;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProvider;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import net.minecraft.client.gui.screen.Screen;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface DraggableStackProviderWidget {
    public static DraggableStackProviderWidget from(Function<DraggingContext<Screen>, Iterable<DraggableStackProviderWidget>> providers) {
        return (context, mouseX, mouseY) -> {
            for (DraggableStackProviderWidget provider : (Iterable)providers.apply(context)) {
                DraggableStack stack = provider.getHoveredStack(context, mouseX, mouseY);
                if (stack == null) continue;
                return stack;
            }
            return null;
        };
    }

    @Nullable
    public DraggableStack getHoveredStack(DraggingContext<Screen> var1, double var2, double var4);

    public static DraggableStackProvider<Screen> toProvider(DraggableStackProviderWidget widget) {
        return DraggableStackProviderWidget.toProvider(widget, 0.0);
    }

    public static DraggableStackProvider<Screen> toProvider(final DraggableStackProviderWidget widget, final double priority) {
        return new DraggableStackProvider<Screen>(){

            @Override
            @Nullable
            public DraggableStack getHoveredStack(DraggingContext<Screen> context, double mouseX, double mouseY) {
                return widget.getHoveredStack(context, mouseX, mouseY);
            }

            @Override
            public <R extends Screen> boolean isHandingScreen(R screen) {
                return true;
            }

            @Override
            public double getPriority() {
                return priority;
            }
        };
    }
}

