/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.drag;

import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import net.minecraft.client.gui.screen.Screen;

public interface DraggableStackVisitor<T extends Screen>
extends Comparable<DraggableStackVisitor<T>> {
    public static <T extends Screen> DraggableStackVisitor<T> from(final Supplier<Iterable<DraggableStackVisitor<T>>> visitors) {
        return new DraggableStackVisitor<T>(){

            @Override
            public <R extends Screen> boolean isHandingScreen(R screen) {
                for (DraggableStackVisitor visitor : (Iterable)visitors.get()) {
                    if (!visitor.isHandingScreen(screen)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Optional<Acceptor> visitDraggedStack(DraggingContext<T> context, DraggableStack stack) {
                for (DraggableStackVisitor visitor : (Iterable)visitors.get()) {
                    Optional<Acceptor> acceptor;
                    if (!visitor.isHandingScreen(context.getScreen()) || !(acceptor = visitor.visitDraggedStack(context, stack)).isPresent()) continue;
                    return acceptor;
                }
                return Optional.empty();
            }
        };
    }

    public Optional<Acceptor> visitDraggedStack(DraggingContext<T> var1, DraggableStack var2);

    public <R extends Screen> boolean isHandingScreen(R var1);

    default public DraggingContext<T> getContext() {
        return DraggingContext.getInstance().cast();
    }

    default public double getPriority() {
        return 0.0;
    }

    @Override
    default public int compareTo(DraggableStackVisitor<T> o) {
        return Double.compare(this.getPriority(), o.getPriority());
    }

    @FunctionalInterface
    public static interface Acceptor {
        public void accept(DraggableStack var1);
    }
}

