/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.drag;

import java.util.Optional;
import java.util.function.Function;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import net.minecraft.client.gui.screen.Screen;

@FunctionalInterface
public interface DraggableStackVisitorWidget {
    public static DraggableStackVisitorWidget from(Function<DraggingContext<Screen>, Iterable<DraggableStackVisitorWidget>> providers) {
        return (context, stack) -> {
            for (DraggableStackVisitorWidget visitor : (Iterable)providers.apply(context)) {
                Optional<DraggableStackVisitor.Acceptor> acceptor = visitor.visitDraggedStack(context, stack);
                if (!acceptor.isPresent()) continue;
                return acceptor;
            }
            return Optional.empty();
        };
    }

    public Optional<DraggableStackVisitor.Acceptor> visitDraggedStack(DraggingContext<Screen> var1, DraggableStack var2);

    public static DraggableStackVisitor<Screen> toVisitor(DraggableStackVisitorWidget widget) {
        return DraggableStackVisitorWidget.toVisitor(widget, 0.0);
    }

    public static DraggableStackVisitor<Screen> toVisitor(final DraggableStackVisitorWidget widget, final double priority) {
        return new DraggableStackVisitor<Screen>(){

            @Override
            public Optional<DraggableStackVisitor.Acceptor> visitDraggedStack(DraggingContext<Screen> context, DraggableStack stack) {
                return widget.visitDraggedStack(context, stack);
            }

            @Override
            public <R extends Screen> boolean isHandingScreen(R screen) {
                return true;
            }

            @Override
            public double getPriority() {
                return priority;
            }
        };
    }
}

