/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.REIHelper;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import net.minecraft.util.text.ITextProperties;
import org.jetbrains.annotations.Nullable;

public abstract class Label
extends WidgetWithBounds {
    public static final int LEFT_ALIGNED = -1;
    public static final int CENTER = 0;
    public static final int RIGHT_ALIGNED = 1;

    public abstract boolean isClickable();

    public abstract void setClickable(boolean var1);

    public final Label clickable() {
        return this.clickable(true);
    }

    public final Label clickable(boolean clickable) {
        this.setClickable(clickable);
        return this;
    }

    @Nullable
    public abstract Consumer<Label> getOnClick();

    public abstract void setOnClick(@Nullable Consumer<Label> var1);

    public final Label onClick(@Nullable Consumer<Label> onClick) {
        this.setOnClick(onClick);
        return this;
    }

    @Nullable
    public abstract BiConsumer<MatrixStack, Label> getOnRender();

    public abstract void setOnRender(@Nullable BiConsumer<MatrixStack, Label> var1);

    public final Label onRender(@Nullable BiConsumer<MatrixStack, Label> onRender) {
        this.setOnRender(onRender);
        return this;
    }

    public abstract boolean isFocusable();

    public abstract void setFocusable(boolean var1);

    public final Label focusable(boolean focusable) {
        this.setFocusable(focusable);
        return this;
    }

    @Nullable
    public abstract String getTooltip();

    public abstract void setTooltip(@Nullable @Nullable Function<Label, @Nullable String> var1);

    public final Label tooltipLines(String ... tooltip) {
        return this.tooltipLine(String.join((CharSequence)"\n", tooltip));
    }

    public final Label tooltipLine(String tooltip) {
        return this.tooltipSupplier(label -> tooltip);
    }

    public final Label tooltipSupplier(@Nullable @Nullable Function<Label, @Nullable String> tooltip) {
        this.setTooltip(tooltip);
        return this;
    }

    public abstract int getHorizontalAlignment();

    public final Label centered() {
        return this.horizontalAlignment(0);
    }

    public final Label leftAligned() {
        return this.horizontalAlignment(-1);
    }

    public final Label rightAligned() {
        return this.horizontalAlignment(1);
    }

    public abstract void setHorizontalAlignment(int var1);

    public final Label horizontalAlignment(int horizontalAlignment) {
        this.setHorizontalAlignment(horizontalAlignment);
        return this;
    }

    public abstract boolean hasShadow();

    public final Label noShadow() {
        return this.shadow(false);
    }

    public final Label shadow() {
        return this.shadow(true);
    }

    public abstract void setShadow(boolean var1);

    public final Label shadow(boolean hasShadow) {
        this.setShadow(hasShadow);
        return this;
    }

    public abstract int getColor();

    public abstract void setColor(int var1);

    public final Label color(int lightModeColor, int darkModeColor) {
        return this.color(REIHelper.getInstance().isDarkThemeEnabled() ? darkModeColor : lightModeColor);
    }

    public final Label color(int color) {
        this.setColor(color);
        return this;
    }

    public abstract int getHoveredColor();

    public abstract void setHoveredColor(int var1);

    public final Label hoveredColor(int lightModeColor, int darkModeColor) {
        return this.hoveredColor(REIHelper.getInstance().isDarkThemeEnabled() ? darkModeColor : lightModeColor);
    }

    public final Label hoveredColor(int color) {
        this.setHoveredColor(color);
        return this;
    }

    public abstract Point getPoint();

    public final int getX() {
        return this.getPoint().getX();
    }

    public final int getY() {
        return this.getPoint().getY();
    }

    public abstract void setPoint(Point var1);

    public final Label point(Point point) {
        this.setPoint(point);
        return this;
    }

    public abstract ITextProperties getMessage();

    public abstract void setMessage(ITextProperties var1);

    public abstract void setRainbow(boolean var1);

    public final Label message(ITextProperties message) {
        this.setMessage(message);
        return this;
    }

    public final Label rainbow(boolean rainbow) {
        this.setRainbow(rainbow);
        return this;
    }
}

