/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.registry.display;

import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.display.LiveDisplayGenerator;
import me.shedaniel.rei.api.client.registry.display.visibility.DisplayVisibilityPredicate;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.registry.RecipeManagerContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface DisplayRegistry
extends RecipeManagerContext<REIClientPlugin> {
    public static DisplayRegistry getInstance() {
        return PluginManager.getClientInstance().get(DisplayRegistry.class);
    }

    public int displaySize();

    public void add(Display var1);

    public Map<CategoryIdentifier<?>, List<Display>> getAll();

    default public <D extends Display> List<D> get(CategoryIdentifier<D> categoryId) {
        return this.getAll().getOrDefault(categoryId, Collections.emptyList());
    }

    public <A extends Display> void registerGlobalDisplayGenerator(LiveDisplayGenerator<A> var1);

    public <A extends Display> void registerDisplayGenerator(CategoryIdentifier<A> var1, LiveDisplayGenerator<A> var2);

    public Map<CategoryIdentifier<?>, List<LiveDisplayGenerator<?>>> getCategoryDisplayGenerators();

    public List<LiveDisplayGenerator<?>> getGlobalDisplayGenerators();

    default public <D extends Display> List<LiveDisplayGenerator<?>> getCategoryDisplayGenerators(CategoryIdentifier<D> categoryId) {
        return this.getCategoryDisplayGenerators().getOrDefault(categoryId, Collections.emptyList());
    }

    public void registerVisibilityPredicate(DisplayVisibilityPredicate var1);

    public boolean isDisplayVisible(Display var1);

    default public boolean isDisplayInvisible(Display display) {
        return !this.isDisplayVisible(display);
    }

    public List<DisplayVisibilityPredicate> getVisibilityPredicates();

    default public <T, D extends Display> void registerFiller(Class<T> typeClass, Function<T, D> filler) {
        this.registerFiller(typeClass, (Predicate<? extends T>)Predicates.alwaysTrue(), filler);
    }

    public <T, D extends Display> void registerFiller(Class<T> var1, Predicate<? extends T> var2, Function<T, D> var3);

    public <T> Collection<Display> tryFillDisplay(T var1);
}

