/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;

public class SpriteRenderer {
    public static RenderPass beginPass() {
        return new RenderPass();
    }

    public static class RenderPass {
        float x1 = 0.0f;
        float x2 = 1.0f;
        float y1 = 0.0f;
        float y2 = 0.0f;
        float z1 = 0.0f;
        float uStart = 0.0f;
        float uEnd = 1.0f;
        float vStart = 0.0f;
        float vEnd = 1.0f;
        int u = 0;
        int v = 1;
        int r = 255;
        int g = 255;
        int b = 255;
        int a = 255;
        int l = 0;
        float nX = 0.0f;
        float nY = 0.0f;
        float nZ = 0.0f;
        TextureAtlasSprite sprite;
        IVertexBuilder consumer;
        IRenderTypeBuffer consumers;
        MatrixStack matrices;
        Matrix4f model;
        Matrix3f normal;
        RenderType layer;

        private RenderPass() {
        }

        public RenderPass setup(IRenderTypeBuffer consumers, RenderType type) {
            this.consumers = consumers;
            this.setup(consumers.getBuffer(type), type);
            return this;
        }

        public RenderPass setup(IVertexBuilder consumer, RenderType type) {
            this.consumer = consumer;
            this.matrices = new MatrixStack();
            this.layer = type;
            return this;
        }

        public RenderPass setup(IRenderTypeBuffer consumers, MatrixStack matrices, RenderType type) {
            this.consumers = consumers;
            this.consumer = consumers.getBuffer(type);
            this.matrices = matrices;
            this.layer = type;
            return this;
        }

        public RenderPass position(Matrix4f model, float x1, float y1, float x2, float y2, float z1) {
            this.position(x1, y1, x2, y2, z1);
            this.model = model;
            return this;
        }

        public RenderPass position(float x1, float y1, float x2, float y2, float z1) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.z1 = z1;
            return this;
        }

        public RenderPass sprite(TextureAtlasSprite sprite) {
            this.uStart = sprite.func_94209_e();
            this.uEnd = sprite.func_94212_f();
            this.vStart = sprite.func_94206_g();
            this.vEnd = sprite.func_94210_h();
            this.sprite = sprite;
            return this;
        }

        public RenderPass sprite(float uStart, float uEnd, float vStart, float vEnd) {
            this.uStart = uStart;
            this.uEnd = uEnd;
            this.vStart = vStart;
            this.vEnd = vEnd;
            return this;
        }

        public RenderPass overlay(int uv) {
            return this.overlay(uv & 0xFFFF, uv >> 16 & 0xFFFF);
        }

        public RenderPass overlay(int u, int v) {
            this.u = u;
            this.v = v;
            return this;
        }

        public RenderPass color(int color) {
            this.r = color >> 16 & 0xFF;
            this.g = color >> 8 & 0xFF;
            this.b = color & 0xFF;
            return this;
        }

        public RenderPass color(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
            return this;
        }

        public RenderPass alpha(int a) {
            this.a = a;
            return this;
        }

        public RenderPass light(int l) {
            this.l = l;
            return this;
        }

        public RenderPass normal(Matrix3f normal, float nX, float nY, float nZ) {
            this.normal(nX, nY, nZ);
            this.normal = normal;
            return this;
        }

        public RenderPass normal(float nX, float nY, float nZ) {
            this.nX = nX;
            this.nY = nY;
            this.nZ = nZ;
            return this;
        }

        public void next() {
            if (this.sprite == null) {
                throw new RuntimeException("Invalid Sprite!");
            }
            this.next(this.sprite.func_195668_m());
        }

        public void next(ResourceLocation texture) {
            if (this.consumer == null) {
                throw new RuntimeException("Invalid VertexConsumer!");
            }
            if (this.matrices == null) {
                throw new RuntimeException("Invalid MatrixStack!");
            }
            if (this.sprite == null) {
                throw new RuntimeException("Invalid Sprite!");
            }
            if (this.model == null) {
                this.model = this.matrices.func_227866_c_().func_227870_a_();
            }
            if (this.normal == null) {
                this.normal = this.matrices.func_227866_c_().func_227872_b_();
            }
            float sX = this.sprite.func_94211_a();
            float sY = this.sprite.func_94216_b();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
            for (float y = this.y1; y < this.y2; y += Math.min(this.y2 - y, sY)) {
                for (float x = this.x1; x < this.x2; x += Math.min(this.x2 - x, sX)) {
                    float nSX = Math.min(this.x2 - x, sX);
                    float nSY = Math.min(this.y2 - y, sY);
                    boolean isOverX = nSX < sX;
                    boolean isOverY = nSY < sY;
                    float dX = 0.0f;
                    float dY = 0.0f;
                    if (isOverX) {
                        dX = (this.uEnd - this.uStart) * (1.0f - nSX / sX);
                    }
                    if (isOverY) {
                        dY = (this.vEnd - this.vStart) * (1.0f - nSY / sY);
                    }
                    this.consumer = this.consumers.getBuffer(this.layer);
                    this.consumer.func_227888_a_(this.model, x, y + nSY, this.z1).func_225586_a_(this.r, this.g, this.b, this.a).func_225583_a_(this.uStart, this.vEnd - dY).func_225585_a_(this.u, this.v).func_227886_a_(this.l).func_227887_a_(this.normal, this.nX, this.nY, this.nZ).func_181675_d();
                    this.consumer.func_227888_a_(this.model, x + nSX, y + nSY, this.z1).func_225586_a_(this.r, this.g, this.b, this.a).func_225583_a_(this.uEnd - dX, this.vEnd - dY).func_225585_a_(this.u, this.v).func_227886_a_(this.l).func_227887_a_(this.normal, this.nX, this.nY, this.nZ).func_181675_d();
                    this.consumer.func_227888_a_(this.model, x + nSX, y, this.z1).func_225586_a_(this.r, this.g, this.b, this.a).func_225583_a_(this.uEnd - dX, this.vStart).func_225585_a_(this.u, this.v).func_227886_a_(this.l).func_227887_a_(this.normal, this.nX, this.nY, this.nZ).func_181675_d();
                    this.consumer.func_227888_a_(this.model, x, y, this.z1).func_225586_a_(this.r, this.g, this.b, this.a).func_225583_a_(this.uStart, this.vStart).func_225585_a_(this.u, this.v).func_227886_a_(this.l).func_227887_a_(this.normal, this.nX, this.nY, this.nZ).func_181675_d();
                }
            }
        }
    }
}

