/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.entry.comparison;

import java.util.Objects;
import java.util.function.ToLongFunction;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.impl.Internals;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

@FunctionalInterface
public interface ItemComparator {
    public static ItemComparator noop() {
        return (context, stack) -> 1L;
    }

    public static ItemComparator itemNbt() {
        ToLongFunction<INBT> nbtHasher = ItemComparator.nbtHasher("Count");
        return (context, stack) -> {
            CompoundNBT tag = stack.func_77978_p();
            return tag == null ? 0L : nbtHasher.applyAsLong((INBT)tag);
        };
    }

    public static ToLongFunction<INBT> nbtHasher(String ... ignoredKeys) {
        return Internals.getNbtHasher(ignoredKeys);
    }

    public long hash(ComparisonContext var1, ItemStack var2);

    default public ItemComparator onlyExact() {
        ItemComparator self = this;
        return (context, stack) -> context.isExact() ? self.hash(context, stack) : 1L;
    }

    default public ItemComparator then(ItemComparator other) {
        Objects.requireNonNull(other);
        ItemComparator self = this;
        return (context, stack) -> {
            long hash = 1L;
            hash = hash * 31L + self.hash(context, stack);
            hash = hash * 31L + other.hash(context, stack);
            return hash;
        };
    }
}

