/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.plugins;

import java.util.Arrays;
import java.util.List;
import me.shedaniel.architectury.utils.EnvExecutor;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.common.plugins.PluginView;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.plugins.REIPluginProvider;
import me.shedaniel.rei.api.common.plugins.REIServerPlugin;
import me.shedaniel.rei.api.common.registry.ParentReloadable;
import me.shedaniel.rei.api.common.registry.Reloadable;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.ClientInternals;
import me.shedaniel.rei.impl.Internals;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

public interface PluginManager<P extends REIPlugin<?>>
extends ParentReloadable<P> {
    @OnlyIn(value=Dist.CLIENT)
    public static PluginManager<REIClientPlugin> getClientInstance() {
        return ClientInternals.getPluginManager();
    }

    public static PluginManager<REIPlugin<?>> getInstance() {
        return Internals.getPluginManager();
    }

    public static PluginManager<REIServerPlugin> getServerInstance() {
        return Internals.getServerPluginManager();
    }

    public static List<PluginManager<? extends REIPlugin<?>>> getActiveInstances() {
        return (List)EnvExecutor.getEnvSpecific(() -> () -> Arrays.asList(PluginManager.getInstance(), PluginManager.getClientInstance(), PluginManager.getServerInstance()), () -> () -> Arrays.asList(PluginManager.getInstance(), PluginManager.getServerInstance()));
    }

    public static boolean areAnyPluginsReloading() {
        return CollectionUtils.anyMatch(PluginManager.getActiveInstances(), PluginManager::arePluginsReloading);
    }

    public boolean arePluginsReloading();

    public <T extends Reloadable<? super P>> T get(Class<T> var1);

    public List<REIPluginProvider<P>> getPluginProviders();

    public Iterable<P> getPlugins();

    @ApiStatus.Internal
    public PluginView<P> view();
}

