/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.plugins;

import java.util.Collection;
import java.util.Collections;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.fluid.FluidSupportProvider;
import me.shedaniel.rei.api.common.plugins.REIPluginProvider;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.OverrideOnly
public interface REIPlugin<P extends REIPlugin<?>>
extends Comparable<REIPlugin<P>>,
REIPluginProvider<P> {
    default public int getPriority() {
        return 0;
    }

    default public String getPluginName() {
        Class<?> self = this.getClass();
        String simpleName = self.getSimpleName();
        return simpleName == null ? self.getName() : simpleName;
    }

    @Override
    default public int compareTo(REIPlugin o) {
        return Double.compare(this.getPriority(), o.getPriority());
    }

    @ApiStatus.OverrideOnly
    default public void registerEntryTypes(EntryTypeRegistry registry) {
    }

    @ApiStatus.OverrideOnly
    default public void registerItemComparators(ItemComparatorRegistry registry) {
    }

    @ApiStatus.OverrideOnly
    default public void registerFluidSupport(FluidSupportProvider support) {
    }

    @ApiStatus.OverrideOnly
    default public void registerDisplaySerializer(DisplaySerializerRegistry registry) {
    }

    @ApiStatus.OverrideOnly
    default public void preRegister() {
    }

    @ApiStatus.OverrideOnly
    default public void postRegister() {
    }

    @Override
    default public Collection<P> provide() {
        return Collections.singletonList(this);
    }
}

