/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.transfer.info;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.transfer.RecipeFinderPopulator;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoContext;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoProvider;
import me.shedaniel.rei.api.common.transfer.info.MenuSerializationContext;
import me.shedaniel.rei.api.common.transfer.info.MenuTransferException;
import me.shedaniel.rei.api.common.transfer.info.clean.InputCleanHandler;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public interface MenuInfo<T extends Container, D extends Display>
extends MenuInfoProvider<T, D> {
    @Override
    default public Optional<MenuInfo<T, D>> provide(CategoryIdentifier<D> categoryId, Class<T> menuClass) {
        return Optional.of(this);
    }

    public RecipeFinderPopulator<T, D> getRecipeFinderPopulator();

    public InputCleanHandler<T, D> getInputCleanHandler();

    public Iterable<SlotAccessor> getInputSlots(MenuInfoContext<T, ?, D> var1);

    public Iterable<SlotAccessor> getInventorySlots(MenuInfoContext<T, ?, D> var1);

    default public void markDirty(MenuInfoContext<T, ? extends ServerPlayerEntity, D> context) {
        ((ServerPlayerEntity)context.getPlayerEntity()).field_71071_by.func_70296_d();
        context.getMenu().func_75142_b();
        Container containerMenu = ((ServerPlayerEntity)context.getPlayerEntity()).field_71070_bA;
        ((ServerPlayerEntity)context.getPlayerEntity()).func_71110_a(containerMenu, containerMenu.func_75138_a());
    }

    default public void validate(MenuInfoContext<T, ?, D> context) throws MenuTransferException {
    }

    default public List<List<ItemStack>> getInputs(MenuInfoContext<T, ?, D> context) {
        if (context.getDisplay() == null) {
            return Collections.emptyList();
        }
        return CollectionUtils.map(context.getDisplay().getInputEntries(), inputEntry -> CollectionUtils.filterAndMap(inputEntry, stack -> stack.getType() == VanillaEntryTypes.ITEM, stack -> (ItemStack)stack.cast().getValue()));
    }

    default public CompoundNBT save(MenuSerializationContext<T, ?, D> context, D display) {
        return DisplaySerializerRegistry.getInstance().save(display.getCategoryIdentifier(), display, new CompoundNBT());
    }

    default public D read(MenuSerializationContext<T, ?, D> context, CompoundNBT tag) {
        return DisplaySerializerRegistry.getInstance().read(context.getCategoryIdentifier(), tag);
    }
}

