/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.transfer.info.simple;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.rei.api.common.display.SimpleMenuDisplay;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoContext;
import me.shedaniel.rei.api.common.transfer.info.MenuTransferException;
import me.shedaniel.rei.api.common.transfer.info.simple.SimplePlayerInventoryMenuInfo;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public interface SimpleGridMenuInfo<T extends Container, D extends SimpleMenuDisplay>
extends SimplePlayerInventoryMenuInfo<T, D> {
    @Override
    default public Iterable<SlotAccessor> getInputSlots(MenuInfoContext<T, ?, D> context) {
        return this.getInputStackSlotIds(context).mapToObj(value -> SlotAccessor.fromSlot(context.getMenu().func_75139_a(value))).collect(Collectors.toList());
    }

    default public IntStream getInputStackSlotIds(MenuInfoContext<T, ?, D> context) {
        return IntStream.range(0, this.getCraftingWidth(context.getMenu()) * this.getCraftingHeight(context.getMenu()) + 1).filter(value -> value != this.getCraftingResultSlotIndex(context.getMenu()));
    }

    public int getCraftingResultSlotIndex(T var1);

    public int getCraftingWidth(T var1);

    public int getCraftingHeight(T var1);

    @Override
    default public void validate(MenuInfoContext<T, ?, D> context) throws MenuTransferException {
        int width = this.getCraftingWidth(context.getMenu());
        int height = this.getCraftingHeight(context.getMenu());
        SimpleMenuDisplay display = (SimpleMenuDisplay)context.getDisplay();
        if (display != null && (display.getWidth() > width || display.getHeight() > height)) {
            throw new MenuTransferException((ITextComponent)new TranslationTextComponent("error.rei.transfer.too_small", new Object[]{width, height}));
        }
    }
}

