/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.shedaniel.architectury.fluid.FluidStack;
import me.shedaniel.architectury.utils.Fraction;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;

public final class EntryIngredients {
    private EntryIngredients() {
    }

    public static EntryIngredient of(IItemProvider stack) {
        return EntryIngredient.of(EntryStacks.of(stack));
    }

    public static EntryIngredient of(ItemStack stack) {
        return EntryIngredient.of(EntryStacks.of(stack));
    }

    public static EntryIngredient of(Fluid fluid) {
        return EntryIngredient.of(EntryStacks.of(fluid));
    }

    public static EntryIngredient of(Fluid fluid, int amount) {
        return EntryIngredient.of(EntryStacks.of(fluid, amount));
    }

    public static EntryIngredient of(Fluid fluid, double amount) {
        return EntryIngredient.of(EntryStacks.of(fluid, amount));
    }

    public static EntryIngredient of(Fluid fluid, Fraction amount) {
        return EntryIngredient.of(EntryStacks.of(fluid, amount));
    }

    public static EntryIngredient of(FluidStack stack) {
        return EntryIngredient.of(EntryStacks.of(stack));
    }

    public static <T> EntryIngredient of(EntryType<T> type, Collection<T> values) {
        return EntryIngredients.of(type.getDefinition(), values);
    }

    public static <T> EntryIngredient of(EntryDefinition<T> definition, Collection<T> values) {
        if (values.size() == 0) {
            return EntryIngredient.empty();
        }
        if (values.size() == 1) {
            return EntryIngredient.of(EntryStack.of(definition, values.iterator().next()));
        }
        EntryIngredient.Builder result = EntryIngredient.builder(values.size());
        for (T value : values) {
            result.add((EntryStack<?>)EntryStack.of(definition, value));
        }
        return result.build();
    }

    public static EntryIngredient ofItems(Collection<IItemProvider> stacks) {
        if (stacks.size() == 0) {
            return EntryIngredient.empty();
        }
        if (stacks.size() == 1) {
            return EntryIngredient.of(EntryStacks.of(stacks.iterator().next()));
        }
        EntryIngredient.Builder result = EntryIngredient.builder(stacks.size());
        for (IItemProvider stack : stacks) {
            result.add((EntryStack<?>)EntryStacks.of(stack));
        }
        return result.build();
    }

    public static EntryIngredient ofItemStacks(Collection<ItemStack> stacks) {
        return EntryIngredients.of(VanillaEntryTypes.ITEM, stacks);
    }

    public static EntryIngredient ofIngredient(Ingredient ingredient) {
        if (ingredient.func_203189_d()) {
            return EntryIngredient.empty();
        }
        ItemStack[] matchingStacks = ingredient.func_193365_a();
        if (matchingStacks.length == 0) {
            return EntryIngredient.empty();
        }
        if (matchingStacks.length == 1) {
            return EntryIngredient.of(EntryStacks.of(matchingStacks[0]));
        }
        EntryIngredient.Builder result = EntryIngredient.builder(matchingStacks.length);
        for (ItemStack matchingStack : matchingStacks) {
            if (matchingStack.func_190926_b()) continue;
            result.add((EntryStack<?>)EntryStacks.of(matchingStack));
        }
        return result.build();
    }

    public static List<EntryIngredient> ofIngredients(List<Ingredient> ingredients) {
        if (ingredients.size() == 0) {
            return Collections.emptyList();
        }
        if (ingredients.size() == 1) {
            Ingredient ingredient = ingredients.get(0);
            if (ingredient.func_203189_d()) {
                return Collections.emptyList();
            }
            return Collections.singletonList(EntryIngredients.ofIngredient(ingredient));
        }
        boolean emptyFlag = true;
        ArrayList<EntryIngredient> result = new ArrayList<EntryIngredient>(ingredients.size());
        for (int i = ingredients.size() - 1; i >= 0; --i) {
            Ingredient ingredient = ingredients.get(i);
            if (emptyFlag && ingredient.func_203189_d()) continue;
            result.add(0, EntryIngredients.ofIngredient(ingredient));
            emptyFlag = false;
        }
        return ImmutableList.copyOf(result);
    }

    public static <T> boolean testFuzzy(EntryIngredient ingredient, EntryStack<T> stack) {
        for (EntryStack ingredientStack : ingredient) {
            if (!EntryStacks.equalsFuzzy(ingredientStack, stack)) continue;
            return true;
        }
        return false;
    }

    public static ListNBT save(List<EntryIngredient> ingredients) {
        ListNBT listTag = new ListNBT();
        for (EntryIngredient ingredient : ingredients) {
            listTag.add((Object)ingredient.save());
        }
        return listTag;
    }

    public static List<EntryIngredient> read(ListNBT listTag) {
        if (listTag.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableList.Builder ingredients = ImmutableList.builder();
        for (INBT tag : listTag) {
            ingredients.add((Object)EntryIngredient.read((ListNBT)tag));
        }
        return ingredients.build();
    }
}

