/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.forge;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.rei.RoughlyEnoughItemsInitializer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.Type;

@Mod(value="roughlyenoughitems")
@ApiStatus.Internal
public class RoughlyEnoughItemsForge {
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"REI");

    public RoughlyEnoughItemsForge() {
        RoughlyEnoughItemsInitializer.onInitialize();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> RoughlyEnoughItemsInitializer::onInitializeClient);
    }

    public static <A, T> void scanAnnotation(Class<A> clazz, Predicate<Class<T>> predicate, BiConsumer<List<String>, Supplier<T>> consumer) {
        RoughlyEnoughItemsForge.scanAnnotation(Type.getType(clazz), predicate, consumer);
    }

    public static <T> void scanAnnotation(Type annotationType, Predicate<Class<T>> predicate, BiConsumer<List<String>, Supplier<T>> consumer) {
        ArrayList instances = Lists.newArrayList();
        for (ModFileScanData data : ModList.get().getAllScanData()) {
            List modIds = data.getIModInfoData().stream().flatMap(info -> info.getMods().stream()).map(IModInfo::getModId).collect(Collectors.toList());
            for (ModFileScanData.AnnotationData annotation : data.getAnnotations()) {
                if (!annotationType.equals((Object)annotation.getAnnotationType())) continue;
                try {
                    Class<?> clazz = Class.forName(annotation.getMemberName());
                    if (!predicate.test(clazz)) continue;
                    instances.add(new ImmutablePair(modIds, () -> {
                        try {
                            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (Throwable throwable) {
                            LOGGER.error("Failed to load plugin: " + annotation.getMemberName(), throwable);
                            return null;
                        }
                    }));
                }
                catch (Throwable throwable) {
                    LOGGER.error("Failed to load plugin: " + annotation.getMemberName(), throwable);
                }
            }
        }
        for (Pair pair : instances) {
            consumer.accept((List<String>)pair.getLeft(), (Supplier<List<String>>)pair.getRight());
        }
    }
}

