/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client;

import io.netty.buffer.Unpooled;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.REIHelper;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.DisplayScreenType;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.client.view.Views;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.ClientInternals;
import me.shedaniel.rei.impl.client.REIHelperImpl;
import me.shedaniel.rei.impl.client.gui.screen.CompositeDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.screen.DefaultDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.screen.UncertainDisplayViewingScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class ClientHelperImpl
implements ClientHelper {
    @ApiStatus.Internal
    public final LazyValue<Boolean> isYog = new LazyValue(() -> {
        try {
            if (Minecraft.func_71410_x().func_110432_I().func_148256_e().getId().equals(UUID.fromString("f9546389-9415-4358-9c29-2c26b25bff5b"))) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    });
    @ApiStatus.Internal
    public final LazyValue<Boolean> isAprilFools = new LazyValue(() -> {
        try {
            LocalDateTime now = LocalDateTime.now();
            return now.getMonthValue() == 4 && now.getDayOfMonth() == 1;
        }
        catch (Throwable throwable) {
            return false;
        }
    });
    private final Map<String, String> modNameCache = new HashMap<String, String>(){
        {
            this.put("minecraft", "Minecraft");
            this.put("c", "Global");
            this.put("global", "Global");
        }
    };

    @ApiStatus.Internal
    public static ClientHelperImpl getInstance() {
        return (ClientHelperImpl)ClientHelper.getInstance();
    }

    public boolean hasPermissionToUsePackets() {
        try {
            Minecraft.func_71410_x().func_147114_u().func_195513_b().func_197034_c(0);
            return this.hasOperatorPermission() && this.canUsePackets();
        }
        catch (NullPointerException e) {
            return true;
        }
    }

    public boolean hasOperatorPermission() {
        try {
            return Minecraft.func_71410_x().func_147114_u().func_195513_b().func_197034_c(1);
        }
        catch (NullPointerException e) {
            return true;
        }
    }

    public boolean canUsePackets() {
        return NetworkManager.canServerReceive((ResourceLocation)RoughlyEnoughItemsNetwork.CREATE_ITEMS_PACKET) && NetworkManager.canServerReceive((ResourceLocation)RoughlyEnoughItemsNetwork.CREATE_ITEMS_GRAB_PACKET) && NetworkManager.canServerReceive((ResourceLocation)RoughlyEnoughItemsNetwork.DELETE_ITEMS_PACKET);
    }

    public boolean canDeleteItems() {
        return this.hasPermissionToUsePackets() || Minecraft.func_71410_x().field_71442_b.func_78758_h();
    }

    @Override
    public String getModFromModId(String modId) {
        if (modId == null) {
            return "";
        }
        String any = this.modNameCache.getOrDefault(modId, null);
        if (any != null) {
            return any;
        }
        if (Platform.isModLoaded((String)modId)) {
            String modName = Platform.getMod((String)modId).getName();
            this.modNameCache.put(modId, modName);
            return modName;
        }
        return modId;
    }

    @Override
    public boolean isCheating() {
        return ConfigObject.getInstance().isCheating();
    }

    @Override
    public void setCheating(boolean cheating) {
        ConfigObject.getInstance().setCheating(cheating);
        ConfigManager.getInstance().saveConfig();
    }

    @Override
    public void sendDeletePacket() {
        if (Minecraft.func_71410_x().field_71462_r instanceof CreativeScreen) {
            Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70437_b(ItemStack.field_190927_a);
            ((CreativeScreen)Minecraft.func_71410_x().field_71462_r).field_147007_t = false;
            return;
        }
        NetworkManager.sendToServer((ResourceLocation)RoughlyEnoughItemsNetwork.DELETE_ITEMS_PACKET, (PacketBuffer)new PacketBuffer(Unpooled.buffer()));
        if (Minecraft.func_71410_x().field_71462_r instanceof ContainerScreen) {
            ((ContainerScreen)Minecraft.func_71410_x().field_71462_r).field_147007_t = false;
        }
    }

    @Override
    public boolean tryCheatingEntry(EntryStack<?> e) {
        if (e.getType() != VanillaEntryTypes.ITEM) {
            return false;
        }
        EntryStack<?> entry = e;
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return false;
        }
        if (Minecraft.func_71410_x().field_71439_g.field_71071_by == null) {
            return false;
        }
        ItemStack cheatedStack = ((ItemStack)entry.getValue()).func_77946_l();
        if (ConfigObject.getInstance().isGrabbingItems() && Minecraft.func_71410_x().field_71462_r instanceof CreativeScreen) {
            PlayerInventory inventory = Minecraft.func_71410_x().field_71439_g.field_71071_by;
            EntryStack<?> stack = entry.copy();
            if (!inventory.func_70445_o().func_190926_b() && EntryStacks.equalsExact(EntryStacks.of(inventory.func_70445_o()), stack)) {
                ((ItemStack)stack.getValue()).func_190920_e(MathHelper.func_76125_a((int)(((ItemStack)stack.getValue()).func_190916_E() + inventory.func_70445_o().func_190916_E()), (int)1, (int)((ItemStack)stack.getValue()).func_77976_d()));
            } else if (!inventory.func_70445_o().func_190926_b()) {
                return false;
            }
            inventory.func_70437_b(((ItemStack)stack.getValue()).func_77946_l());
            return true;
        }
        if (ClientHelperImpl.getInstance().canUsePackets()) {
            PlayerInventory inventory = Minecraft.func_71410_x().field_71439_g.field_71071_by;
            EntryStack<?> stack = entry.copy();
            if (!inventory.func_70445_o().func_190926_b() && !EntryStacks.equalsExact(EntryStacks.of(inventory.func_70445_o()), stack)) {
                return false;
            }
            try {
                NetworkManager.sendToServer((ResourceLocation)(ConfigObject.getInstance().isGrabbingItems() ? RoughlyEnoughItemsNetwork.CREATE_ITEMS_GRAB_PACKET : RoughlyEnoughItemsNetwork.CREATE_ITEMS_PACKET), (PacketBuffer)new PacketBuffer(Unpooled.buffer()).func_150788_a(cheatedStack));
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        ResourceLocation identifier = entry.getIdentifier();
        if (identifier == null) {
            return false;
        }
        String tagMessage = cheatedStack.func_77946_l().func_77978_p() != null && !cheatedStack.func_77946_l().func_77978_p().isEmpty() ? cheatedStack.func_77946_l().func_77978_p().func_150285_a_() : "";
        String og = cheatedStack.func_190916_E() == 1 ? ConfigObject.getInstance().getGiveCommand().replaceAll(" \\{count}", "") : ConfigObject.getInstance().getGiveCommand();
        String madeUpCommand = og.replaceAll("\\{player_name}", Minecraft.func_71410_x().field_71439_g.func_195047_I_()).replaceAll("\\{item_name}", identifier.func_110623_a()).replaceAll("\\{item_identifier}", identifier.toString()).replaceAll("\\{nbt}", tagMessage).replaceAll("\\{count}", String.valueOf(cheatedStack.func_190916_E()));
        if (madeUpCommand.length() > 256) {
            madeUpCommand = og.replaceAll("\\{player_name}", Minecraft.func_71410_x().field_71439_g.func_195047_I_()).replaceAll("\\{item_name}", identifier.func_110623_a()).replaceAll("\\{item_identifier}", identifier.toString()).replaceAll("\\{nbt}", "").replaceAll("\\{count}", String.valueOf(cheatedStack.func_190916_E()));
            Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("text.rei.too_long_nbt"), false);
        }
        Minecraft.func_71410_x().field_71439_g.func_71165_d(madeUpCommand);
        return true;
    }

    @ApiStatus.Internal
    public Set<EntryStack<?>> _getInventoryItemsTypes() {
        return Minecraft.func_71410_x().field_71439_g.field_71071_by.field_184440_g.stream().flatMap(Collection::stream).map(EntryStacks::of).collect(Collectors.toSet());
    }

    @ApiStatus.Internal
    public void openRecipeViewingScreen(Map<DisplayCategory<?>, List<Display>> map, @Nullable CategoryIdentifier<?> category, @Nullable EntryStack<?> ingredientNotice, @Nullable EntryStack<?> resultNotice) {
        this.openView(new LegacyWrapperViewSearchBuilder(map).setPreferredOpenedCategory(category).setInputNotice(ingredientNotice).setOutputNotice(resultNotice).fillPreferredOpenedCategory());
    }

    @Override
    public boolean openView(ViewSearchBuilder builder) {
        Map<DisplayCategory<?>, List<Display>> map = builder.buildMap();
        if (map.isEmpty()) {
            return false;
        }
        Screen screen = ConfigObject.getInstance().getRecipeScreenType() == DisplayScreenType.COMPOSITE ? new CompositeDisplayViewingScreen(map, builder.getPreferredOpenedCategory()) : (ConfigObject.getInstance().getRecipeScreenType() == DisplayScreenType.UNSET ? new UncertainDisplayViewingScreen(REIHelper.getInstance().getPreviousScreen(), DisplayScreenType.UNSET, true, original -> {
            ConfigObject.getInstance().setRecipeScreenType(original ? DisplayScreenType.ORIGINAL : DisplayScreenType.COMPOSITE);
            ConfigManager.getInstance().saveConfig();
            this.openView(builder);
        }) : new DefaultDisplayViewingScreen(map, builder.getPreferredOpenedCategory()));
        if (screen instanceof DisplayScreen) {
            if (builder.getInputNotice() != null) {
                ((DisplayScreen)screen).setIngredientStackToNotice(builder.getInputNotice());
            }
            if (builder.getOutputNotice() != null) {
                ((DisplayScreen)screen).setResultStackToNotice(builder.getOutputNotice());
            }
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof DisplayScreen) {
            REIHelperImpl.getInstance().storeDisplayScreen((DisplayScreen)Minecraft.func_71410_x().field_71462_r);
        }
        Minecraft.func_71410_x().func_147108_a(screen);
        return true;
    }

    @Override
    public boolean canUseMovePackets() {
        return NetworkManager.canServerReceive((ResourceLocation)RoughlyEnoughItemsNetwork.MOVE_ITEMS_PACKET);
    }

    public void onInitializeClient() {
        ClientInternals.attachInstance(this, ClientHelper.class);
        ClientInternals.attachInstance(ViewSearchBuilderImpl::new, "viewSearchBuilder");
    }

    public static final class LegacyWrapperViewSearchBuilder
    extends AbstractViewSearchBuilder {
        private final Map<DisplayCategory<?>, List<Display>> map;
        @Nullable
        private CategoryIdentifier<?> preferredOpenedCategory = null;
        @Nullable
        private EntryStack<?> inputNotice;
        @Nullable
        private EntryStack<?> outputNotice;

        public LegacyWrapperViewSearchBuilder(Map<DisplayCategory<?>, List<Display>> map) {
            this.map = map;
        }

        @Override
        public ViewSearchBuilder addCategory(CategoryIdentifier<?> category) {
            return this;
        }

        @Override
        public ViewSearchBuilder addCategories(Collection<CategoryIdentifier<?>> categories) {
            return this;
        }

        @Override
        public Set<CategoryIdentifier<?>> getCategories() {
            return Collections.emptySet();
        }

        @Override
        public <T> ViewSearchBuilder addRecipesFor(EntryStack<T> stack) {
            return this;
        }

        @Override
        public List<EntryStack<?>> getRecipesFor() {
            return Collections.emptyList();
        }

        @Override
        public <T> ViewSearchBuilder addUsagesFor(EntryStack<T> stack) {
            return this;
        }

        @Override
        public List<EntryStack<?>> getUsagesFor() {
            return Collections.emptyList();
        }

        @Override
        public ViewSearchBuilder setPreferredOpenedCategory(@Nullable CategoryIdentifier<?> category) {
            this.preferredOpenedCategory = category;
            return this;
        }

        @Override
        @Nullable
        public CategoryIdentifier<?> getPreferredOpenedCategory() {
            return this.preferredOpenedCategory;
        }

        @Override
        public <T> ViewSearchBuilder setInputNotice(@Nullable EntryStack<T> stack) {
            this.inputNotice = stack;
            return this;
        }

        @Override
        @Nullable
        public EntryStack<?> getInputNotice() {
            return this.inputNotice;
        }

        @Override
        public <T> ViewSearchBuilder setOutputNotice(@Nullable EntryStack<T> stack) {
            this.outputNotice = stack;
            return this;
        }

        @Override
        @Nullable
        public EntryStack<?> getOutputNotice() {
            return this.outputNotice;
        }

        @Override
        public Map<DisplayCategory<?>, List<Display>> buildMap() {
            return this.map;
        }
    }

    public static final class ViewSearchBuilderImpl
    extends AbstractViewSearchBuilder {
        private final Set<CategoryIdentifier<?>> categories = new HashSet();
        private final List<EntryStack<?>> recipesFor = new ArrayList();
        private final List<EntryStack<?>> usagesFor = new ArrayList();
        @Nullable
        private CategoryIdentifier<?> preferredOpenedCategory = null;
        @Nullable
        private EntryStack<?> inputNotice;
        @Nullable
        private EntryStack<?> outputNotice;
        private final LazyValue<Map<DisplayCategory<?>, List<Display>>> map = new LazyValue(() -> Views.getInstance().buildMapFor(this));

        @Override
        public ViewSearchBuilder addCategory(CategoryIdentifier<?> category) {
            this.categories.add(category);
            return this;
        }

        @Override
        public ViewSearchBuilder addCategories(Collection<CategoryIdentifier<?>> categories) {
            this.categories.addAll(categories);
            return this;
        }

        @Override
        public Set<CategoryIdentifier<?>> getCategories() {
            return this.categories;
        }

        @Override
        public <T> ViewSearchBuilder addRecipesFor(EntryStack<T> stack) {
            this.recipesFor.add(stack);
            return this;
        }

        @Override
        public List<EntryStack<?>> getRecipesFor() {
            return this.recipesFor;
        }

        @Override
        public <T> ViewSearchBuilder addUsagesFor(EntryStack<T> stack) {
            this.usagesFor.add(stack);
            return this;
        }

        @Override
        public List<EntryStack<?>> getUsagesFor() {
            return this.usagesFor;
        }

        @Override
        public ViewSearchBuilder setPreferredOpenedCategory(@Nullable CategoryIdentifier<?> category) {
            this.preferredOpenedCategory = category;
            return this;
        }

        @Override
        @Nullable
        public CategoryIdentifier<?> getPreferredOpenedCategory() {
            return this.preferredOpenedCategory;
        }

        @Override
        public <T> ViewSearchBuilder setInputNotice(@Nullable EntryStack<T> stack) {
            this.inputNotice = stack;
            return this;
        }

        @Override
        @Nullable
        public EntryStack<?> getInputNotice() {
            return this.inputNotice;
        }

        @Override
        public <T> ViewSearchBuilder setOutputNotice(@Nullable EntryStack<T> stack) {
            this.outputNotice = stack;
            return this;
        }

        @Override
        @Nullable
        public EntryStack<?> getOutputNotice() {
            return this.outputNotice;
        }

        @Override
        public Map<DisplayCategory<?>, List<Display>> buildMap() {
            return (Map)this.map.func_179281_c();
        }
    }

    private static abstract class AbstractViewSearchBuilder
    implements ViewSearchBuilder {
        private AbstractViewSearchBuilder() {
        }

        @Override
        public ViewSearchBuilder fillPreferredOpenedCategory() {
            Screen currentScreen;
            if (this.getPreferredOpenedCategory() == null && (currentScreen = Minecraft.func_71410_x().field_71462_r) instanceof DisplayScreen) {
                this.setPreferredOpenedCategory(((DisplayScreen)currentScreen).getCurrentCategoryId());
            }
            return this;
        }
    }
}

