/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.config;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.shedaniel.architectury.hooks.ScreenHooks;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.gui.ConfigScreenProvider;
import me.shedaniel.autoconfig.gui.registry.GuiRegistry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.util.Utils;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Jankson;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonElement;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonNull;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonObject;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonPrimitive;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.api.DeserializationException;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.api.Modifier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.clothconfig2.gui.entries.KeyCodeEntry;
import me.shedaniel.clothconfig2.impl.EasingMethod;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.client.REIHelper;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.gui.config.DisplayScreenType;
import me.shedaniel.rei.api.client.gui.config.SyntaxHighlightingMode;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.REIHelperImpl;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.config.entries.FilteringEntry;
import me.shedaniel.rei.impl.client.config.entries.NoFilteringEntry;
import me.shedaniel.rei.impl.client.config.entries.RecipeScreenTypeEntry;
import me.shedaniel.rei.impl.client.config.entries.ReloadPluginsEntry;
import me.shedaniel.rei.impl.client.config.entries.SearchFilterSyntaxHighlightingEntry;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.impl.client.entry.filtering.rules.ManualFilteringRule;
import me.shedaniel.rei.impl.client.gui.ContainerScreenOverlay;
import me.shedaniel.rei.impl.client.gui.credits.CreditsScreen;
import me.shedaniel.rei.impl.client.gui.screen.TransformingScreen;
import me.shedaniel.rei.impl.client.gui.screen.WarningAndErrorScreen;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Tuple;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class ConfigManagerImpl
implements ConfigManager {
    private boolean craftableOnly = false;
    private final Gson gson = new GsonBuilder().create();
    private ConfigObjectImpl object;

    public ConfigManagerImpl() {
        Jankson jankson = Jankson.builder().build();
        AutoConfig.register(ConfigObjectImpl.class, (definition, configClass) -> new JanksonConfigSerializer(definition, configClass, ConfigManagerImpl.buildJankson(Jankson.builder())));
        GuiRegistry guiRegistry = AutoConfig.getGuiRegistry(ConfigObjectImpl.class);
        guiRegistry.registerPredicateProvider((i13n, field, config, defaults, guiProvider) -> {
            if (field.isAnnotationPresent(ConfigEntry.Gui.Excluded.class)) {
                return Collections.emptyList();
            }
            KeyCodeEntry entry = ConfigEntryBuilder.create().startModifierKeyCodeField((ITextComponent)new TranslationTextComponent(i13n), (ModifierKeyCode)Utils.getUnsafely((Field)field, (Object)config, (Object)ModifierKeyCode.unknown())).setModifierDefaultValue(() -> (ModifierKeyCode)Utils.getUnsafely((Field)field, (Object)defaults)).setModifierSaveConsumer(newValue -> Utils.setUnsafely((Field)field, (Object)config, (Object)newValue)).build();
            return Collections.singletonList(entry);
        }, field -> field.getType() == ModifierKeyCode.class);
        guiRegistry.registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> {
            ConfigObjectImpl.UsePercentage bounds = field.getAnnotation(ConfigObjectImpl.UsePercentage.class);
            return Collections.singletonList(ConfigEntryBuilder.create().startIntSlider((ITextComponent)new TranslationTextComponent(i13n), MathHelper.func_76143_f((double)((Double)Utils.getUnsafely((Field)field, (Object)config, (Object)0.0) * 100.0)), MathHelper.func_76143_f((double)(bounds.min() * 100.0)), MathHelper.func_76143_f((double)(bounds.max() * 100.0))).setDefaultValue(() -> MathHelper.func_76143_f((double)((Double)Utils.getUnsafely((Field)field, (Object)defaults) * 100.0))).setSaveConsumer(newValue -> Utils.setUnsafely((Field)field, (Object)config, (Object)((double)newValue.intValue() / 100.0))).setTextGetter(integer -> new StringTextComponent(bounds.prefix() + String.format("%d%%", integer))).build());
        }, field -> field.getType() == Double.TYPE || field.getType() == Double.class, new Class[]{ConfigObjectImpl.UsePercentage.class});
        guiRegistry.registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> Collections.singletonList(new RecipeScreenTypeEntry(220, (ITextComponent)new TranslationTextComponent(i13n), (DisplayScreenType)((Object)((Object)Utils.getUnsafely((Field)field, (Object)config, (Object)((Object)DisplayScreenType.UNSET)))), (DisplayScreenType)((Object)((Object)Utils.getUnsafely((Field)field, (Object)defaults))), type -> Utils.setUnsafely((Field)field, (Object)config, (Object)type))), field -> field.getType() == DisplayScreenType.class, new Class[]{ConfigObjectImpl.UseSpecialRecipeTypeScreen.class});
        guiRegistry.registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> Collections.singletonList(new SearchFilterSyntaxHighlightingEntry((ITextComponent)new TranslationTextComponent(i13n), (SyntaxHighlightingMode)((Object)((Object)Utils.getUnsafely((Field)field, (Object)config, (Object)((Object)SyntaxHighlightingMode.COLORFUL)))), (SyntaxHighlightingMode)((Object)((Object)Utils.getUnsafely((Field)field, (Object)defaults))), type -> Utils.setUnsafely((Field)field, (Object)config, (Object)type))), field -> field.getType() == SyntaxHighlightingMode.class, new Class[]{ConfigObjectImpl.UseSpecialSearchFilterSyntaxHighlightingScreen.class});
        guiRegistry.registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> REIHelper.getInstance().getPreviousContainerScreen() == null || Minecraft.func_71410_x().func_147114_u() == null || Minecraft.func_71410_x().func_147114_u().func_199526_e() == null ? Collections.singletonList(new NoFilteringEntry(220, (List)Utils.getUnsafely((Field)field, (Object)config, new ArrayList()), (List)Utils.getUnsafely((Field)field, (Object)defaults), list -> Utils.setUnsafely((Field)field, (Object)config, (Object)list))) : Collections.singletonList(new FilteringEntry(220, (List)Utils.getUnsafely((Field)field, (Object)config, new ArrayList()), ((ConfigObjectImpl.Advanced.Filtering)config).filteringRules, (List)Utils.getUnsafely((Field)field, (Object)defaults), list -> Utils.setUnsafely((Field)field, (Object)config, (Object)list), list -> {
            ((ConfigObjectImpl.Advanced.Filtering)config).filteringRules = Lists.newArrayList((Iterable)list);
        })), field -> field.getType() == List.class, new Class[]{ConfigObjectImpl.UseFilteringScreen.class});
        this.saveConfig();
        RoughlyEnoughItemsCore.LOGGER.info("Config loaded.");
    }

    private static Jankson buildJankson(Jankson.Builder builder) {
        builder.registerSerializer(InputMappings.Input.class, (value, marshaller) -> new JsonPrimitive((Object)value.func_197935_d()));
        builder.registerDeserializer(String.class, InputMappings.Input.class, (value, marshaller) -> InputMappings.func_197955_a((String)value));
        builder.registerSerializer(ModifierKeyCode.class, (value, marshaller) -> {
            JsonObject object = new JsonObject();
            object.put("keyCode", (JsonElement)new JsonPrimitive((Object)value.getKeyCode().func_197935_d()));
            object.put("modifier", (JsonElement)new JsonPrimitive((Object)value.getModifier().getValue()));
            return object;
        });
        builder.registerDeserializer(JsonObject.class, ModifierKeyCode.class, (value, marshaller) -> {
            String code = (String)value.get(String.class, "keyCode");
            if (code.endsWith(".unknown")) {
                return ModifierKeyCode.unknown();
            }
            InputMappings.Input keyCode = InputMappings.func_197955_a((String)code);
            Modifier modifier = Modifier.of((short)value.getShort("modifier", (short)0));
            return ModifierKeyCode.of((InputMappings.Input)keyCode, (Modifier)modifier);
        });
        builder.registerSerializer(INBT.class, (value, marshaller) -> marshaller.serialize((Object)value.toString()));
        builder.registerDeserializer(String.class, INBT.class, (value, marshaller) -> {
            try {
                return JsonToNBT.func_180713_a((String)value);
            }
            catch (CommandSyntaxException e) {
                throw new DeserializationException((Throwable)e);
            }
        });
        builder.registerSerializer(EntryStack.class, (stack, marshaller) -> {
            try {
                return marshaller.serialize((Object)stack.save());
            }
            catch (Exception e) {
                e.printStackTrace();
                return JsonNull.INSTANCE;
            }
        });
        builder.registerDeserializer(INBT.class, EntryStack.class, (value, marshaller) -> {
            try {
                return EntryStack.read((CompoundNBT)value);
            }
            catch (Exception e) {
                e.printStackTrace();
                return EntryStack.empty();
            }
        });
        builder.registerDeserializer(String.class, EntryStack.class, (value, marshaller) -> {
            try {
                return EntryStack.read(JsonToNBT.func_180713_a((String)value));
            }
            catch (Exception e) {
                e.printStackTrace();
                return EntryStack.empty();
            }
        });
        builder.registerSerializer(FilteringRule.class, (value, marshaller) -> {
            try {
                return marshaller.serialize((Object)FilteringRule.save(value, new CompoundNBT()));
            }
            catch (Exception e) {
                e.printStackTrace();
                return JsonNull.INSTANCE;
            }
        });
        builder.registerDeserializer(INBT.class, FilteringRule.class, (value, marshaller) -> {
            try {
                return FilteringRule.read((CompoundNBT)value);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
        builder.registerDeserializer(String.class, FilteringRule.class, (value, marshaller) -> {
            try {
                return FilteringRule.read(JsonToNBT.func_180713_a((String)value));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
        builder.registerSerializer(FavoriteEntry.class, (value, marshaller) -> {
            try {
                return marshaller.serialize((Object)value.save(new CompoundNBT()));
            }
            catch (Exception e) {
                e.printStackTrace();
                return JsonNull.INSTANCE;
            }
        });
        builder.registerDeserializer(INBT.class, FavoriteEntry.class, (value, marshaller) -> {
            try {
                return FavoriteEntry.delegate(() -> FavoriteEntry.read((CompoundNBT)value), () -> (CompoundNBT)value);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
        builder.registerDeserializer(String.class, FavoriteEntry.class, (value, marshaller) -> {
            try {
                CompoundNBT tag = JsonToNBT.func_180713_a((String)value);
                return FavoriteEntry.delegate(() -> FavoriteEntry.read(tag), () -> tag);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
        return builder.build();
    }

    @Override
    public void startReload() {
    }

    public static ConfigManagerImpl getInstance() {
        return (ConfigManagerImpl)ConfigManager.getInstance();
    }

    @Override
    public void saveConfig() {
        if (this.getConfig().getFavoriteEntries() != null) {
            this.getConfig().getFavoriteEntries().removeIf(Objects::isNull);
        }
        if (this.getConfig().getFilteredStacks() != null) {
            this.getConfig().getFilteredStacks().removeIf(EntryStack::isEmpty);
            List<EntryStack> normalizedFilteredStacks = CollectionUtils.map(this.getConfig().getFilteredStacks(), EntryStack::normalize);
            this.getConfig().getFilteredStacks().clear();
            this.getConfig().getFilteredStacks().addAll(normalizedFilteredStacks);
        }
        if (this.getConfig().getFilteringRules().stream().noneMatch(filteringRule -> filteringRule instanceof ManualFilteringRule)) {
            this.getConfig().getFilteringRules().add(new ManualFilteringRule());
        }
        AutoConfig.getConfigHolder(ConfigObjectImpl.class).registerLoadListener((configHolder, configObject) -> {
            this.object = configObject;
            return ActionResultType.PASS;
        });
        AutoConfig.getConfigHolder(ConfigObjectImpl.class).save();
    }

    @Override
    public ConfigObjectImpl getConfig() {
        if (this.object == null) {
            this.object = (ConfigObjectImpl)AutoConfig.getConfigHolder(ConfigObjectImpl.class).getConfig();
        }
        return this.object;
    }

    @Override
    public boolean isCraftableOnlyEnabled() {
        return this.craftableOnly;
    }

    @Override
    public void toggleCraftableOnly() {
        this.craftableOnly = !this.craftableOnly;
    }

    @Override
    public Screen getConfigScreen(Screen parent) {
        try {
            if (Platform.isFabric() && !this.detectWorkingOptifabric()) {
                ArrayList warnings = Lists.newArrayList();
                warnings.add(new Tuple((Object)I18n.func_135052_a((String)"text.rei.config.optifine.title", (Object[])new Object[0]), null));
                warnings.add(new Tuple((Object)I18n.func_135052_a((String)"text.rei.config.optifine.description", (Object[])new Object[0]), null));
                WarningAndErrorScreen screen = new WarningAndErrorScreen("config screen", warnings, Collections.emptyList(), arg_0 -> ((Minecraft)Minecraft.func_71410_x()).func_147108_a(arg_0));
                screen.setParent(parent);
                return screen;
            }
            MutableLong current = new MutableLong(0L);
            TransformingScreen parentTranslated = new TransformingScreen(true, parent, null, () -> current.setValue(current.getValue() == 0L ? Util.func_211177_b() + (long)(!this.getConfig().isConfigScreenAnimated() ? -3000 : 0) : current.getValue()), () -> 0.0, () -> EasingMethod.EasingMethodImpl.EXPO.apply(MathHelper.func_151237_a((double)((double)(Util.func_211177_b() - current.getValue()) / 750.0), (double)0.0, (double)1.0)) * (double)Minecraft.func_71410_x().func_228018_at_().func_198087_p(), () -> Util.func_211177_b() - current.getValue() > 800L);
            parentTranslated.setInitAfter(true);
            ConfigScreenProvider provider = (ConfigScreenProvider)AutoConfig.getConfigScreen(ConfigObjectImpl.class, (Screen)parentTranslated);
            provider.setI13nFunction(manager -> "config.roughlyenoughitems");
            provider.setOptionFunction((baseI13n, field) -> field.isAnnotationPresent(ConfigObjectImpl.DontApplyFieldName.class) ? baseI13n : String.format("%s.%s", baseI13n, field.getName()));
            provider.setCategoryFunction((baseI13n, categoryName) -> String.format("%s.%s", baseI13n, categoryName));
            provider.setBuildFunction(builder -> {
                builder.setGlobalized(true);
                builder.setGlobalizedExpanded(false);
                if (Minecraft.func_71410_x().func_147114_u() != null && Minecraft.func_71410_x().func_147114_u().func_199526_e() != null) {
                    builder.getOrCreateCategory((ITextComponent)new TranslationTextComponent("config.roughlyenoughitems.advanced")).getEntries().add(0, new ReloadPluginsEntry(220));
                }
                return builder.setAfterInitConsumer(screen -> ScreenHooks.addButton((Screen)screen, (Widget)new Button(screen.field_230708_k_ - 104, 4, 100, 20, (ITextComponent)new TranslationTextComponent("text.rei.credits"), button -> {
                    MutableLong current = new MutableLong(0L);
                    CreditsScreen creditsScreen = new CreditsScreen((Screen)screen);
                    Minecraft.func_71410_x().func_147108_a((Screen)new TransformingScreen(false, creditsScreen, (Screen)screen, () -> current.setValue(current.getValue() == 0L ? Util.func_211177_b() + (long)(!this.getConfig().isCreditsScreenAnimated() ? -3000 : 0) : current.getValue()), () -> (1.0 - EasingMethod.EasingMethodImpl.EXPO.apply(MathHelper.func_151237_a((double)((double)(Util.func_211177_b() - current.getValue()) / 750.0), (double)0.0, (double)1.0))) * (double)Minecraft.func_71410_x().func_228018_at_().func_198107_o() * 1.3, () -> 0.0, () -> Util.func_211177_b() - current.getValue() > 800L));
                }))).setSavingRunnable(() -> {
                    this.saveConfig();
                    EntryRegistry.getInstance().refilter();
                    if (REIHelperImpl.getSearchField() != null) {
                        ContainerScreenOverlay.getEntryListWidget().updateSearch(REIHelperImpl.getSearchField().getText(), true);
                    }
                }).build();
            });
            Screen configScreen = provider.get();
            parentTranslated.setLastScreen(configScreen);
            MutableLong current2 = new MutableLong(0L);
            return new TransformingScreen(false, configScreen, parent, () -> current2.setValue(current2.getValue() == 0L ? Util.func_211177_b() + (long)(!this.getConfig().isConfigScreenAnimated() ? -3000 : 0) : current2.getValue()), () -> 0.0, () -> (1.0 - EasingMethod.EasingMethodImpl.EXPO.apply(MathHelper.func_151237_a((double)((double)(Util.func_211177_b() - current2.getValue()) / 750.0), (double)0.0, (double)1.0))) * (double)Minecraft.func_71410_x().func_228018_at_().func_198087_p() * 1.3, () -> Util.func_211177_b() - current2.getValue() > 800L);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean detectWorkingOptifabric() {
        try {
            String renderText = FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.class_327", "method_1724", "(Ljava/lang/String;FFIZLnet/minecraft/class_1159;Lnet/minecraft/class_4597;ZII)F");
            Method method = FontRenderer.class.getDeclaredMethod(renderText, String.class, Float.TYPE, Float.TYPE, Integer.TYPE, Boolean.TYPE, Matrix4f.class, IRenderTypeBuffer.class, Boolean.TYPE, Integer.TYPE, Integer.TYPE);
            return !java.lang.reflect.Modifier.isPrivate(method.getModifiers());
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public static class ConfigErrorScreen
    extends Screen {
        private final ITextComponent message;
        private final Screen parent;

        public ConfigErrorScreen(Screen parent, ITextComponent title, ITextComponent message) {
            super(title);
            this.parent = parent;
            this.message = message;
        }

        public void func_231160_c_() {
            super.func_231160_c_();
            this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, 140, 200, 20, DialogTexts.field_240633_d_, button -> this.field_230706_i_.func_147108_a(this.parent)));
        }

        public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
            this.func_230446_a_(matrices);
            ConfigErrorScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)90, (int)0xFFFFFF);
            ConfigErrorScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)this.message, (int)(this.field_230708_k_ / 2), (int)110, (int)0xFFFFFF);
            super.func_230430_a_(matrices, mouseX, mouseY, delta);
        }

        public boolean func_231178_ax__() {
            return false;
        }
    }
}

