/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.config.entries;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.config.entries.FilteringRulesScreen;
import me.shedaniel.rei.impl.client.config.entries.FilteringScreen;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringRule;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class FilteringEntry
extends AbstractConfigListEntry<List<EntryStack<?>>> {
    private int width;
    Consumer<List<EntryStack<?>>> saveConsumer;
    Consumer<List<FilteringRule<?>>> rulesSaveConsumer;
    List<EntryStack<?>> defaultValue;
    Set<EntryStack<?>> configFiltered;
    List<FilteringRule<?>> rules;
    boolean edited = false;
    final FilteringScreen filteringScreen = new FilteringScreen(this);
    final FilteringRulesScreen filteringRulesScreen = new FilteringRulesScreen(this);
    private final Widget buttonWidget = new Button(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("config.roughlyenoughitems.filteringScreen"), button -> {
        this.filteringRulesScreen.parent = Minecraft.func_71410_x().field_71462_r;
        Minecraft.func_71410_x().func_147108_a((Screen)this.filteringRulesScreen);
    });
    private final List<IGuiEventListener> children = ImmutableList.of((Object)this.buttonWidget);

    public FilteringEntry(int width, List<EntryStack<?>> configFiltered, List<FilteringRule<?>> rules, List<EntryStack<?>> defaultValue, Consumer<List<EntryStack<?>>> saveConsumer, Consumer<List<FilteringRule<?>>> rulesSaveConsumer) {
        super(NarratorChatListener.field_216868_a, false);
        this.width = width;
        this.configFiltered = new TreeSet<EntryStack>(Comparator.comparing(EntryStacks::hashExact));
        this.configFiltered.addAll(configFiltered);
        this.rules = Lists.newArrayList(rules);
        this.defaultValue = defaultValue;
        this.saveConsumer = saveConsumer;
        this.rulesSaveConsumer = rulesSaveConsumer;
    }

    public List<EntryStack<?>> getValue() {
        return Lists.newArrayList(this.configFiltered);
    }

    public Optional<List<EntryStack<?>>> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue);
    }

    public void save() {
        this.saveConsumer.accept((List<EntryStack<?>>)this.getValue());
        this.rulesSaveConsumer.accept(this.rules);
        this.edited = false;
    }

    public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        this.buttonWidget.field_230693_o_ = this.isEditable();
        this.buttonWidget.field_230691_m_ = y;
        this.buttonWidget.field_230690_l_ = x + entryWidth / 2 - this.width / 2;
        this.buttonWidget.func_230991_b_(this.width);
        this.buttonWidget.func_230430_a_(matrices, mouseX, mouseY, delta);
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return this.children;
    }

    public boolean isEdited() {
        return super.isEdited() || this.edited;
    }
}

