/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.config.entries;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import me.shedaniel.clothconfig2.gui.widget.DynamicElementListWidget;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.rei.impl.client.config.entries.FilteringEntry;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringRule;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class FilteringRuleOptionsScreen<T extends FilteringRule<?>>
extends Screen {
    private final FilteringEntry entry;
    private RulesList rulesList;
    Screen parent;
    public T rule;

    public FilteringRuleOptionsScreen(FilteringEntry entry, T rule, Screen screen) {
        super((ITextComponent)new TranslationTextComponent("config.roughlyenoughitems.filteringRulesScreen"));
        this.entry = entry;
        this.rule = rule;
        this.parent = screen;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        if (this.rulesList != null) {
            this.save();
        }
        TranslationTextComponent doneText = new TranslationTextComponent("gui.done");
        int width = Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)doneText);
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ - 4 - width - 10, 4, width + 10, 20, (ITextComponent)doneText, button -> {
            this.save();
            this.field_230706_i_.func_147108_a(this.parent);
        }));
        this.rulesList = (RulesList)this.func_230481_d_((IGuiEventListener)new RulesList(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_, 30, this.field_230709_l_, field_230663_f_));
        this.addEntries(ruleEntry -> this.rulesList.addItem((RuleEntry)((Object)ruleEntry)));
    }

    public abstract void addEntries(Consumer<RuleEntry> var1);

    public abstract void save();

    public void addText(Consumer<RuleEntry> entryConsumer, ITextProperties text) {
        for (IReorderingProcessor s : this.field_230712_o_.func_238425_b_(text, this.field_230708_k_ - 80)) {
            entryConsumer.accept(new TextRuleEntry((FilteringRule<?>)this.rule, s));
        }
    }

    public void addEmpty(Consumer<RuleEntry> entryConsumer, int height) {
        entryConsumer.accept(new EmptyRuleEntry((FilteringRule<?>)this.rule, height));
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.rulesList.func_230430_a_(matrices, mouseX, mouseY, delta);
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
        this.field_230712_o_.func_238407_a_(matrices, this.field_230704_d_.func_241878_f(), (float)this.field_230708_k_ / 2.0f - (float)this.field_230712_o_.func_238414_a_((ITextProperties)this.field_230704_d_) / 2.0f, 12.0f, -1);
    }

    public static class BooleanRuleEntry
    extends RuleEntry {
        private boolean b;
        private final Button widget;

        public BooleanRuleEntry(int width, boolean b, FilteringRule<?> rule, Function<Boolean, ITextComponent> textFunction) {
            super(rule);
            this.b = b;
            this.widget = new Button(0, 0, 100, 20, textFunction.apply(b), button -> {
                this.b = !this.b;
                button.func_238482_a_((ITextComponent)textFunction.apply(this.b));
            });
        }

        public boolean getBoolean() {
            return this.b;
        }

        public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            this.widget.field_230690_l_ = x + 2;
            this.widget.field_230691_m_ = y;
            this.widget.func_230430_a_(matrices, mouseX, mouseY, delta);
        }

        public int getItemHeight() {
            return 20;
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return Collections.singletonList(this.widget);
        }
    }

    public static class TextFieldRuleEntry
    extends RuleEntry {
        private final TextFieldWidget widget;

        public TextFieldRuleEntry(int width, FilteringRule<?> rule, Consumer<TextFieldWidget> widgetConsumer) {
            super(rule);
            this.widget = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, 0, 0, width, 18, ITextComponent.func_244388_a((String)""));
            widgetConsumer.accept(this.widget);
        }

        public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            this.widget.field_230690_l_ = x + 2;
            this.widget.field_230691_m_ = y + 2;
            this.widget.func_230430_a_(matrices, mouseX, mouseY, delta);
        }

        public int getItemHeight() {
            return 20;
        }

        public TextFieldWidget getWidget() {
            return this.widget;
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return Collections.singletonList(this.widget);
        }
    }

    public static class EmptyRuleEntry
    extends RuleEntry {
        private final int height;

        public EmptyRuleEntry(FilteringRule<?> rule, int height) {
            super(rule);
            this.height = height;
        }

        public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        }

        public int getItemHeight() {
            return this.height;
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return Collections.emptyList();
        }
    }

    public static class TextRuleEntry
    extends RuleEntry {
        private final IReorderingProcessor text;

        public TextRuleEntry(FilteringRule<?> rule, IReorderingProcessor text) {
            super(rule);
            this.text = text;
        }

        public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, this.text, (float)(x + 5), (float)y, -1);
        }

        public int getItemHeight() {
            return 12;
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return Collections.emptyList();
        }
    }

    public static abstract class RuleEntry
    extends DynamicElementListWidget.ElementEntry<RuleEntry> {
        private final FilteringRule<?> rule;

        public RuleEntry(FilteringRule<?> rule) {
            this.rule = rule;
        }

        public FilteringRule<?> getRule() {
            return this.rule;
        }
    }

    public static class RulesList
    extends DynamicElementListWidget<RuleEntry> {
        public RulesList(Minecraft client, int width, int height, int top, int bottom, ResourceLocation backgroundLocation) {
            super(client, width, height, top, bottom, backgroundLocation);
        }

        protected int addItem(RuleEntry item) {
            return super.addItem((DynamicEntryListWidget.Entry)item);
        }

        public int getItemWidth() {
            return this.width - 40;
        }

        protected int getScrollbarPosition() {
            return this.width - 14;
        }
    }
}

