/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.config.entries;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.ScrollingContainer;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIHelper;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.search.SearchFilter;
import me.shedaniel.rei.api.client.search.SearchProvider;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.config.entries.FilteringEntry;
import me.shedaniel.rei.impl.client.gui.ContainerScreenOverlay;
import me.shedaniel.rei.impl.client.gui.widget.BatchedEntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.EntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.search.OverlaySearchField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FilteringScreen
extends Screen {
    protected List<EntryStack<?>> selected = Lists.newArrayList();
    protected final ScrollingContainer scrolling = new ScrollingContainer(){

        public int getMaxScrollHeight() {
            return MathHelper.func_76123_f((float)((float)FilteringScreen.this.entryStacks.size() / ((float)((FilteringScreen)FilteringScreen.this).innerBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize() + 28;
        }

        public Rectangle getBounds() {
            return FilteringScreen.this.getBounds();
        }

        public int getScrollBarX() {
            return FilteringScreen.this.field_230708_k_ - 7;
        }
    };
    Screen parent;
    private FilteringEntry filteringEntry;
    private Tooltip tooltip = null;
    private List<EntryStack<?>> entryStacks = null;
    private Rectangle innerBounds;
    private List<EntryListEntry> entries = Collections.emptyList();
    private List<IGuiEventListener> elements = Collections.emptyList();
    private Point selectionPoint = null;
    private Point secondPoint = null;
    private OverlaySearchField searchField;
    private Button selectAllButton;
    private Button selectNoneButton;
    private Button hideButton;
    private Button showButton;
    private Button backButton;
    private Rectangle selectionCache;
    private SearchFilter lastFilter = SearchFilter.matchAll();

    public FilteringScreen(FilteringEntry filteringEntry) {
        super((ITextComponent)new TranslationTextComponent("config.roughlyenoughitems.filteringScreen"));
        this.filteringEntry = filteringEntry;
        this.searchField = new OverlaySearchField(0, 0, 0, 0);
        TranslationTextComponent selectAllText = new TranslationTextComponent("config.roughlyenoughitems.filteredEntries.selectAll");
        this.selectAllButton = new Button(0, 0, Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)selectAllText) + 10, 20, (ITextComponent)selectAllText, button -> {
            this.selectionPoint = new Point(-1073741823, -1073741823);
            this.secondPoint = new Point(0x3FFFFFFF, 0x3FFFFFFF);
        });
        TranslationTextComponent selectNoneText = new TranslationTextComponent("config.roughlyenoughitems.filteredEntries.selectNone");
        this.selectNoneButton = new Button(0, 0, Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)selectNoneText) + 10, 20, (ITextComponent)selectNoneText, button -> {
            this.selectionPoint = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.secondPoint = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        });
        TranslationTextComponent hideText = new TranslationTextComponent("config.roughlyenoughitems.filteredEntries.hide");
        this.hideButton = new Button(0, 0, Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)hideText) + 10, 20, (ITextComponent)hideText, button -> {
            for (int i = 0; i < this.entryStacks.size(); ++i) {
                EntryStack<?> stack = this.entryStacks.get(i);
                EntryListEntry entry = this.entries.get(i);
                entry.getBounds().y = (int)((double)entry.backupY - this.scrolling.scrollAmount);
                if (!entry.isSelected() || entry.isFiltered()) continue;
                filteringEntry.configFiltered.add(stack);
                filteringEntry.edited = true;
                entry.dirty = true;
            }
        });
        TranslationTextComponent showText = new TranslationTextComponent("config.roughlyenoughitems.filteredEntries.show");
        this.showButton = new Button(0, 0, Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)showText) + 10, 20, (ITextComponent)showText, button -> {
            for (int i = 0; i < this.entryStacks.size(); ++i) {
                EntryStack<?> stack = this.entryStacks.get(i);
                EntryListEntry entry = this.entries.get(i);
                entry.getBounds().y = (int)((double)entry.backupY - this.scrolling.scrollAmount);
                if (!entry.isSelected() || !filteringEntry.configFiltered.remove(stack)) continue;
                filteringEntry.edited = true;
                entry.dirty = true;
            }
        });
        IFormattableTextComponent backText = new StringTextComponent("\u21a9 ").func_230529_a_((ITextComponent)new TranslationTextComponent("gui.back"));
        this.backButton = new Button(0, 0, Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)backText) + 10, 20, (ITextComponent)backText, button -> {
            this.field_230706_i_.func_147108_a(this.parent);
            this.parent = null;
        });
        this.searchField.isMain = false;
    }

    private static Rectangle updateInnerBounds(Rectangle bounds) {
        int width = Math.max(MathHelper.func_76141_d((float)((float)(bounds.width - 2 - 6) / (float)EntryListWidget.entrySize())), 1);
        return new Rectangle((int)((float)bounds.getCenterX() - (float)(width * EntryListWidget.entrySize()) / 2.0f), bounds.y + 5, width * EntryListWidget.entrySize(), bounds.height);
    }

    public Rectangle getBounds() {
        return new Rectangle(0, 30, this.field_230708_k_, this.field_230709_l_ - 30);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        Rectangle bounds = this.getBounds();
        this.updateSearch(this.searchField.getText());
        this.selectAllButton.field_230690_l_ = 2;
        this.selectAllButton.field_230691_m_ = bounds.getMaxY() - 22;
        this.selectNoneButton.field_230690_l_ = 4 + this.selectAllButton.func_230998_h_();
        this.selectNoneButton.field_230691_m_ = bounds.getMaxY() - 22;
        int searchFieldWidth = Math.max(bounds.width - (this.selectNoneButton.field_230690_l_ + this.selectNoneButton.func_230998_h_() + this.hideButton.func_230998_h_() + this.showButton.func_230998_h_() + 12), 100);
        this.searchField.getBounds().setBounds(this.selectNoneButton.field_230690_l_ + this.selectNoneButton.func_230998_h_() + 4, bounds.getMaxY() - 21, searchFieldWidth, 18);
        this.hideButton.field_230690_l_ = bounds.getMaxX() - this.hideButton.func_230998_h_() - this.showButton.func_230998_h_() - 4;
        this.hideButton.field_230691_m_ = bounds.getMaxY() - 22;
        this.showButton.field_230690_l_ = bounds.getMaxX() - this.showButton.func_230998_h_() - 2;
        this.showButton.field_230691_m_ = bounds.getMaxY() - 22;
        this.backButton.field_230690_l_ = 4;
        this.backButton.field_230691_m_ = 4;
        this.searchField.setResponder(this::updateSearch);
    }

    protected void renderHoleBackground(MatrixStack matrices, int y1, int y2, int tint, int alpha1, int alpha2) {
        Tessellator tesselator = Tessellator.func_178181_a();
        BufferBuilder buffer = tesselator.func_178180_c();
        this.field_230706_i_.func_110434_K().func_110577_a(field_230663_f_);
        Matrix4f matrix = matrices.func_227866_c_().func_227870_a_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float float_1 = 32.0f;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_227888_a_(matrix, 0.0f, (float)y2, 0.0f).func_225583_a_(0.0f, (float)y2 / 32.0f).func_225586_a_(tint, tint, tint, alpha2).func_181675_d();
        buffer.func_227888_a_(matrix, (float)this.field_230708_k_, (float)y2, 0.0f).func_225583_a_((float)this.field_230708_k_ / 32.0f, (float)y2 / 32.0f).func_225586_a_(tint, tint, tint, alpha2).func_181675_d();
        buffer.func_227888_a_(matrix, (float)this.field_230708_k_, (float)y1, 0.0f).func_225583_a_((float)this.field_230708_k_ / 32.0f, (float)y1 / 32.0f).func_225586_a_(tint, tint, tint, alpha1).func_181675_d();
        buffer.func_227888_a_(matrix, 0.0f, (float)y1, 0.0f).func_225583_a_(0.0f, (float)y1 / 32.0f).func_225586_a_(tint, tint, tint, alpha1).func_181675_d();
        tesselator.func_78381_a();
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        int nextIndex;
        this.renderHoleBackground(matrices, 0, this.field_230709_l_, 32, 255, 255);
        this.updateSelectionCache();
        Rectangle bounds = this.getBounds();
        this.tooltip = null;
        if (bounds.isEmpty()) {
            return;
        }
        ScissorsHandler.INSTANCE.scissor(bounds);
        for (EntryListEntry entry : this.entries) {
            entry.clearStacks();
        }
        int skip = Math.max(0, MathHelper.func_76128_c((double)(this.scrolling.scrollAmount / (double)EntryListWidget.entrySize())));
        BatchedEntryRendererManager manager = new BatchedEntryRendererManager();
        for (int i = nextIndex = skip * this.innerBounds.width / EntryListWidget.entrySize(); i < this.entryStacks.size(); ++i) {
            EntryStack<?> stack = this.entryStacks.get(i);
            EntryListEntry entry = this.entries.get(nextIndex);
            entry.getBounds().y = (int)((double)entry.backupY - this.scrolling.scrollAmount);
            if (entry.getBounds().y > bounds.getMaxY()) break;
            entry.entry((EntryStack)stack);
            manager.add(entry);
            ++nextIndex;
        }
        manager.render(matrices, mouseX, mouseY, delta);
        this.updatePosition(delta);
        this.scrolling.renderScrollBar(-16777216, 1.0f, REIHelper.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
        matrices.func_227860_a_();
        matrices.func_227861_a_(0.0, 0.0, 300.0);
        this.searchField.laterRender(matrices, mouseX, mouseY, delta);
        this.selectAllButton.func_230430_a_(matrices, mouseX, mouseY, delta);
        this.selectNoneButton.func_230430_a_(matrices, mouseX, mouseY, delta);
        this.hideButton.func_230430_a_(matrices, mouseX, mouseY, delta);
        this.showButton.func_230430_a_(matrices, mouseX, mouseY, delta);
        matrices.func_227865_b_();
        ScissorsHandler.INSTANCE.removeLastScissor();
        Tessellator tesselator = Tessellator.func_178181_a();
        BufferBuilder buffer = tesselator.func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
        RenderSystem.disableAlphaTest();
        RenderSystem.shadeModel((int)7425);
        RenderSystem.disableTexture();
        Matrix4f matrix = matrices.func_227866_c_().func_227870_a_();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_227888_a_(matrix, 0.0f, (float)(bounds.y + 4), 0.0f).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        buffer.func_227888_a_(matrix, (float)this.field_230708_k_, (float)(bounds.y + 4), 0.0f).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        buffer.func_227888_a_(matrix, (float)this.field_230708_k_, (float)bounds.y, 0.0f).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buffer.func_227888_a_(matrix, 0.0f, (float)bounds.y, 0.0f).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        tesselator.func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
        this.renderHoleBackground(matrices, 0, bounds.y, 64, 255, 255);
        this.backButton.func_230430_a_(matrices, mouseX, mouseY, delta);
        if (this.tooltip != null) {
            ((ContainerScreenOverlay)REIHelper.getInstance().getOverlay().get()).renderTooltip(matrices, this.tooltip);
        }
        this.field_230712_o_.func_238407_a_(matrices, this.field_230704_d_.func_241878_f(), (float)this.field_230708_k_ / 2.0f - (float)this.field_230712_o_.func_238414_a_((ITextProperties)this.field_230704_d_) / 2.0f, 12.0f, -1);
    }

    private Rectangle getSelection() {
        return this.selectionCache;
    }

    private void updateSelectionCache() {
        if (this.selectionPoint != null) {
            Point p = this.secondPoint;
            if (p == null) {
                p = PointHelper.ofMouse();
                p.translate(0, (int)this.scrolling.scrollAmount);
            }
            int left = Math.min(p.x, this.selectionPoint.x);
            int top = Math.min(p.y, this.selectionPoint.y);
            int right = Math.max(p.x, this.selectionPoint.x);
            int bottom = Math.max(p.y, this.selectionPoint.y);
            this.selectionCache = new Rectangle(left, (int)((double)top - this.scrolling.scrollAmount), right - left, bottom - top);
            return;
        }
        this.selectionCache = new Rectangle(0, 0, 0, 0);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, button, dx, dy, ConfigObject.getInstance().doesSnapToRows(), (double)EntryListWidget.entrySize())) {
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, button, dx, dy);
    }

    private void updatePosition(float delta) {
        if (ConfigObject.getInstance().doesSnapToRows() && this.scrolling.scrollTarget >= 0.0 && this.scrolling.scrollTarget <= (double)this.scrolling.getMaxScroll()) {
            double nearestRow = (double)Math.round(this.scrolling.scrollTarget / (double)EntryListWidget.entrySize()) * (double)EntryListWidget.entrySize();
            this.scrolling.scrollTarget = !DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals((double)this.scrolling.scrollTarget, (double)nearestRow, (double)0.001f) ? (this.scrolling.scrollTarget += (nearestRow - this.scrolling.scrollTarget) * Math.min((double)delta / 2.0, 1.0)) : nearestRow;
        }
        this.scrolling.updatePosition(delta);
    }

    public void updateSearch(String searchTerm) {
        this.lastFilter = SearchProvider.getInstance().createFilter(searchTerm);
        LinkedHashSet list = Sets.newLinkedHashSet();
        ((Stream)EntryRegistry.getInstance().getEntryStacks().parallel()).filter(this::matches).map(EntryStack::normalize).forEachOrdered(list::add);
        this.entryStacks = Lists.newArrayList((Iterable)list);
        this.updateEntriesPosition();
    }

    public boolean matches(EntryStack<?> stack) {
        return this.lastFilter.test(stack);
    }

    public void updateEntriesPosition() {
        int entrySize = EntryListWidget.entrySize();
        this.innerBounds = FilteringScreen.updateInnerBounds(this.getBounds());
        int width = this.innerBounds.width / entrySize;
        int pageHeight = this.innerBounds.height / entrySize;
        int slotsToPrepare = Math.max(this.entryStacks.size() * 3, width * pageHeight * 3);
        int currentX = 0;
        int currentY = 0;
        ArrayList entries = Lists.newArrayList();
        for (int i = 0; i < slotsToPrepare; ++i) {
            int xPos = currentX * entrySize + this.innerBounds.x;
            int yPos = currentY * entrySize + this.innerBounds.y;
            entries.add(new EntryListEntry(xPos, yPos, entrySize));
            if (++currentX < width) continue;
            currentX = 0;
            ++currentY;
        }
        this.entries = entries;
        this.elements = Lists.newArrayList((Iterable)entries);
        this.elements.add((IGuiEventListener)this.searchField);
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return this.elements;
    }

    public boolean func_231044_a_(double double_1, double double_2, int int_1) {
        if (this.scrolling.updateDraggingState(double_1, double_2, int_1)) {
            return true;
        }
        if (this.getBounds().contains(double_1, double_2)) {
            if (this.searchField.func_231044_a_(double_1, double_2, int_1)) {
                this.selectionPoint = null;
                this.secondPoint = null;
                return true;
            }
            if (this.selectAllButton.func_231044_a_(double_1, double_2, int_1)) {
                return true;
            }
            if (this.selectNoneButton.func_231044_a_(double_1, double_2, int_1)) {
                return true;
            }
            if (this.hideButton.func_231044_a_(double_1, double_2, int_1)) {
                return true;
            }
            if (this.showButton.func_231044_a_(double_1, double_2, int_1)) {
                return true;
            }
            if (int_1 == 0) {
                this.selectionPoint = new Point(double_1, double_2 + this.scrolling.scrollAmount);
                this.secondPoint = null;
                return true;
            }
        }
        return this.backButton.func_231044_a_(double_1, double_2, int_1);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.selectionPoint != null && button == 0 && this.secondPoint == null) {
            this.secondPoint = new Point(mouseX, mouseY + this.scrolling.scrollAmount);
            if (this.secondPoint.equals((Object)this.selectionPoint)) {
                this.secondPoint.translate(1, 1);
            }
            return true;
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231042_a_(char chr, int keyCode) {
        for (IGuiEventListener iGuiEventListener : this.func_231039_at__()) {
            if (!iGuiEventListener.func_231042_a_(chr, keyCode)) continue;
            return true;
        }
        return super.func_231042_a_(chr, keyCode);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        for (IGuiEventListener iGuiEventListener : this.func_231039_at__()) {
            if (!iGuiEventListener.func_231046_a_(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        if (Screen.func_231170_j_((int)keyCode)) {
            this.selectionPoint = new Point(0, 0);
            this.secondPoint = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
            return true;
        }
        if (keyCode == 256 && this.func_231178_ax__()) {
            this.backButton.func_230930_b_();
            return true;
        }
        if (keyCode == 258) {
            boolean bl;
            boolean bl2 = bl = !FilteringScreen.func_231173_s_();
            if (!this.func_231049_c__(bl)) {
                this.func_231049_c__(bl);
            }
            return true;
        }
        return false;
    }

    public void updateArea(@Nullable String searchTerm) {
        if (searchTerm != null) {
            this.updateSearch(searchTerm);
        } else if (this.entryStacks == null) {
            this.updateSearch("");
        } else {
            this.updateEntriesPosition();
        }
    }

    public boolean func_231043_a_(double double_1, double double_2, double double_3) {
        if (this.getBounds().contains(double_1, double_2)) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
            return true;
        }
        super.func_231043_a_(double_1, double_2, double_3);
        return true;
    }

    private class EntryListEntry
    extends EntryWidget {
        private int backupY;
        private boolean filtered;
        private boolean dirty;

        private EntryListEntry(int x, int y, int entrySize) {
            super(new Point(x, y));
            this.filtered = false;
            this.dirty = true;
            this.backupY = y;
            this.getBounds().width = this.getBounds().height = entrySize;
            this.interactableFavorites(false);
            this.interactable(false);
            this.noHighlight();
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return super.containsMouse(mouseX, mouseY) && FilteringScreen.this.getBounds().contains(mouseX, mouseY);
        }

        @Override
        protected void drawHighlighted(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        }

        @Override
        public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
            super.func_230430_a_(matrices, mouseX, mouseY, delta);
            if (this.isSelected()) {
                Rectangle bounds = this.getBounds();
                RenderSystem.disableDepthTest();
                this.func_238468_a_(matrices, bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), -1989447430, -1989447430);
                RenderSystem.enableDepthTest();
            }
        }

        public boolean isSelected() {
            return FilteringScreen.this.getSelection().intersects(this.getBounds());
        }

        public boolean isFiltered() {
            if (this.dirty) {
                this.filtered = ((FilteringScreen)FilteringScreen.this).filteringEntry.configFiltered.contains(this.getCurrentEntry());
                this.dirty = false;
            }
            return this.filtered;
        }

        @Override
        protected void drawBackground(MatrixStack matrices, int mouseX, int mouseY, float delta) {
            if (this.isFiltered()) {
                Rectangle bounds = this.getBounds();
                RenderSystem.disableDepthTest();
                this.func_238468_a_(matrices, bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), -65536, -65536);
                RenderSystem.enableDepthTest();
            }
        }

        @Override
        protected void queueTooltip(MatrixStack matrices, int mouseX, int mouseY, float delta) {
            if (FilteringScreen.this.searchField.containsMouse(mouseX, mouseY)) {
                return;
            }
            Tooltip tooltip = this.getCurrentTooltip(new Point(mouseX, mouseY));
            if (tooltip != null) {
                FilteringScreen.this.tooltip = tooltip;
            }
        }
    }
}

