/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.entry.filtering.rules;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.entry.filtering.AbstractFilteringRule;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringContext;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringResult;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ManualFilteringRule
extends AbstractFilteringRule<ManualFilteringRule> {
    @Override
    public CompoundNBT save(CompoundNBT tag) {
        return tag;
    }

    @Override
    public ManualFilteringRule createFromTag(CompoundNBT tag) {
        return new ManualFilteringRule();
    }

    @Override
    public FilteringResult processFilteredStacks(FilteringContext context) {
        FilteringResult result = FilteringResult.create();
        this.processList(context.getShownStacks(), result);
        this.processList(context.getUnsetStacks(), result);
        return result;
    }

    private void processList(Collection<EntryStack<?>> stacks, FilteringResult result) {
        LongSet filteredStacks = (LongSet)CollectionUtils.mapParallel(ConfigObject.getInstance().getFilteredStacks(), EntryStacks::hashExact, LongOpenHashSet::new);
        result.hide(stacks.parallelStream().filter(stack -> filteredStacks.contains(EntryStacks.hashExact(stack))).collect(Collectors.toList()));
    }

    @Override
    public ITextComponent getTitle() {
        return new TranslationTextComponent("rule.roughlyenoughitems.filtering.manual");
    }

    @Override
    public ITextComponent getSubtitle() {
        return new TranslationTextComponent("rule.roughlyenoughitems.filtering.manual.subtitle");
    }

    @Override
    public ManualFilteringRule createNew() {
        throw new UnsupportedOperationException();
    }
}

