/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.entry.filtering.rules;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import me.shedaniel.rei.api.client.search.SearchFilter;
import me.shedaniel.rei.api.client.search.SearchProvider;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.config.entries.FilteringEntry;
import me.shedaniel.rei.impl.client.config.entries.FilteringRuleOptionsScreen;
import me.shedaniel.rei.impl.client.entry.filtering.AbstractFilteringRule;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringContext;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringResult;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SearchFilteringRule
extends AbstractFilteringRule<SearchFilteringRule> {
    private SearchFilter filter;
    private boolean show;

    public SearchFilteringRule() {
    }

    public SearchFilteringRule(SearchFilter filter, boolean show) {
        this.filter = filter;
        this.show = show;
    }

    @Override
    public CompoundNBT save(CompoundNBT tag) {
        tag.func_74778_a("filter", this.filter.getFilter());
        tag.func_74757_a("show", this.show);
        return tag;
    }

    @Override
    public SearchFilteringRule createFromTag(CompoundNBT tag) {
        String filter = tag.func_74779_i("filter");
        boolean show = tag.func_74767_n("show");
        return new SearchFilteringRule(SearchProvider.getInstance().createFilter(filter), show);
    }

    @Override
    public FilteringResult processFilteredStacks(FilteringContext context) {
        ArrayList completableFutures = Lists.newArrayList();
        this.processList(context.getUnsetStacks(), completableFutures);
        if (this.show) {
            this.processList(context.getHiddenStacks(), completableFutures);
        } else {
            this.processList(context.getShownStacks(), completableFutures);
        }
        try {
            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
        }
        FilteringResult result = FilteringResult.create();
        for (CompletableFuture future : completableFutures) {
            List now = future.getNow(null);
            if (now == null) continue;
            if (this.show) {
                result.show(now);
                continue;
            }
            result.hide(now);
        }
        return result;
    }

    @Override
    public SearchFilteringRule createNew() {
        return new SearchFilteringRule(SearchFilter.matchAll(), true);
    }

    private void processList(Collection<EntryStack<?>> stacks, List<CompletableFuture<List<EntryStack<?>>>> completableFutures) {
        for (Iterable iterable : CollectionUtils.partition((List)stacks, 100)) {
            completableFutures.add(CompletableFuture.supplyAsync(() -> {
                ArrayList output = Lists.newArrayList();
                for (EntryStack stack : partitionStacks) {
                    if (!this.filter.test(stack)) continue;
                    output.add(stack);
                }
                return output;
            }));
        }
    }

    @Override
    public ITextComponent getTitle() {
        return new TranslationTextComponent("rule.roughlyenoughitems.filtering.search");
    }

    @Override
    public ITextComponent getSubtitle() {
        return new TranslationTextComponent("rule.roughlyenoughitems.filtering.search.subtitle");
    }

    @Override
    public Optional<BiFunction<FilteringEntry, Screen, Screen>> createEntryScreen() {
        return Optional.of((entry, screen) -> new FilteringRuleOptionsScreen<SearchFilteringRule>(entry, this, screen){
            FilteringRuleOptionsScreen.TextFieldRuleEntry entry;
            FilteringRuleOptionsScreen.BooleanRuleEntry show;
            {
                this.entry = null;
                this.show = null;
            }

            @Override
            public void addEntries(Consumer<FilteringRuleOptionsScreen.RuleEntry> entryConsumer) {
                this.addEmpty(entryConsumer, 10);
                this.addText(entryConsumer, (ITextProperties)new TranslationTextComponent("rule.roughlyenoughitems.filtering.search.filter").func_240699_a_(TextFormatting.GRAY));
                this.entry = new FilteringRuleOptionsScreen.TextFieldRuleEntry(this.field_230708_k_ - 36, this.rule, widget -> {
                    widget.func_146203_f(9999);
                    if (this.entry != null) {
                        widget.func_146180_a(this.entry.getWidget().func_146179_b());
                    } else {
                        widget.func_146180_a(((SearchFilteringRule)this.rule).filter.getFilter());
                    }
                });
                entryConsumer.accept(this.entry);
                this.addEmpty(entryConsumer, 10);
                this.addText(entryConsumer, (ITextProperties)new TranslationTextComponent("rule.roughlyenoughitems.filtering.search.show").func_240699_a_(TextFormatting.GRAY));
                this.show = new FilteringRuleOptionsScreen.BooleanRuleEntry(this.field_230708_k_ - 36, this.show == null ? ((SearchFilteringRule)this.rule).show : this.show.getBoolean(), this.rule, bool -> new TranslationTextComponent("rule.roughlyenoughitems.filtering.search.show." + bool));
                entryConsumer.accept(this.show);
            }

            @Override
            public void save() {
                ((SearchFilteringRule)this.rule).filter = SearchProvider.getInstance().createFilter(this.entry.getWidget().func_146179_b());
                ((SearchFilteringRule)this.rule).show = this.show.getBoolean();
            }
        });
    }
}

