/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.favorites;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FavoriteEntryTypeRegistryImpl
implements FavoriteEntryType.Registry {
    private final BiMap<ResourceLocation, FavoriteEntryType<?>> registry = HashBiMap.create();
    private final Map<ITextComponent, FavoriteEntryType.Section> sections = Maps.newLinkedHashMap();

    @Override
    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerFavorites(this);
    }

    @Override
    public void register(ResourceLocation id, FavoriteEntryType<?> type) {
        this.registry.put((Object)id, type);
    }

    @Override
    @Nullable
    public <A extends FavoriteEntry> FavoriteEntryType<A> get(ResourceLocation id) {
        return (FavoriteEntryType)this.registry.get((Object)id);
    }

    @Override
    @Nullable
    public ResourceLocation getId(FavoriteEntryType<?> type) {
        return (ResourceLocation)this.registry.inverse().get(type);
    }

    @Override
    public FavoriteEntryType.Section getOrCrateSection(ITextComponent text) {
        return this.sections.computeIfAbsent(text, SectionImpl::new);
    }

    @Override
    public Iterable<FavoriteEntryType.Section> sections() {
        return this.sections.values();
    }

    @Override
    public void startReload() {
        this.registry.clear();
        this.sections.clear();
    }

    private static class SectionImpl
    implements FavoriteEntryType.Section {
        private final ITextComponent text;
        private final List<FavoriteEntry> entries = new ArrayList<FavoriteEntry>();

        public SectionImpl(ITextComponent text) {
            this.text = text;
        }

        @Override
        public void add(FavoriteEntry ... entries) {
            Collections.addAll(this.entries, entries);
        }

        @Override
        public ITextComponent getText() {
            return this.text;
        }

        @Override
        public List<FavoriteEntry> getEntries() {
            return this.entries;
        }
    }
}

