/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.impl.client.gui.toast.ExportRecipeIdentifierToast;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.Util;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@ApiStatus.Experimental
public final class RecipeDisplayExporter
extends Widget {
    private static final RecipeDisplayExporter INSTANCE = new RecipeDisplayExporter();

    private RecipeDisplayExporter() {
    }

    public static void exportRecipeDisplay(Rectangle rectangle, List<Widget> widgets) {
        INSTANCE.exportRecipe(rectangle, widgets);
        ExportRecipeIdentifierToast.addToast(I18n.func_135052_a((String)"msg.rei.exported_recipe", (Object[])new Object[0]), I18n.func_135052_a((String)"msg.rei.exported_recipe.desc", (Object[])new Object[0]));
    }

    private static File getExportFilename(File directory) {
        String string = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
        int i = 1;
        File file;
        while ((file = new File(directory, string + (i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file;
    }

    private void exportRecipe(Rectangle rectangle, List<Widget> widgets) {
        RenderSystem.pushMatrix();
        Minecraft client = Minecraft.func_71410_x();
        MainWindow window = client.func_228018_at_();
        Framebuffer framebuffer = new Framebuffer(window.func_198109_k(), window.func_198091_l(), true, false);
        framebuffer.func_147610_a(true);
        RenderSystem.viewport((int)0, (int)0, (int)window.func_198109_k(), (int)window.func_198091_l());
        RenderSystem.clear((int)256, (boolean)Minecraft.field_142025_a);
        RenderSystem.matrixMode((int)5889);
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)((double)window.func_198109_k() / window.func_198100_s()), (double)((double)window.func_198091_l() / window.func_198100_s()), (double)0.0, (double)1000.0, (double)3000.0);
        RenderSystem.matrixMode((int)5888);
        RenderSystem.loadIdentity();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        RenderHelper.func_227784_d_();
        MatrixStack matrices = new MatrixStack();
        for (Widget widget : widgets) {
            widget.func_230430_a_(matrices, -1, -1, 0.0f);
        }
        RenderSystem.popMatrix();
        NativeImage nativeImage = new NativeImage(framebuffer.field_147622_a, framebuffer.field_147620_b, false);
        RenderSystem.bindTexture((int)framebuffer.func_242996_f());
        nativeImage.func_195717_a(0, false);
        nativeImage.func_195710_e();
        int outWidth = (int)((double)rectangle.width * window.func_198100_s());
        int outHeight = (int)((double)rectangle.height * window.func_198100_s());
        NativeImage strippedImage = new NativeImage(outWidth, outHeight, false);
        for (int y = 0; y < outHeight; ++y) {
            for (int x = 0; x < outWidth; ++x) {
                strippedImage.func_195700_a(x, y, nativeImage.func_195709_a(x + (int)((double)rectangle.x * window.func_198100_s()), y + (int)((double)rectangle.y * window.func_198100_s())));
            }
        }
        Util.func_240992_g_().execute(() -> {
            try {
                File export = new File(this.minecraft.field_71412_D, "rei_exports");
                export.mkdirs();
                strippedImage.func_209271_a(RecipeDisplayExporter.getExportFilename(export));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                nativeImage.close();
                strippedImage.close();
                RenderSystem.recordRenderCall(() -> ((Framebuffer)framebuffer).func_147608_a());
            }
        });
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseY, int i, float f) {
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return null;
    }
}

