/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.dragging;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProvider;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.common.util.Animator;
import me.shedaniel.rei.impl.client.gui.widget.LateRenderable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import org.jetbrains.annotations.Nullable;

public class CurrentDraggingStack
extends Widget
implements LateRenderable,
DraggingContext<Screen> {
    private DraggableStackProvider<Screen> provider;
    private DraggableStackVisitor<Screen> visitor;
    @Nullable
    private DraggableEntry entry;
    private final List<RenderBackEntry> backToOriginals = new ArrayList<RenderBackEntry>();

    public void set(DraggableStackProvider<Screen> provider, DraggableStackVisitor<Screen> visitor) {
        this.provider = provider;
        this.visitor = visitor;
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        if (this.entry != null) {
            if (!this.entry.dragging) {
                double requiredDistance;
                double yDistance;
                Point startPoint = this.entry.start;
                double xDistance = Math.abs(startPoint.x - mouseX);
                if (xDistance * xDistance + (yDistance = (double)Math.abs(startPoint.y - mouseY)) * yDistance > (requiredDistance = 8.0) * requiredDistance) {
                    this.entry.dragging = true;
                    this.entry.stack.drag();
                }
            }
            if (!RoughlyEnoughItemsCore.isLeftMousePressed) {
                this.drop();
            } else if (this.entry.dragging) {
                matrices.func_227860_a_();
                matrices.func_227861_a_(0.0, 0.0, 600.0);
                this.entry.stack.render(matrices, new Rectangle(mouseX - 8, mouseY - 8, 16, 16), mouseX, mouseY, delta);
                matrices.func_227865_b_();
            }
        }
        Iterator<RenderBackEntry> iterator = this.backToOriginals.iterator();
        while (iterator.hasNext()) {
            RenderBackEntry renderBackEntry = iterator.next();
            renderBackEntry.update(delta);
            if (Math.abs(renderBackEntry.x.doubleValue() - renderBackEntry.x.target()) <= 2.0 && Math.abs(renderBackEntry.y.doubleValue() - renderBackEntry.y.target()) <= 2.0) {
                iterator.remove();
                continue;
            }
            matrices.func_227860_a_();
            matrices.func_227861_a_(0.0, 0.0, 600.0);
            renderBackEntry.stack.render(matrices, new Rectangle(renderBackEntry.x.intValue(), renderBackEntry.y.intValue(), 16, 16), mouseX, mouseY, delta);
            matrices.func_227865_b_();
        }
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return Collections.emptyList();
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.drop();
        DraggableStack hoveredStack = this.provider.getHoveredStack(this, mouseX, mouseY);
        if (hoveredStack != null) {
            this.entry = new DraggableEntry(hoveredStack, new Point(mouseX, mouseY));
        }
        return false;
    }

    public boolean func_231048_c_(double d, double e, int i) {
        return false;
    }

    public boolean func_231045_a_(double mouseX1, double mouseY1, int button, double mouseX2, double mouseY2) {
        return this.entry != null && this.entry.dragging;
    }

    private boolean drop() {
        if (this.entry != null && this.entry.dragging) {
            Optional<DraggableStackVisitor.Acceptor> acceptor = this.visitor.visitDraggedStack(this, this.entry.stack);
            this.entry.stack.release(acceptor.isPresent());
            acceptor.ifPresent(a -> a.accept(this.entry.stack));
            this.entry = null;
            return true;
        }
        this.entry = null;
        return false;
    }

    @Override
    public Screen getScreen() {
        return Minecraft.func_71410_x().field_71462_r;
    }

    @Override
    @Nullable
    public DraggableStack getCurrentStack() {
        return this.entry != null && this.entry.dragging ? this.entry.stack : null;
    }

    @Override
    @Nullable
    public Point getCurrentPosition() {
        return this.isDraggingStack() ? PointHelper.ofMouse() : null;
    }

    @Override
    public void renderBackToPosition(DraggableStack stack, Point initialPosition, Supplier<Point> position) {
        this.backToOriginals.add(new RenderBackEntry(stack, initialPosition, position));
    }

    private static class RenderBackEntry {
        private final DraggableStack stack;
        private final Supplier<Point> position;
        private Animator x = new Animator();
        private Animator y = new Animator();
        private int lastDestination = -1;

        public RenderBackEntry(DraggableStack stack, Point initialPosition, Supplier<Point> position) {
            this.stack = stack;
            this.x.setAs(initialPosition.x - 8);
            this.y.setAs(initialPosition.y - 8);
            this.position = position;
        }

        public Point getPosition() {
            return this.position.get();
        }

        public void update(double delta) {
            this.x.update(delta);
            this.y.update(delta);
            Point position = this.getPosition();
            if (this.lastDestination != position.hashCode()) {
                this.lastDestination = position.hashCode();
                this.x.setTo(position.x, 200L);
                this.y.setTo(position.y, 200L);
            }
        }
    }

    private static class DraggableEntry {
        private final DraggableStack stack;
        private final Point start;
        private boolean dragging = false;

        private DraggableEntry(DraggableStack stack, Point start) {
            this.stack = stack;
            this.start = start;
        }
    }
}

