/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.REIHelper;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.ButtonArea;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.REIHelperImpl;
import me.shedaniel.rei.impl.client.gui.RecipeDisplayExporter;
import me.shedaniel.rei.impl.client.gui.screen.AbstractDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.widget.DefaultDisplayChoosePageWidget;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.InternalWidgets;
import me.shedaniel.rei.impl.client.gui.widget.TabWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.PanelWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DefaultDisplayViewingScreen
extends AbstractDisplayViewingScreen {
    public static final ResourceLocation CHEST_GUI_TEXTURE = new ResourceLocation("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private final List<Widget> preWidgets = Lists.newArrayList();
    private final List<Widget> widgets = Lists.newArrayList();
    private final Map<Rectangle, List<Widget>> recipeBounds = Maps.newHashMap();
    private final List<TabWidget> tabs = Lists.newArrayList();
    public int page;
    public int categoryPages = -1;
    public boolean choosePageActivated = false;
    public DefaultDisplayChoosePageWidget choosePageWidget;
    @Nullable
    private Panel workingStationsBaseWidget;
    private Button recipeBack;
    private Button recipeNext;
    private Button categoryBack;
    private Button categoryNext;
    private EntryStack<?> ingredientStackToNotice = EntryStack.empty();
    private EntryStack<?> resultStackToNotice = EntryStack.empty();

    public DefaultDisplayViewingScreen(Map<DisplayCategory<?>, List<Display>> categoriesMap, @Nullable CategoryIdentifier<?> category) {
        super(categoriesMap, category, 5);
        this.bounds = new Rectangle(0, 0, 176, 150);
    }

    @Override
    public void recalculateCategoryPage() {
        this.categoryPages = -1;
    }

    @Nullable
    public Panel getWorkingStationsBaseWidget() {
        return this.workingStationsBaseWidget;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.choosePageActivated) {
            this.choosePageActivated = false;
            this.func_231160_c_();
            return true;
        }
        if (keyCode == 258 && !this.field_230706_i_.field_71474_y.field_151445_Q.func_197976_a(keyCode, scanCode)) {
            boolean boolean_1;
            boolean bl = boolean_1 = !DefaultDisplayViewingScreen.func_231173_s_();
            if (!this.func_231049_c__(boolean_1)) {
                this.func_231049_c__(boolean_1);
            }
            return true;
        }
        if (this.choosePageActivated) {
            return this.choosePageWidget.func_231046_a_(keyCode, scanCode, modifiers);
        }
        if (ConfigObject.getInstance().getNextPageKeybind().matchesKey(keyCode, scanCode)) {
            if (this.recipeNext.isEnabled()) {
                this.recipeNext.onClick();
            }
            return this.recipeNext.isEnabled();
        }
        if (ConfigObject.getInstance().getPreviousPageKeybind().matchesKey(keyCode, scanCode)) {
            if (this.recipeBack.isEnabled()) {
                this.recipeBack.onClick();
            }
            return this.recipeBack.isEnabled();
        }
        for (IGuiEventListener element : this.func_231039_at__()) {
            if (!element.func_231046_a_(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        if (keyCode == 256 || this.field_230706_i_.field_71474_y.field_151445_Q.func_197976_a(keyCode, scanCode)) {
            Minecraft.func_71410_x().func_147108_a(REIHelper.getInstance().getPreviousScreen());
            return true;
        }
        if (keyCode == 259) {
            if (REIHelperImpl.getInstance().hasLastDisplayScreen()) {
                this.field_230706_i_.func_147108_a(REIHelperImpl.getInstance().getLastDisplayScreen());
            } else {
                this.field_230706_i_.func_147108_a(REIHelper.getInstance().getPreviousScreen());
            }
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        boolean isCompactTabs = ConfigObject.getInstance().isUsingCompactTabs();
        int tabSize = isCompactTabs ? 24 : 28;
        this.field_230705_e_.clear();
        this.recipeBounds.clear();
        this.tabs.clear();
        this.preWidgets.clear();
        this.widgets.clear();
        int largestWidth = this.field_230708_k_ - 100;
        int largestHeight = Math.max(this.field_230709_l_ - 34 - 30, 100);
        int maxWidthDisplay = CollectionUtils.mapAndMax(this.getCurrentDisplayed(), this.getCurrentCategory()::getDisplayWidth, Comparator.naturalOrder()).orElse(150);
        int guiWidth = Math.max(maxWidthDisplay + 40, 190);
        this.tabsPerPage = Math.max(5, MathHelper.func_76128_c((double)(((double)guiWidth - 20.0) / (double)tabSize)));
        if (this.categoryPages == -1) {
            this.categoryPages = Math.max(0, this.selectedCategoryIndex / this.tabsPerPage);
        }
        this.bounds = new Rectangle(this.field_230708_k_ / 2 - guiWidth / 2, this.field_230709_l_ / 2 - largestHeight / 2, guiWidth, largestHeight);
        if (ConfigObject.getInstance().isSubsetsEnabled()) {
            this.bounds.setLocation(this.bounds.getX(), this.bounds.getY() + 15);
            this.bounds.setSize(this.bounds.getWidth(), this.bounds.getHeight() - 10);
        }
        this.page = MathHelper.func_76125_a((int)this.page, (int)0, (int)(this.getCurrentTotalPages() - 1));
        this.widgets.add(Widgets.createButton(new Rectangle(this.bounds.x, this.bounds.y - 16, 10, 10), (ITextComponent)new TranslationTextComponent("text.rei.left_arrow")).onClick(button -> {
            --this.categoryPages;
            if (this.categoryPages < 0) {
                this.categoryPages = MathHelper.func_76123_f((float)((float)this.categories.size() / (float)this.tabsPerPage)) - 1;
            }
            this.func_231160_c_();
        }).enabled(this.categories.size() > this.tabsPerPage));
        this.widgets.add(Widgets.createButton(new Rectangle(this.bounds.x + this.bounds.width - 10, this.bounds.y - 16, 10, 10), (ITextComponent)new TranslationTextComponent("text.rei.right_arrow")).onClick(button -> {
            ++this.categoryPages;
            if (this.categoryPages > MathHelper.func_76123_f((float)((float)this.categories.size() / (float)this.tabsPerPage)) - 1) {
                this.categoryPages = 0;
            }
            this.func_231160_c_();
        }).enabled(this.categories.size() > this.tabsPerPage));
        this.categoryBack = Widgets.createButton(new Rectangle(this.bounds.getX() + 5, this.bounds.getY() + 5, 12, 12), (ITextComponent)new TranslationTextComponent("text.rei.left_arrow")).onClick(button -> this.previousCategory()).tooltipLine((ITextComponent)new TranslationTextComponent("text.rei.previous_category"));
        this.widgets.add(this.categoryBack);
        this.widgets.add(Widgets.createClickableLabel(new Point(this.bounds.getCenterX(), this.bounds.getY() + 7), this.getCurrentCategory().getTitle(), clickableLabelWidget -> ClientHelper.getInstance().openView(ViewSearchBuilder.builder().addAllCategories().fillPreferredOpenedCategory())).tooltipLine(I18n.func_135052_a((String)"text.rei.view_all_categories", (Object[])new Object[0])));
        this.categoryNext = Widgets.createButton(new Rectangle(this.bounds.getMaxX() - 17, this.bounds.getY() + 5, 12, 12), (ITextComponent)new TranslationTextComponent("text.rei.right_arrow")).onClick(button -> this.nextCategory()).tooltipLine((ITextComponent)new TranslationTextComponent("text.rei.next_category"));
        this.widgets.add(this.categoryNext);
        this.categoryBack.setEnabled(this.categories.size() > 1);
        this.categoryNext.setEnabled(this.categories.size() > 1);
        this.recipeBack = Widgets.createButton(new Rectangle(this.bounds.getX() + 5, this.bounds.getY() + 19, 12, 12), (ITextComponent)new TranslationTextComponent("text.rei.left_arrow")).onClick(button -> {
            --this.page;
            if (this.page < 0) {
                this.page = this.getCurrentTotalPages() - 1;
            }
            this.func_231160_c_();
        }).tooltipLine((ITextComponent)new TranslationTextComponent("text.rei.previous_page"));
        this.widgets.add(this.recipeBack);
        this.widgets.add(Widgets.createClickableLabel(new Point(this.bounds.getCenterX(), this.bounds.getY() + 21), NarratorChatListener.field_216868_a, label -> {
            this.choosePageActivated = true;
            this.func_231160_c_();
        }).onRender((matrices, label) -> {
            label.setMessage((ITextProperties)new ImmutableTextComponent(String.format("%d/%d", this.page + 1, this.getCurrentTotalPages())));
            label.setClickable(this.getCurrentTotalPages() > 1);
        }).tooltipSupplier(label -> label.isClickable() ? I18n.func_135052_a((String)"text.rei.choose_page", (Object[])new Object[0]) : null));
        this.recipeNext = Widgets.createButton(new Rectangle(this.bounds.getMaxX() - 17, this.bounds.getY() + 19, 12, 12), (ITextComponent)new TranslationTextComponent("text.rei.right_arrow")).onClick(button -> {
            ++this.page;
            if (this.page >= this.getCurrentTotalPages()) {
                this.page = 0;
            }
            this.func_231160_c_();
        }).tooltipLine((ITextComponent)new TranslationTextComponent("text.rei.next_page"));
        this.widgets.add(this.recipeNext);
        this.recipeBack.setEnabled(this.getCurrentTotalPages() > 1);
        this.recipeNext.setEnabled(this.getCurrentTotalPages() > 1);
        int tabV = isCompactTabs ? 166 : 192;
        for (int i = 0; i < this.tabsPerPage; ++i) {
            int j = i + this.categoryPages * this.tabsPerPage;
            if (this.categories.size() <= j) continue;
            TabWidget tab = TabWidget.create(i, tabSize, this.bounds.x + this.bounds.width / 2 - Math.min(this.categories.size() - this.categoryPages * this.tabsPerPage, this.tabsPerPage) * tabSize / 2, this.bounds.y, 0, tabV, widget -> {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                if (widget.getId() + this.categoryPages * this.tabsPerPage == this.selectedCategoryIndex) {
                    return false;
                }
                ClientHelperImpl.getInstance().openRecipeViewingScreen(this.categoryMap, ((DisplayCategory)this.categories.get(widget.getId() + this.categoryPages * this.tabsPerPage)).getCategoryIdentifier(), this.ingredientStackToNotice, this.resultStackToNotice);
                return true;
            });
            this.tabs.add(tab);
            tab.setRenderer((DisplayCategory)this.categories.get(j), ((DisplayCategory)this.categories.get(j)).getIcon(), ((DisplayCategory)this.categories.get(j)).getTitle(), tab.getId() + this.categoryPages * this.tabsPerPage == this.selectedCategoryIndex);
        }
        Optional<ButtonArea> supplier = CategoryRegistry.getInstance().get(this.getCurrentCategoryId()).getPlusButtonArea();
        int recipeHeight = this.getCurrentCategory().getDisplayHeight();
        List<Display> currentDisplayed = this.getCurrentDisplayed();
        for (int i = 0; i < currentDisplayed.size(); ++i) {
            Display display = currentDisplayed.get(i);
            Supplier<Display> displaySupplier = () -> display;
            int displayWidth = this.getCurrentCategory().getDisplayWidth(displaySupplier.get());
            Rectangle displayBounds = new Rectangle(this.getBounds().getCenterX() - displayWidth / 2, this.getBounds().getCenterY() + 16 - recipeHeight * (this.getRecipesPerPage() + 1) / 2 - 2 * (this.getRecipesPerPage() + 1) + recipeHeight * i + 4 * i, displayWidth, recipeHeight);
            List<Widget> setupDisplay = this.getCurrentCategory().setupDisplay(display, displayBounds);
            this.transformIngredientNotice(setupDisplay, this.ingredientStackToNotice);
            this.transformResultNotice(setupDisplay, this.resultStackToNotice);
            this.recipeBounds.put(displayBounds, setupDisplay);
            this.widgets.addAll(setupDisplay);
            if (!supplier.isPresent() || supplier.get().get(displayBounds) == null) continue;
            this.widgets.add(InternalWidgets.createAutoCraftingButtonWidget(displayBounds, supplier.get().get(displayBounds), (ITextComponent)new StringTextComponent(supplier.get().getButtonText()), displaySupplier, setupDisplay, this.getCurrentCategory()));
        }
        this.choosePageWidget = this.choosePageActivated ? new DefaultDisplayChoosePageWidget(this, this.page, this.getCurrentTotalPages()) : null;
        this.workingStationsBaseWidget = null;
        List<EntryIngredient> workstations = CategoryRegistry.getInstance().get(this.getCurrentCategoryId()).getWorkstations();
        if (!workstations.isEmpty()) {
            int hh = MathHelper.func_76141_d((float)((float)(this.bounds.height - 16) / 18.0f));
            int actualHeight = Math.min(hh, workstations.size());
            int innerWidth = MathHelper.func_76123_f((float)((float)workstations.size() / (float)hh));
            int xx = this.bounds.x - (8 + innerWidth * 16) + 6;
            int yy = this.bounds.y + 16;
            this.workingStationsBaseWidget = Widgets.createCategoryBase(new Rectangle(xx - 5, yy - 5, 15 + innerWidth * 16, 10 + actualHeight * 16));
            this.preWidgets.add(this.workingStationsBaseWidget);
            this.preWidgets.add(Widgets.createSlotBase(new Rectangle(xx - 1, yy - 1, innerWidth * 16 + 2, actualHeight * 16 + 2)));
            int index = 0;
            xx += (innerWidth - 1) * 16;
            for (EntryIngredient workingStation : workstations) {
                this.preWidgets.add(new WorkstationSlotWidget(xx, yy, workingStation));
                yy += 16;
                if (++index < hh) continue;
                index = 0;
                yy = this.bounds.y + 16;
                xx -= 16;
            }
        }
        this.field_230705_e_.addAll(this.tabs);
        this.field_230705_e_.addAll(this.widgets);
        this.field_230705_e_.addAll(this.preWidgets);
    }

    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public List<Display> getCurrentDisplayed() {
        ArrayList list = Lists.newArrayList();
        int recipesPerPage = this.getRecipesPerPage();
        List displays = (List)this.categoryMap.get(this.getCurrentCategory());
        for (int i = 0; i <= recipesPerPage; ++i) {
            if (this.page * (recipesPerPage + 1) + i >= displays.size()) continue;
            list.add(displays.get(this.page * (recipesPerPage + 1) + i));
        }
        return list;
    }

    public int getPage() {
        return this.page;
    }

    public int getCategoryPage() {
        return this.categoryPages;
    }

    private int getRecipesPerPage() {
        DisplayCategory<Display> selectedCategory = this.getCurrentCategory();
        if (selectedCategory.getFixedDisplaysPerPage() > 0) {
            return selectedCategory.getFixedDisplaysPerPage() - 1;
        }
        int height = selectedCategory.getDisplayHeight();
        return MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)(((double)this.bounds.getHeight() - 36.0) / ((double)height + 4.0))) - 1), (int)0, (int)Math.min(ConfigObject.getInstance().getMaxRecipePerPage() - 1, selectedCategory.getMaximumDisplaysPerPage() - 1));
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.func_238468_a_(matrices, 0, 0, this.field_230708_k_, this.field_230709_l_, -1072689136, -804253680);
        for (Widget widget : this.preWidgets) {
            widget.func_230430_a_(matrices, mouseX, mouseY, delta);
        }
        PanelWidget.render(matrices, this.bounds, -1);
        if (REIHelper.getInstance().isDarkThemeEnabled()) {
            DefaultDisplayViewingScreen.func_238467_a_((MatrixStack)matrices, (int)(this.bounds.x + 17), (int)(this.bounds.y + 5), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 17), (int)-12566464);
            DefaultDisplayViewingScreen.func_238467_a_((MatrixStack)matrices, (int)(this.bounds.x + 17), (int)(this.bounds.y + 19), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 30), (int)-12566464);
        } else {
            DefaultDisplayViewingScreen.func_238467_a_((MatrixStack)matrices, (int)(this.bounds.x + 17), (int)(this.bounds.y + 5), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 17), (int)-6381922);
            DefaultDisplayViewingScreen.func_238467_a_((MatrixStack)matrices, (int)(this.bounds.x + 17), (int)(this.bounds.y + 19), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 31), (int)-6381922);
        }
        for (TabWidget tab : this.tabs) {
            if (tab.isSelected()) continue;
            tab.func_230430_a_(matrices, mouseX, mouseY, delta);
        }
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
        for (Widget widget : this.widgets) {
            widget.func_230430_a_(matrices, mouseX, mouseY, delta);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (TabWidget tab : this.tabs) {
            if (!tab.isSelected()) continue;
            tab.func_230430_a_(matrices, mouseX, mouseY, delta);
        }
        ModifierKeyCode export = ConfigObject.getInstance().getExportImageKeybind();
        if (export.matchesCurrentKey() || export.matchesCurrentMouse()) {
            for (Map.Entry<Rectangle, List<Widget>> entry : this.recipeBounds.entrySet()) {
                Rectangle bounds = entry.getKey();
                this.func_230926_e_(470);
                if (bounds.contains(mouseX, mouseY)) {
                    this.func_238468_a_(matrices, bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), 1744822402, 1744822402);
                    TranslationTextComponent text = new TranslationTextComponent("text.rei.release_export", new Object[]{export.getLocalizedName().func_230531_f_().getString()});
                    IRenderTypeBuffer.Impl immediate = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                    matrices.func_227860_a_();
                    matrices.func_227861_a_(0.0, 0.0, 480.0);
                    Matrix4f matrix4f = matrices.func_227866_c_().func_227870_a_();
                    this.field_230712_o_.func_238416_a_(text.func_241878_f(), (float)bounds.getCenterX() - (float)this.field_230712_o_.func_238414_a_((ITextProperties)text) / 2.0f, (float)bounds.getCenterY() - 4.5f, -16777216, false, matrix4f, (IRenderTypeBuffer)immediate, false, 0, 0xF000F0);
                    immediate.func_228461_a_();
                    matrices.func_227865_b_();
                } else {
                    this.func_238468_a_(matrices, bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), 0x67FFFFFF, 0x67FFFFFF);
                }
                this.func_230926_e_(0);
            }
        }
        if (this.choosePageActivated) {
            this.func_230926_e_(500);
            this.func_238468_a_(matrices, 0, 0, this.field_230708_k_, this.field_230709_l_, -1072689136, -804253680);
            this.func_230926_e_(0);
            this.choosePageWidget.func_230430_a_(matrices, mouseX, mouseY, delta);
        }
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        ModifierKeyCode export = ConfigObject.getInstance().getExportImageKeybind();
        if (export.matchesKey(keyCode, scanCode)) {
            for (Map.Entry<Rectangle, List<Widget>> entry : this.recipeBounds.entrySet()) {
                Rectangle bounds = entry.getKey();
                if (!bounds.contains(PointHelper.ofMouse())) continue;
                RecipeDisplayExporter.exportRecipeDisplay(bounds, entry.getValue());
                break;
            }
        }
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public int getCurrentTotalPages() {
        return this.getTotalPages(this.selectedCategoryIndex);
    }

    public int getTotalPages(int categoryIndex) {
        return MathHelper.func_76143_f((double)((double)((List)this.categoryMap.get(this.categories.get(categoryIndex))).size() / (double)(this.getRecipesPerPage() + 1)));
    }

    public boolean func_231042_a_(char char_1, int int_1) {
        if (this.choosePageActivated) {
            return this.choosePageWidget.func_231042_a_(char_1, int_1);
        }
        for (IGuiEventListener listener : this.func_231039_at__()) {
            if (!listener.func_231042_a_(char_1, int_1)) continue;
            return true;
        }
        return super.func_231042_a_(char_1, int_1);
    }

    public boolean func_231045_a_(double double_1, double double_2, int int_1, double double_3, double double_4) {
        if (this.choosePageActivated) {
            return this.choosePageWidget.func_231045_a_(double_1, double_2, int_1, double_3, double_4);
        }
        for (IGuiEventListener entry : this.func_231039_at__()) {
            if (!entry.func_231045_a_(double_1, double_2, int_1, double_3, double_4)) continue;
            return true;
        }
        return super.func_231045_a_(double_1, double_2, int_1, double_3, double_4);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.choosePageActivated) {
            return this.choosePageWidget.func_231048_c_(mouseX, mouseY, button);
        }
        ModifierKeyCode export = ConfigObject.getInstance().getExportImageKeybind();
        if (export.matchesMouse(button)) {
            for (Map.Entry<Rectangle, List<Widget>> entry : this.recipeBounds.entrySet()) {
                Rectangle bounds = entry.getKey();
                if (!bounds.contains(PointHelper.ofMouse())) continue;
                RecipeDisplayExporter.exportRecipeDisplay(bounds, entry.getValue());
                break;
            }
        }
        for (IGuiEventListener entry : this.func_231039_at__()) {
            if (!entry.func_231048_c_(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        REIHelperImpl.isWithinRecipeViewingScreen = true;
        for (IGuiEventListener listener : this.func_231039_at__()) {
            if (!listener.func_231043_a_(mouseX, mouseY, amount)) continue;
            REIHelperImpl.isWithinRecipeViewingScreen = false;
            return true;
        }
        REIHelperImpl.isWithinRecipeViewingScreen = false;
        if (this.getBounds().contains(PointHelper.ofMouse())) {
            if (amount > 0.0 && this.recipeBack.isEnabled()) {
                this.recipeBack.onClick();
            } else if (amount < 0.0 && this.recipeNext.isEnabled()) {
                this.recipeNext.onClick();
            }
        }
        if (new Rectangle(this.bounds.x, this.bounds.y - 28, this.bounds.width, 28).contains(PointHelper.ofMouse())) {
            if (amount > 0.0 && this.categoryBack.isEnabled()) {
                this.categoryBack.onClick();
            } else if (amount < 0.0 && this.categoryNext.isEnabled()) {
                this.categoryNext.onClick();
            }
        }
        return super.func_231043_a_(mouseX, mouseY, amount);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.choosePageActivated) {
            if (this.choosePageWidget.containsMouse(mouseX, mouseY)) {
                return this.choosePageWidget.func_231044_a_(mouseX, mouseY, button);
            }
            this.choosePageActivated = false;
            this.func_231160_c_();
            return false;
        }
        if (ConfigObject.getInstance().getNextPageKeybind().matchesMouse(button)) {
            if (this.recipeNext.isEnabled()) {
                this.recipeNext.onClick();
            }
            return this.recipeNext.isEnabled();
        }
        if (ConfigObject.getInstance().getPreviousPageKeybind().matchesMouse(button)) {
            if (this.recipeBack.isEnabled()) {
                this.recipeBack.onClick();
            }
            return this.recipeBack.isEnabled();
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public IGuiEventListener func_241217_q_() {
        if (this.choosePageActivated) {
            return this.choosePageWidget;
        }
        return super.func_241217_q_();
    }

    public static class WorkstationSlotWidget
    extends EntryWidget {
        public WorkstationSlotWidget(int x, int y, EntryIngredient widgets) {
            super(new Point(x, y));
            this.entries((Collection)widgets);
            this.noBackground();
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return this.getInnerBounds().contains(mouseX, mouseY);
        }
    }
}

