/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.entry.renderer.BatchedEntryRenderer;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;

public class BatchedEntryRendererManager {
    private boolean fastEntryRendering = ConfigObject.getInstance().doesFastEntryRendering();
    private Int2ObjectMap<List<EntryWidget>> grouping = new Int2ObjectOpenHashMap();
    private List<EntryWidget> toRender = new ArrayList<EntryWidget>();

    public BatchedEntryRendererManager() {
    }

    public BatchedEntryRendererManager(Collection<? extends EntryWidget> widgets) {
        this.addAll(widgets);
    }

    public void addAll(Collection<? extends EntryWidget> widgets) {
        if (this.fastEntryRendering) {
            for (EntryWidget entryWidget : widgets) {
                this.add(entryWidget);
            }
        } else {
            this.toRender.addAll(widgets);
        }
    }

    public void add(EntryWidget widget) {
        EntryStack cast;
        BatchedEntryRenderer batchedRenderer;
        EntryStack<?> currentEntry;
        EntryRenderer<?> renderer;
        if (this.fastEntryRendering && (renderer = (currentEntry = widget.getCurrentEntry()).getRenderer()) instanceof BatchedEntryRenderer && (batchedRenderer = (BatchedEntryRenderer)renderer).isBatched(cast = currentEntry.cast())) {
            int hash = batchedRenderer.getBatchIdentifier(cast, widget.getBounds(), batchedRenderer.getExtraData(cast));
            ArrayList<EntryWidget> entries = (ArrayList<EntryWidget>)this.grouping.get(hash);
            if (entries == null) {
                entries = new ArrayList<EntryWidget>();
                this.grouping.put(hash, entries);
            }
            entries.add(widget);
            return;
        }
        this.toRender.add(widget);
    }

    public void render(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.render(false, null, null, matrices, mouseX, mouseY, delta);
    }

    public void render(boolean debugTime, MutableInt size, MutableLong time, MatrixStack matrices, int mouseX, int mouseY, float delta) {
        if (this.fastEntryRendering) {
            for (List entries : this.grouping.values()) {
                BatchedEntryRendererManager.renderEntries(debugTime, size, time, this.fastEntryRendering, matrices, mouseX, mouseY, delta, entries);
            }
        }
        if (!this.toRender.isEmpty()) {
            BatchedEntryRendererManager.renderSlow(debugTime, size, time, matrices, mouseX, mouseY, delta, this.toRender);
        }
    }

    public static <T extends EntryWidget> void renderEntries(boolean debugTime, MutableInt size, MutableLong time, boolean fastEntryRendering, MatrixStack matrices, int mouseX, int mouseY, float delta, Collection<T> entries) {
        if (fastEntryRendering) {
            EntryWidget firstWidget = (EntryWidget)Iterables.getFirst(entries, null);
            if (firstWidget == null) {
                return;
            }
            EntryRenderer<?> renderer = firstWidget.getCurrentEntry().getRenderer();
            if (renderer instanceof BatchedEntryRenderer) {
                BatchedEntryRenderer firstRenderer = (BatchedEntryRenderer)renderer;
                Object[] extraData = new Object[entries.size()];
                int i = 0;
                for (EntryWidget entry : entries) {
                    EntryStack<?> currentEntry = entry.getCurrentEntry();
                    extraData[i++] = ((BatchedEntryRenderer)currentEntry.getRenderer()).getExtraData(currentEntry.cast());
                }
                BatchedEntryRendererManager.renderBatched(debugTime, size, time, matrices, mouseX, mouseY, delta, entries, extraData);
                return;
            }
        }
        BatchedEntryRendererManager.renderSlow(debugTime, size, time, matrices, mouseX, mouseY, delta, entries);
    }

    private static <T extends EntryWidget> void renderBatched(boolean debugTime, MutableInt size, MutableLong time, MatrixStack matrices, int mouseX, int mouseY, float delta, Iterable<T> entries, Object[] extraData) {
        EntryStack<?> currentEntry;
        EntryWidget firstWidget = (EntryWidget)Iterables.getFirst(entries, null);
        if (firstWidget == null) {
            return;
        }
        EntryStack<?> first = firstWidget.getCurrentEntry();
        EntryRenderer<?> renderer = first.getRenderer();
        BatchedEntryRenderer firstRenderer = (BatchedEntryRenderer)renderer;
        matrices = firstRenderer.batchModifyMatrices(matrices);
        firstRenderer.startBatch(first, extraData[0], matrices, delta);
        long l = debugTime ? System.nanoTime() : 0L;
        IRenderTypeBuffer.Impl immediate = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        int i = 0;
        for (EntryWidget listEntry : entries) {
            currentEntry = listEntry.getCurrentEntry();
            currentEntry.setZ(100);
            listEntry.drawBackground(matrices, mouseX, mouseY, delta);
            firstRenderer.renderBase(currentEntry, extraData[i++], matrices, immediate, listEntry.getInnerBounds(), mouseX, mouseY, delta);
            if (!debugTime || currentEntry.isEmpty()) continue;
            size.increment();
        }
        immediate.func_228461_a_();
        i = 0;
        for (EntryWidget listEntry : entries) {
            currentEntry = listEntry.getCurrentEntry();
            firstRenderer.renderOverlay(currentEntry, extraData[i++], matrices, immediate, listEntry.getInnerBounds(), mouseX, mouseY, delta);
            if (!listEntry.containsMouse(mouseX, mouseY)) continue;
            listEntry.queueTooltip(matrices, mouseX, mouseY, delta);
            listEntry.drawHighlighted(matrices, mouseX, mouseY, delta);
        }
        immediate.func_228461_a_();
        if (debugTime) {
            time.add(System.nanoTime() - l);
        }
        firstRenderer.endBatch(first, extraData[0], matrices, delta);
    }

    private static <T extends EntryWidget> void renderSlow(boolean debugTime, MutableInt size, MutableLong time, MatrixStack matrices, int mouseX, int mouseY, float delta, Iterable<T> entries) {
        for (EntryWidget entry : entries) {
            if (entry.getCurrentEntry().isEmpty()) continue;
            if (debugTime) {
                size.increment();
                long l = System.nanoTime();
                entry.func_230430_a_(matrices, mouseX, mouseY, delta);
                time.add(System.nanoTime() - l);
                continue;
            }
            entry.func_230430_a_(matrices, mouseX, mouseY, delta);
        }
    }
}

