/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import me.shedaniel.architectury.fluid.FluidStack;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.ScrollingContainer;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.REIHelper;
import me.shedaniel.rei.api.client.REIOverlay;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.EntryPanelOrdering;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.gui.ContainerScreenOverlay;
import me.shedaniel.rei.impl.client.gui.widget.BatchedEntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.EntryListEntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.FavoritesListWidget;
import me.shedaniel.rei.impl.client.search.AsyncSearchManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class EntryListWidget
extends WidgetWithBounds {
    static final Comparator<? super EntryStack<?>> ENTRY_NAME_COMPARER = Comparator.comparing(stack -> stack.asFormatStrippedText().getString());
    static final Comparator<? super EntryStack<?>> ENTRY_GROUP_COMPARER = Comparator.comparingInt(stack -> {
        ItemGroup group;
        if (stack.getType() == VanillaEntryTypes.ITEM && (group = ((ItemStack)stack.getValue()).func_77973_b().func_77640_w()) != null) {
            return group.func_78021_a();
        }
        return Integer.MAX_VALUE;
    });
    private static final int SIZE = 18;
    private static final boolean LAZY = true;
    private static int page;
    protected final ScrollingContainer scrolling = new ScrollingContainer(){

        public Rectangle getBounds() {
            return EntryListWidget.this.getBounds();
        }

        public int getMaxScrollHeight() {
            return MathHelper.func_76123_f((float)((float)(EntryListWidget.this.allStacks.size() + EntryListWidget.this.blockedCount) / ((float)((EntryListWidget)EntryListWidget.this).innerBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize();
        }
    };
    protected int blockedCount;
    private boolean debugTime;
    private double lastAverageDebugTime;
    private double averageDebugTime;
    private double lastTotalDebugTime;
    private double totalDebugTime;
    private double totalDebugTimeDelta;
    private Rectangle bounds;
    private Rectangle innerBounds;
    private List<EntryStack<?>> allStacks = null;
    private List<EntryListEntry> entries = Collections.emptyList();
    private List<Widget> renders = Collections.emptyList();
    private List<Widget> widgets = Collections.emptyList();
    private AsyncSearchManager searchManager = AsyncSearchManager.createDefault();

    public static int entrySize() {
        return MathHelper.func_76143_f((double)(18.0 * ConfigObject.getInstance().getEntrySize()));
    }

    public static boolean notSteppingOnExclusionZones(int left, int top, int width, int height, Rectangle listArea) {
        Minecraft instance = Minecraft.func_71410_x();
        for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(instance.field_71462_r)) {
            ActionResultType fit = EntryListWidget.canItemSlotWidgetFit(left, top, width, height, decider);
            if (fit == ActionResultType.PASS) continue;
            return fit == ActionResultType.SUCCESS;
        }
        return true;
    }

    private static ActionResultType canItemSlotWidgetFit(int left, int top, int width, int height, OverlayDecider decider) {
        ActionResultType fit = decider.isInZone(left, top);
        if (fit != ActionResultType.PASS) {
            return fit;
        }
        fit = decider.isInZone(left + width, top);
        if (fit != ActionResultType.PASS) {
            return fit;
        }
        fit = decider.isInZone(left, top + height);
        if (fit != ActionResultType.PASS) {
            return fit;
        }
        fit = decider.isInZone(left + width, top + height);
        return fit;
    }

    private static Rectangle updateInnerBounds(Rectangle bounds) {
        bounds = bounds.clone();
        int widthReduction = (int)Math.round((double)bounds.width * (1.0 - ConfigObject.getInstance().getHorizontalEntriesBoundaries()));
        int heightReduction = (int)Math.round((double)bounds.width * (1.0 - ConfigObject.getInstance().getVerticalEntriesBoundaries()));
        bounds.x += widthReduction;
        bounds.width -= widthReduction;
        bounds.y += heightReduction / 2;
        bounds.height -= heightReduction;
        int entrySize = EntryListWidget.entrySize();
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            int width = Math.max(MathHelper.func_76141_d((float)((float)(bounds.width - 2 - 6) / (float)entrySize)), 1);
            if (ConfigObject.getInstance().isLeftHandSidePanel()) {
                return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f) + 3.0f), bounds.y, width * entrySize, bounds.height);
            }
            return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f) - 3.0f), bounds.y, width * entrySize, bounds.height);
        }
        int width = Math.max(MathHelper.func_76141_d((float)((float)(bounds.width - 2) / (float)entrySize)), 1);
        int height = Math.max(MathHelper.func_76141_d((float)((float)(bounds.height - 2) / (float)entrySize)), 1);
        return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f)), (int)((float)bounds.getCenterY() - (float)height * ((float)entrySize / 2.0f)), width * entrySize, height * entrySize);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        if (this.bounds.contains(mouseX, mouseY)) {
            if (Screen.func_231172_r_()) {
                ConfigObjectImpl config = ConfigManagerImpl.getInstance().getConfig();
                if (config.setEntrySize(config.getEntrySize() + amount * 0.075)) {
                    ConfigManager.getInstance().saveConfig();
                    REIHelper.getInstance().getOverlay().ifPresent(REIOverlay::queueReloadOverlay);
                    return true;
                }
            } else if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
                this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
                return true;
            }
        }
        return super.func_231043_a_(mouseX, mouseY, amount);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public int getPage() {
        return page;
    }

    public void setPage(int page) {
        EntryListWidget.page = page;
    }

    public void previousPage() {
        --page;
    }

    public void nextPage() {
        ++page;
    }

    public int getTotalPages() {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            return 1;
        }
        return MathHelper.func_76123_f((float)((float)this.allStacks.size() / (float)this.entries.size()));
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        MutableInt size = new MutableInt();
        MutableLong time = new MutableLong();
        long totalTimeStart = this.debugTime ? System.nanoTime() : 0L;
        boolean fastEntryRendering = ConfigObject.getInstance().doesFastEntryRendering();
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            ScissorsHandler.INSTANCE.scissor(this.bounds);
            int skip = Math.max(0, MathHelper.func_76128_c((double)(this.scrolling.scrollAmount / (double)EntryListWidget.entrySize())));
            int nextIndex = skip * this.innerBounds.width / EntryListWidget.entrySize();
            this.blockedCount = 0;
            BatchedEntryRendererManager batchedEntryRendererManager = new BatchedEntryRendererManager();
            int i = nextIndex;
            for (int cont = nextIndex; cont < this.entries.size(); ++cont) {
                EntryListEntry entry = this.entries.get(cont);
                Rectangle entryBounds = entry.getBounds();
                entryBounds.y = (int)((double)entry.backupY - this.scrolling.scrollAmount);
                if (entryBounds.y > this.bounds.getMaxY() || this.allStacks.size() <= i) break;
                if (EntryListWidget.notSteppingOnExclusionZones(entryBounds.x, entryBounds.y, entryBounds.width, entryBounds.height, this.innerBounds)) {
                    EntryStack<?> stack = this.allStacks.get(i++);
                    entry.clearStacks();
                    if (stack.isEmpty()) continue;
                    entry.entry((EntryStack)stack);
                    batchedEntryRendererManager.add(entry);
                    continue;
                }
                ++this.blockedCount;
            }
            batchedEntryRendererManager.render(this.debugTime, size, time, matrices, mouseX, mouseY, delta);
            this.updatePosition(delta);
            ScissorsHandler.INSTANCE.removeLastScissor();
            if (this.scrolling.getMaxScroll() > 0) {
                this.scrolling.renderScrollBar(0, 1.0f, REIHelper.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
            }
        } else {
            for (Widget widget : this.renders) {
                widget.func_230430_a_(matrices, mouseX, mouseY, delta);
            }
            new BatchedEntryRendererManager(this.entries).render(this.debugTime, size, time, matrices, mouseX, mouseY, delta);
        }
        if (this.debugTime) {
            long totalTime = System.nanoTime() - totalTimeStart;
            this.averageDebugTime += (double)time.getValue().longValue() / size.doubleValue() * (double)delta;
            this.totalDebugTime += (double)totalTime / 1000000.0 * (double)delta;
            this.totalDebugTimeDelta += (double)delta;
            if (this.totalDebugTimeDelta >= 20.0) {
                this.lastAverageDebugTime = this.averageDebugTime / this.totalDebugTimeDelta;
                this.lastTotalDebugTime = this.totalDebugTime / this.totalDebugTimeDelta;
                this.averageDebugTime = 0.0;
                this.totalDebugTime = 0.0;
                this.totalDebugTimeDelta = 0.0;
            } else if (this.lastAverageDebugTime == 0.0) {
                this.lastAverageDebugTime = (double)time.getValue().longValue() / size.doubleValue();
                this.totalDebugTime = (double)totalTime / 1000000.0;
            }
            int n = this.getZ();
            this.setZ(500);
            StringTextComponent debugText = new StringTextComponent(String.format("%d entries, avg. %.0fns, ttl. %.2fms, %s fps", size.getValue(), this.lastAverageDebugTime, this.lastTotalDebugTime, this.minecraft.field_71426_K.split(" ")[0]));
            int stringWidth = this.font.func_238414_a_((ITextProperties)debugText);
            int n2 = Math.min(this.bounds.x, this.minecraft.field_71462_r.field_230708_k_ - stringWidth - 2);
            int n3 = this.bounds.y;
            int n4 = this.bounds.x + stringWidth + 2;
            int n5 = this.bounds.y;
            this.font.getClass();
            this.func_238468_a_(matrices, n2, n3, n4, n5 + 9 + 2, -16777216, -16777216);
            IRenderTypeBuffer.Impl immediate = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            matrices.func_227860_a_();
            matrices.func_227861_a_(0.0, 0.0, (double)this.getZ());
            Matrix4f matrix = matrices.func_227866_c_().func_227870_a_();
            this.font.func_238416_a_(debugText.func_241878_f(), (float)Math.min(this.bounds.x + 2, this.minecraft.field_71462_r.field_230708_k_ - stringWidth), (float)(this.bounds.y + 2), -1, false, matrix, (IRenderTypeBuffer)immediate, false, 0, 0xF000F0);
            immediate.func_228461_a_();
            this.setZ(n);
            matrices.func_227865_b_();
        }
        if (this.containsMouse(mouseX, mouseY) && ClientHelper.getInstance().isCheating() && !this.minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && ClientHelperImpl.getInstance().canDeleteItems()) {
            Item bucketItem;
            EntryStack<ItemStack> stack = EntryStacks.of(this.minecraft.field_71439_g.field_71071_by.func_70445_o().func_77946_l());
            if (stack.getValueType() == FluidStack.class && (bucketItem = ((FluidStack)stack.getValue()).getFluid().func_204524_b()) != null) {
                stack = EntryStacks.of((IItemProvider)bucketItem);
            }
            for (Widget widget : this.func_231039_at__()) {
                if (!widget.containsMouse(mouseX, mouseY) || !(widget instanceof EntryWidget) || !((EntryWidget)widget).cancelDeleteItems(stack)) continue;
                return;
            }
            Tooltip.create(new ITextComponent[]{new TranslationTextComponent("text.rei.delete_items")}).queue();
        }
    }

    private int getScrollbarMinX() {
        if (ConfigObject.getInstance().isLeftHandSidePanel()) {
            return this.bounds.x + 1;
        }
        return this.bounds.getMaxX() - 7;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, button, dx, dy, ConfigObject.getInstance().doesSnapToRows(), (double)EntryListWidget.entrySize())) {
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, button, dx, dy);
    }

    private void updatePosition(float delta) {
        if (ConfigObject.getInstance().doesSnapToRows() && this.scrolling.scrollTarget >= 0.0 && this.scrolling.scrollTarget <= (double)this.scrolling.getMaxScroll()) {
            double nearestRow = (double)Math.round(this.scrolling.scrollTarget / (double)EntryListWidget.entrySize()) * (double)EntryListWidget.entrySize();
            this.scrolling.scrollTarget = !DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals((double)this.scrolling.scrollTarget, (double)nearestRow, (double)0.001f) ? (this.scrolling.scrollTarget += (nearestRow - this.scrolling.scrollTarget) * Math.min((double)delta / 2.0, 1.0)) : nearestRow;
        }
        this.scrolling.updatePosition(delta);
    }

    public boolean func_231046_a_(int int_1, int int_2, int int_3) {
        if (this.containsMouse(PointHelper.ofMouse())) {
            for (Widget widget : this.widgets) {
                if (!widget.func_231046_a_(int_1, int_2, int_3)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateArea(String searchTerm) {
        this.bounds = REIHelper.getInstance().calculateEntryListArea();
        FavoritesListWidget favoritesListWidget = ContainerScreenOverlay.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.updateFavoritesBounds(searchTerm);
        }
        if (this.allStacks == null || ConfigObject.getInstance().isFavoritesEnabled() && favoritesListWidget == null) {
            this.updateSearch(searchTerm, true);
        } else {
            this.updateEntriesPosition();
        }
    }

    public void updateEntriesPosition() {
        int entrySize = EntryListWidget.entrySize();
        this.innerBounds = EntryListWidget.updateInnerBounds(this.bounds);
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            this.renders = Lists.newArrayList();
            page = Math.max(page, 0);
            ArrayList entries = Lists.newArrayList();
            int width = this.innerBounds.width / entrySize;
            int height = this.innerBounds.height / entrySize;
            for (int currentY = 0; currentY < height; ++currentY) {
                for (int currentX = 0; currentX < width; ++currentX) {
                    int slotX = currentX * entrySize + this.innerBounds.x;
                    int slotY = currentY * entrySize + this.innerBounds.y;
                    if (!EntryListWidget.notSteppingOnExclusionZones(slotX - 1, slotY - 1, entrySize, entrySize, this.innerBounds)) continue;
                    entries.add((EntryListEntry)new EntryListEntry(slotX, slotY, entrySize).noBackground());
                }
            }
            page = Math.max(Math.min(page, this.getTotalPages() - 1), 0);
            List subList = this.allStacks.stream().skip(Math.max(0, page * entries.size())).limit(Math.max(0, entries.size() - Math.max(0, -page * entries.size()))).collect(Collectors.toList());
            for (int i = 0; i < subList.size(); ++i) {
                EntryStack stack = (EntryStack)subList.get(i);
                ((EntryListEntry)entries.get(i + Math.max(0, -page * entries.size()))).clearStacks().entry(stack);
            }
            this.entries = entries;
            this.widgets = Lists.newArrayList(this.renders);
            this.widgets.addAll(entries);
        } else {
            page = 0;
            int width = this.innerBounds.width / entrySize;
            int pageHeight = this.innerBounds.height / entrySize;
            int slotsToPrepare = Math.max(this.allStacks.size() * 3, width * pageHeight * 3);
            int currentX = 0;
            int currentY = 0;
            ArrayList entries = Lists.newArrayList();
            for (int i = 0; i < slotsToPrepare; ++i) {
                int xPos = currentX * entrySize + this.innerBounds.x;
                int yPos = currentY * entrySize + this.innerBounds.y;
                entries.add((EntryListEntry)new EntryListEntry(xPos, yPos, entrySize).noBackground());
                if (++currentX < width) continue;
                currentX = 0;
                ++currentY;
            }
            this.entries = entries;
            this.widgets = Lists.newArrayList(this.renders);
            this.widgets.addAll(entries);
        }
        FavoritesListWidget favoritesListWidget = ContainerScreenOverlay.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.updateEntriesPosition(entry -> true);
        }
    }

    @ApiStatus.Internal
    public List<EntryStack<?>> getAllStacks() {
        return this.allStacks;
    }

    public void updateSearch(String searchTerm, boolean ignoreLastSearch) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (ignoreLastSearch) {
            this.searchManager.markDirty();
        }
        this.searchManager.updateFilter(searchTerm);
        if (this.searchManager.isDirty()) {
            List<EntryStack<?>> list = this.searchManager.get();
            EntryPanelOrdering ordering = ConfigObject.getInstance().getItemListOrdering();
            if (ordering == EntryPanelOrdering.NAME) {
                list.sort(ENTRY_NAME_COMPARER);
            }
            if (ordering == EntryPanelOrdering.GROUPS) {
                list.sort(ENTRY_GROUP_COMPARER);
            }
            if (!ConfigObject.getInstance().isItemListAscending()) {
                Collections.reverse(list);
            }
            this.allStacks = list;
        }
        this.debugTime = ConfigObject.getInstance().doDebugRenderTimeRequired();
        FavoritesListWidget favorites = ContainerScreenOverlay.getFavoritesListWidget();
        if (favorites != null) {
            favorites.updateSearch();
        }
        if (ConfigObject.getInstance().doDebugSearchTimeRequired()) {
            RoughlyEnoughItemsCore.LOGGER.info("Search Used: %s", (Object)stopwatch.stop().toString());
        }
        this.updateEntriesPosition();
    }

    public boolean matches(EntryStack<?> stack) {
        return this.searchManager.matches(stack);
    }

    public List<? extends Widget> func_231039_at__() {
        return this.widgets;
    }

    public boolean func_231044_a_(double double_1, double double_2, int int_1) {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled() && this.scrolling.updateDraggingState(double_1, double_2, int_1)) {
            return true;
        }
        for (Widget widget : this.func_231039_at__()) {
            if (!widget.func_231044_a_(double_1, double_2, int_1)) continue;
            return true;
        }
        return false;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.containsMouse(mouseX, mouseY)) {
            ClientPlayerEntity player = this.minecraft.field_71439_g;
            if (ClientHelper.getInstance().isCheating() && player != null && player.field_71071_by != null && !player.field_71071_by.func_70445_o().func_190926_b() && ClientHelperImpl.getInstance().canDeleteItems()) {
                ClientHelper.getInstance().sendDeletePacket();
                return true;
            }
            for (Widget widget : this.func_231039_at__()) {
                if (!widget.func_231048_c_(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return false;
    }

    private class EntryListEntry
    extends EntryListEntryWidget {
        private EntryListEntry(int x, int y, int entrySize) {
            super(new Point(x, y), entrySize);
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return super.containsMouse(mouseX, mouseY) && EntryListWidget.this.bounds.contains(mouseX, mouseY);
        }
    }
}

