/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.LazyResettable;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.ScrollingContainer;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIHelper;
import me.shedaniel.rei.api.client.REIOverlay;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.client.gui.AbstractContainerEventHandler;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitorWidget;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.Animator;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.gui.ContainerScreenOverlay;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.modules.MenuEntry;
import me.shedaniel.rei.impl.client.gui.widget.BatchedEntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.EntryListEntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.EntryListWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FavoritesListWidget
extends WidgetWithBounds
implements DraggableStackProviderWidget,
DraggableStackVisitorWidget {
    protected final ScrollingContainer scrolling = new ScrollingContainer(){

        public Rectangle getBounds() {
            return FavoritesListWidget.this.currentBounds;
        }

        public int getMaxScrollHeight() {
            return MathHelper.func_76123_f((float)((float)(FavoritesListWidget.this.entries.size() + FavoritesListWidget.this.blockedCount) / ((float)((FavoritesListWidget)FavoritesListWidget.this).innerBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize();
        }

        public int getScrollBarX() {
            if (!ConfigObject.getInstance().isLeftHandSidePanel()) {
                return ((FavoritesListWidget)FavoritesListWidget.this).fullBounds.x + 1;
            }
            return FavoritesListWidget.this.fullBounds.getMaxX() - 7;
        }
    };
    protected int blockedCount;
    private Rectangle fullBounds;
    private Rectangle currentBounds = new Rectangle();
    private Rectangle innerBounds;
    private final Int2ObjectMap<Entry> entries = new Int2ObjectLinkedOpenHashMap();
    private final Int2ObjectMap<Entry> removedEntries = new Int2ObjectLinkedOpenHashMap();
    private List<EntryListEntry> entriesList = Lists.newArrayList();
    private List<Widget> children = Lists.newArrayList();
    public final AddFavoritePanel favoritePanel = new AddFavoritePanel(this);
    public final ToggleAddFavoritePanelButton favoritePanelButton = new ToggleAddFavoritePanelButton(this);

    private static Rectangle updateInnerBounds(Rectangle bounds) {
        int entrySize = EntryListWidget.entrySize();
        int width = Math.max(MathHelper.func_76141_d((float)((float)(bounds.width - 2 - 6) / (float)entrySize)), 1);
        if (!ConfigObject.getInstance().isLeftHandSidePanel()) {
            return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f) + 3.0f), bounds.y, width * entrySize, bounds.height);
        }
        return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f) - 3.0f), bounds.y, width * entrySize, bounds.height);
    }

    public boolean func_231043_a_(double double_1, double double_2, double double_3) {
        if (this.currentBounds.contains(double_1, double_2)) {
            if (Screen.func_231172_r_()) {
                ConfigObjectImpl config = ConfigManagerImpl.getInstance().getConfig();
                if (config.setEntrySize(config.getEntrySize() + double_3 * 0.075)) {
                    ConfigManager.getInstance().saveConfig();
                    REIHelper.getInstance().getOverlay().ifPresent(REIOverlay::queueReloadOverlay);
                    return true;
                }
            } else {
                if (this.favoritePanel.func_231043_a_(double_1, double_2, double_3)) {
                    return true;
                }
                this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
                return true;
            }
        }
        return super.func_231043_a_(double_1, double_2, double_3);
    }

    @Override
    public Rectangle getBounds() {
        return this.fullBounds;
    }

    @Override
    @Nullable
    public DraggableStack getHoveredStack(DraggingContext<Screen> context, double mouseX, double mouseY) {
        if (this.innerBounds.contains(mouseX, mouseY)) {
            for (Entry entry : this.entries.values()) {
                if (!entry.getWidget().containsMouse(mouseX, mouseY)) continue;
                return new FavoriteDraggableStack(entry, false);
            }
        }
        if (this.favoritePanel.bounds.contains(mouseX, mouseY)) {
            for (AddFavoritePanel.Row row : (List)this.favoritePanel.rows.get()) {
                if (!(row instanceof AddFavoritePanel.SectionEntriesRow)) continue;
                for (AddFavoritePanel.SectionEntriesRow.SectionFavoriteWidget widget : ((AddFavoritePanel.SectionEntriesRow)row).widgets) {
                    if (!widget.containsMouse(mouseX, mouseY)) continue;
                    Entry entry = new Entry(widget.entry.copy(), EntryListWidget.entrySize());
                    entry.size.setAs(EntryListWidget.entrySize() * 100);
                    return new FavoriteDraggableStack(entry, true);
                }
            }
        }
        return null;
    }

    @Override
    public Optional<DraggableStackVisitor.Acceptor> visitDraggedStack(DraggingContext<Screen> context, DraggableStack stack) {
        if (this.innerBounds.contains(PointHelper.ofMouse())) {
            EntrySerializer<?> serializer = stack.getStack().getDefinition().getSerializer();
            if (stack instanceof FavoriteDraggableStack || serializer.supportReading() && serializer.supportSaving()) {
                return Optional.of(this::acceptDraggedStack);
            }
        }
        return Optional.empty();
    }

    private void acceptDraggedStack(DraggableStack stack) {
        FavoriteEntry favoriteEntry = stack instanceof FavoriteDraggableStack ? ((FavoriteDraggableStack)stack).favoriteEntry.copy() : FavoriteEntry.fromEntryStack(stack.getStack().copy());
        Entry entry = new Entry(favoriteEntry, EntryListWidget.entrySize());
        entry.size.setAs(EntryListWidget.entrySize() * 100);
        this.drop(entry, stack, favoriteEntry);
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        if (this.fullBounds.isEmpty() || this.currentBounds.isEmpty()) {
            return;
        }
        int entrySize = EntryListWidget.entrySize();
        boolean fastEntryRendering = ConfigObject.getInstance().doesFastEntryRendering();
        this.updateEntriesPosition(entry -> true);
        for (Entry entry2 : this.entries.values()) {
            entry2.update(delta);
        }
        ObjectIterator removedEntriesIterator = this.removedEntries.values().iterator();
        while (removedEntriesIterator.hasNext()) {
            Entry removedEntry = (Entry)removedEntriesIterator.next();
            removedEntry.update(delta);
            if (!(removedEntry.size.doubleValue() <= 300.0)) continue;
            removedEntriesIterator.remove();
            this.entriesList.remove(removedEntry.getWidget());
            this.children.remove(removedEntry.getWidget());
        }
        ScissorsHandler.INSTANCE.scissor(this.currentBounds);
        Stream<EntryListEntry> entryStream = this.entriesList.stream().filter(entry -> entry.getBounds().getMaxY() >= this.currentBounds.getY() && entry.getBounds().y <= this.currentBounds.getMaxY());
        new BatchedEntryRendererManager(entryStream.collect(Collectors.toList())).render(matrices, mouseX, mouseY, delta);
        this.updatePosition(delta);
        this.scrolling.renderScrollBar(0, 1.0f, REIHelper.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
        ScissorsHandler.INSTANCE.removeLastScissor();
        this.renderAddFavorite(matrices, mouseX, mouseY, delta);
    }

    private void renderAddFavorite(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.favoritePanel.func_230430_a_(matrices, mouseX, mouseY, delta);
        this.favoritePanelButton.func_230430_a_(matrices, mouseX, mouseY, delta);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int int_1, double double_3, double double_4) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, int_1, double_3, double_4, ConfigObject.getInstance().doesSnapToRows(), (double)EntryListWidget.entrySize())) {
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, int_1, double_3, double_4);
    }

    private void updatePosition(float delta) {
        if (ConfigObject.getInstance().doesSnapToRows() && this.scrolling.scrollTarget >= 0.0 && this.scrolling.scrollTarget <= (double)this.scrolling.getMaxScroll()) {
            double nearestRow = (double)Math.round(this.scrolling.scrollTarget / (double)EntryListWidget.entrySize()) * (double)EntryListWidget.entrySize();
            this.scrolling.scrollTarget = !DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals((double)this.scrolling.scrollTarget, (double)nearestRow, (double)0.001f) ? (this.scrolling.scrollTarget += (nearestRow - this.scrolling.scrollTarget) * Math.min((double)delta / 2.0, 1.0)) : nearestRow;
        }
        this.scrolling.updatePosition(delta);
    }

    public boolean func_231046_a_(int int_1, int int_2, int int_3) {
        if (this.containsMouse(PointHelper.ofMouse())) {
            for (Widget widget : this.func_231039_at__()) {
                if (!widget.func_231046_a_(int_1, int_2, int_3)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateFavoritesBounds(@Nullable String searchTerm) {
        this.fullBounds = REIHelper.getInstance().calculateFavoritesListArea();
    }

    public void updateSearch() {
        if (ConfigObject.getInstance().isFavoritesEnabled()) {
            this.applyNewFavorites(CollectionUtils.map(ConfigObject.getInstance().getFavoriteEntries(), FavoriteEntry::copy));
        } else {
            this.applyNewFavorites(Collections.emptyList());
        }
    }

    public void applyNewFavorites(List<FavoriteEntry> newFavorites) {
        newFavorites = Lists.newArrayList(newFavorites);
        newFavorites.removeIf(FavoriteEntry::isEntryInvalid);
        int entrySize = EntryListWidget.entrySize();
        IntOpenHashSet newFavoritesHash = new IntOpenHashSet((IntCollection)CollectionUtils.mapToInt(newFavorites, FavoriteEntry::hashCode));
        ArrayList removedEntries = Lists.newArrayList((Iterable)this.entries.values());
        removedEntries.removeIf(arg_0 -> FavoritesListWidget.lambda$applyNewFavorites$2((IntSet)newFavoritesHash, arg_0));
        for (Entry removedEntry : removedEntries) {
            removedEntry.remove();
            this.removedEntries.put(removedEntry.hashIgnoreAmount(), (Object)removedEntry);
        }
        Int2ObjectOpenHashMap prevEntries = new Int2ObjectOpenHashMap(this.entries);
        this.entries.clear();
        for (FavoriteEntry favorite : newFavorites) {
            Entry entry = (Entry)prevEntries.get(favorite.hashCode());
            if (entry == null) {
                entry = new Entry(favorite, entrySize);
            }
            if (!ConfigObject.getInstance().isFavoritesAnimated()) {
                entry.size.setAs(entrySize * 100);
            } else {
                entry.size.setTo(entrySize * 100, 300L);
            }
            this.entries.put(entry.hashIgnoreAmount(), (Object)entry);
        }
        this.applyNewEntriesList();
        this.updateEntriesPosition(arg_0 -> FavoritesListWidget.lambda$applyNewFavorites$3((Int2ObjectMap)prevEntries, arg_0));
    }

    public void applyNewEntriesList() {
        this.entriesList = Stream.concat(this.entries.values().stream().map(Entry::getWidget), this.removedEntries.values().stream().map(Entry::getWidget)).collect(Collectors.toList());
        this.children = Stream.of(this.entries.values().stream().map(Entry::getWidget), this.removedEntries.values().stream().map(Entry::getWidget), Stream.of(this.favoritePanelButton, this.favoritePanel)).flatMap(Function.identity()).collect(Collectors.toList());
    }

    public void updateEntriesPosition(Predicate<Entry> animated) {
        int entrySize = EntryListWidget.entrySize();
        this.blockedCount = 0;
        if (this.favoritePanel.getBounds().height > 20) {
            this.currentBounds.setBounds(this.fullBounds.x, this.fullBounds.y, this.fullBounds.width, this.fullBounds.height - (this.fullBounds.getMaxY() - ((AddFavoritePanel)this.favoritePanel).bounds.y) - 4);
        } else {
            this.currentBounds.setBounds(this.fullBounds);
        }
        this.innerBounds = FavoritesListWidget.updateInnerBounds(this.currentBounds);
        int width = this.innerBounds.width / entrySize;
        int currentX = 0;
        int currentY = 0;
        int releaseIndex = this.getReleaseIndex();
        int slotIndex = 0;
        block0: for (Entry entry : this.entries.values()) {
            while (true) {
                int xPos = currentX * entrySize + this.innerBounds.x;
                int yPos = currentY * entrySize + this.innerBounds.y;
                if (++currentX >= width) {
                    currentX = 0;
                    ++currentY;
                }
                if (EntryListWidget.notSteppingOnExclusionZones(xPos, yPos - (int)this.scrolling.scrollAmount, entrySize, entrySize, this.innerBounds)) {
                    if (slotIndex++ == releaseIndex) continue;
                    entry.moveTo(animated.test(entry), xPos, yPos);
                    continue block0;
                }
                ++this.blockedCount;
            }
        }
    }

    public List<? extends Widget> func_231039_at__() {
        return this.children;
    }

    public int getReleaseIndex() {
        DraggingContext<?> context = DraggingContext.getInstance();
        Point position = context.getCurrentPosition();
        if (context.isDraggingStack() && this.currentBounds.contains(position)) {
            int yPos;
            int xPos;
            int entrySize = EntryListWidget.entrySize();
            int width = this.innerBounds.width / entrySize;
            int currentX = 0;
            int currentY = 0;
            ArrayList entriesPoints = Lists.newArrayList();
            block0: for (Entry entry : this.entries.values()) {
                while (true) {
                    int xPos2 = currentX * entrySize + this.innerBounds.x;
                    int yPos2 = currentY * entrySize + this.innerBounds.y;
                    if (++currentX >= width) {
                        currentX = 0;
                        ++currentY;
                    }
                    if (EntryListWidget.notSteppingOnExclusionZones(xPos2, yPos2 - (int)this.scrolling.scrollAmount, entrySize, entrySize, this.innerBounds)) {
                        entriesPoints.add(new Tuple((Object)entry, (Object)new Point(xPos2, yPos2)));
                        continue block0;
                    }
                    ++this.blockedCount;
                }
            }
            int maxSize = entriesPoints.size();
            if (currentX != 0 && EntryListWidget.notSteppingOnExclusionZones(xPos = currentX * entrySize + this.innerBounds.x, (yPos = currentY * entrySize + this.innerBounds.y) - (int)this.scrolling.scrollAmount, entrySize, entrySize, this.innerBounds)) {
                entriesPoints.add(new Tuple(null, (Object)new Point(xPos, yPos)));
            }
            double x = position.x - 8;
            double y = position.y - 8;
            return MathHelper.func_76125_a((int)entriesPoints.stream().filter(value -> {
                double otherY = ((Point)value.func_76340_b()).y;
                return otherY <= y + (double)(entrySize / 2) && otherY + (double)entrySize > y + (double)(entrySize / 2);
            }).min(Comparator.comparingDouble(value -> {
                double otherX = ((Point)value.func_76340_b()).x;
                double otherY = ((Point)value.func_76340_b()).y;
                return (x - otherX) * (x - otherX) + (y - otherY) * (y - otherY);
            })).map(entriesPoints::indexOf).orElse(maxSize), (int)0, (int)entriesPoints.size());
        }
        return -2;
    }

    public void drop(Entry entry, DraggableStack stack, FavoriteEntry favoriteEntry) {
        int newIndex;
        DraggingContext<?> context = DraggingContext.getInstance();
        double x = context.getCurrentPosition().x;
        double y = context.getCurrentPosition().y;
        entry.startedDraggingPosition = null;
        entry.x.setAs(x - 8.0);
        entry.y.setAs(y - 8.0);
        boolean contains = this.currentBounds.contains(PointHelper.ofMouse());
        int n = newIndex = contains ? this.getReleaseIndex() : Math.max(0, Iterables.indexOf((Iterable)this.entries.values(), e -> e == entry));
        if (this.entries.size() - 1 <= newIndex) {
            Entry remove = (Entry)this.entries.remove(entry.hashIgnoreAmount());
            if (remove != null) {
                remove.remove();
                this.removedEntries.put(remove.hashIgnoreAmount(), (Object)remove);
            }
            this.entries.put(entry.hashIgnoreAmount(), (Object)entry);
        } else {
            Int2ObjectLinkedOpenHashMap prevEntries = new Int2ObjectLinkedOpenHashMap(this.entries);
            this.entries.clear();
            int index = 0;
            for (Int2ObjectMap.Entry entryEntry : prevEntries.int2ObjectEntrySet()) {
                if (index == newIndex) {
                    this.entries.put(entry.hashIgnoreAmount(), (Object)entry);
                }
                if (entryEntry.getIntKey() == entry.hashIgnoreAmount()) continue;
                this.entries.put(entryEntry.getIntKey(), entryEntry.getValue());
                ++index;
            }
        }
        this.applyNewEntriesList();
        if (ConfigObject.getInstance().isFavoritesEnabled()) {
            List<FavoriteEntry> favorites = ConfigObject.getInstance().getFavoriteEntries();
            favorites.clear();
            for (Entry value : this.entries.values()) {
                favorites.add(value.entry.copy());
            }
            ConfigManager.getInstance().saveConfig();
        }
        this.applyNewFavorites(this.entries.values().stream().map(Entry::getEntry).collect(Collectors.toList()));
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
            return true;
        }
        for (Widget widget : this.func_231039_at__()) {
            if (!widget.func_231044_a_(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.containsMouse(mouseX, mouseY)) {
            for (Widget widget : this.func_231039_at__()) {
                if (!widget.func_231048_c_(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$applyNewFavorites$3(Int2ObjectMap prevEntries, Entry entry) {
        return prevEntries.containsKey(entry.hashIgnoreAmount());
    }

    private static /* synthetic */ boolean lambda$applyNewFavorites$2(IntSet newFavoritesHash, Entry entry) {
        return newFavoritesHash.contains(entry.hashIgnoreAmount());
    }

    public static class AddFavoritePanel
    extends WidgetWithBounds {
        private final FavoritesListWidget widget;
        public final Animator expendState = new Animator(0.0);
        private final Rectangle bounds = new Rectangle();
        private final Rectangle scrollBounds = new Rectangle();
        private final LazyResettable<List<Row>> rows = new LazyResettable(() -> {
            ArrayList<Row> rows = new ArrayList<Row>();
            for (FavoriteEntryType.Section section : FavoriteEntryType.registry().sections()) {
                rows.add(new SectionRow(section.getText(), (ITextComponent)section.getText().func_230532_e_().func_240700_a_(style -> style.func_244282_c(Boolean.valueOf(true)))));
                rows.add(new SectionEntriesRow(CollectionUtils.map(section.getEntries(), FavoriteEntry::copy)));
                rows.add(new SectionSeparatorRow());
            }
            if (!rows.isEmpty()) {
                rows.remove(rows.size() - 1);
            }
            return rows;
        });
        private final ScrollingContainer scroller = new ScrollingContainer(){

            public Rectangle getBounds() {
                return scrollBounds;
            }

            public int getMaxScrollHeight() {
                return Math.max(1, ((List)rows.get()).stream().mapToInt(Row::getRowHeight).sum());
            }
        };

        public AddFavoritePanel(FavoritesListWidget widget) {
            this.widget = widget;
        }

        public void resetRows() {
            this.rows.reset();
        }

        public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
            this.bounds.setBounds(this.updatePanelArea(this.widget.fullBounds));
            this.scrollBounds.setBounds(this.bounds.x + 4, this.bounds.y + 4, this.bounds.width - 8, this.bounds.height - 20);
            this.expendState.update(delta);
            int buttonColor = 0xFFFFFF | Math.round(52.0f * Math.min(this.expendState.floatValue() * 2.0f, 1.0f)) << 24;
            this.func_238468_a_(matrices, this.bounds.x, this.bounds.y, this.bounds.getMaxX(), this.bounds.getMaxY(), buttonColor, buttonColor);
            this.scroller.updatePosition(delta);
            if (this.expendState.floatValue() > 0.1f) {
                ScissorsHandler.INSTANCE.scissor(this.scrollBounds);
                matrices.func_227860_a_();
                matrices.func_227861_a_(0.0, this.scroller.scrollAmount, 0.0);
                int y = this.scrollBounds.y;
                for (Row row : (List)this.rows.get()) {
                    row.render(matrices, this.scrollBounds.x, y, this.scrollBounds.width, row.getRowHeight(), mouseX, mouseY, delta);
                    y += row.getRowHeight();
                }
                matrices.func_227865_b_();
                ScissorsHandler.INSTANCE.removeLastScissor();
            }
        }

        private Rectangle updatePanelArea(Rectangle fullArea) {
            int currentWidth = 16 + Math.round(Math.min(this.expendState.floatValue(), 1.0f) * (float)(fullArea.getWidth() - 16 - 8));
            int currentHeight = 16 + Math.round(this.expendState.floatValue() * ((float)fullArea.getHeight() * 0.4f - 16.0f - 8.0f));
            return new Rectangle(fullArea.x + 4, fullArea.getMaxY() - currentHeight - 4, currentWidth, currentHeight);
        }

        public boolean func_231043_a_(double d, double e, double f) {
            if (this.scrollBounds.contains(d, e)) {
                this.scroller.offset(ClothConfigInitializer.getScrollStep() * f, true);
                return true;
            }
            return super.func_231043_a_(d, e, f);
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return (List)this.rows.get();
        }

        @Override
        public Rectangle getBounds() {
            return this.bounds;
        }

        private class SectionEntriesRow
        extends Row {
            private final List<FavoriteEntry> entries;
            private final List<SectionFavoriteWidget> widgets;
            private int blockedCount;
            private int lastY;

            public SectionEntriesRow(List<FavoriteEntry> entries) {
                this.entries = entries;
                int entrySize = EntryListWidget.entrySize();
                this.widgets = CollectionUtils.map(this.entries, entry -> new SectionFavoriteWidget(new Point(0, 0), entrySize, (FavoriteEntry)entry));
                for (SectionFavoriteWidget widget2 : this.widgets) {
                    widget2.size.setTo(entrySize * 100, 300L);
                }
                this.lastY = ((AddFavoritePanel)AddFavoritePanel.this).scrollBounds.y;
                this.updateEntriesPosition(widget -> false);
            }

            @Override
            public int getRowHeight() {
                return MathHelper.func_76123_f((float)((float)(this.entries.size() + this.blockedCount) / ((float)((AddFavoritePanel)AddFavoritePanel.this).scrollBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize();
            }

            @Override
            public void render(MatrixStack matrices, int x, int y, int rowWidth, int rowHeight, int mouseX, int mouseY, float delta) {
                this.lastY = y;
                int entrySize = EntryListWidget.entrySize();
                boolean fastEntryRendering = ConfigObject.getInstance().doesFastEntryRendering();
                this.updateEntriesPosition(entry -> true);
                for (SectionFavoriteWidget widget : this.widgets) {
                    widget.update(delta);
                    if (widget.getBounds().getMaxY() <= this.lastY || widget.getBounds().getY() > this.lastY + rowHeight || widget.getCurrentEntry().isEmpty()) continue;
                    widget.func_230430_a_(matrices, mouseX, mouseY, delta);
                }
            }

            public List<? extends IGuiEventListener> func_231039_at__() {
                return this.widgets;
            }

            public void updateEntriesPosition(Predicate<SectionFavoriteWidget> animated) {
                int entrySize = EntryListWidget.entrySize();
                this.blockedCount = 0;
                int width = ((AddFavoritePanel)AddFavoritePanel.this).scrollBounds.width / entrySize;
                int currentX = 0;
                int currentY = 0;
                boolean slotIndex = false;
                block0: for (SectionFavoriteWidget widget : this.widgets) {
                    while (true) {
                        int xPos = currentX * entrySize + ((AddFavoritePanel)AddFavoritePanel.this).scrollBounds.x - 1;
                        int yPos = currentY * entrySize;
                        if (++currentX >= width) {
                            currentX = 0;
                            ++currentY;
                        }
                        if (EntryListWidget.notSteppingOnExclusionZones(xPos, yPos + this.lastY + (int)((AddFavoritePanel)AddFavoritePanel.this).scroller.scrollAmount, entrySize, entrySize, AddFavoritePanel.this.scrollBounds)) {
                            widget.moveTo(animated.test(widget), xPos, yPos);
                            continue block0;
                        }
                        ++this.blockedCount;
                    }
                }
            }

            private class SectionFavoriteWidget
            extends EntryListEntryWidget {
                private Animator x;
                private Animator y;
                private Animator size;
                private FavoriteEntry entry;

                protected SectionFavoriteWidget(Point point, int entrySize, FavoriteEntry entry) {
                    super(point, entrySize);
                    this.x = new Animator();
                    this.y = new Animator();
                    this.size = new Animator();
                    this.entry = entry;
                    this.entry((EntryStack)ClientEntryStacks.of(entry.getRenderer(true)));
                    this.noBackground();
                }

                public void moveTo(boolean animated, int xPos, int yPos) {
                    if (animated) {
                        this.x.setTo(xPos, 200L);
                        this.y.setTo(yPos, 200L);
                    } else {
                        this.x.setAs(xPos);
                        this.y.setAs(yPos);
                    }
                }

                public void update(float delta) {
                    this.size.update(delta);
                    this.x.update(delta);
                    this.y.update(delta);
                    this.getBounds().width = this.getBounds().height = (int)Math.round(this.size.doubleValue() / 100.0);
                    double offsetSize = ((double)EntryListWidget.entrySize() - this.size.doubleValue() / 100.0) / 2.0;
                    this.getBounds().x = (int)Math.round(this.x.doubleValue() + offsetSize);
                    this.getBounds().y = (int)Math.round(this.y.doubleValue() + offsetSize) + SectionEntriesRow.this.lastY;
                }

                @Override
                @Nullable
                public Tooltip getCurrentTooltip(Point point) {
                    if (!AddFavoritePanel.this.scrollBounds.contains(point)) {
                        return null;
                    }
                    Tooltip tooltip = super.getCurrentTooltip(point);
                    if (tooltip != null) {
                        tooltip.getText().add((ITextComponent)ImmutableTextComponent.EMPTY);
                        tooltip.getText().add((ITextComponent)new TranslationTextComponent("tooltip.rei.drag_to_add_favorites"));
                    }
                    return tooltip;
                }
            }
        }

        private static class SectionSeparatorRow
        extends Row {
            private SectionSeparatorRow() {
            }

            @Override
            public int getRowHeight() {
                return 5;
            }

            @Override
            public void render(MatrixStack matrices, int x, int y, int rowWidth, int rowHeight, int mouseX, int mouseY, float delta) {
                this.func_238468_a_(matrices, x, y + 2, x + rowWidth, y + 3, -571806998, -571806998);
            }

            public List<? extends IGuiEventListener> func_231039_at__() {
                return Collections.emptyList();
            }
        }

        private static class SectionRow
        extends Row {
            private final ITextComponent sectionText;
            private final ITextComponent styledText;

            public SectionRow(ITextComponent sectionText, ITextComponent styledText) {
                this.sectionText = sectionText;
                this.styledText = styledText;
            }

            @Override
            public int getRowHeight() {
                return 11;
            }

            @Override
            public void render(MatrixStack matrices, int x, int y, int rowWidth, int rowHeight, int mouseX, int mouseY, float delta) {
                if (mouseX >= x && mouseY >= y && mouseX <= x + rowWidth && mouseY <= y + rowHeight) {
                    Tooltip.create(this.sectionText).queue();
                }
                Minecraft.func_71410_x().field_71466_p.func_243248_b(matrices, this.styledText, (float)x, (float)(y + 1), -1);
            }

            public List<? extends IGuiEventListener> func_231039_at__() {
                return Collections.emptyList();
            }
        }

        private static abstract class Row
        extends AbstractContainerEventHandler {
            private Row() {
            }

            public abstract int getRowHeight();

            public abstract void render(MatrixStack var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8);
        }
    }

    public static abstract class FadingFavoritePanelButton
    extends WidgetWithBounds {
        protected final FavoritesListWidget widget;
        public boolean wasClicked = false;
        public final Animator alpha = new Animator(0.0);
        public final Rectangle bounds = new Rectangle();

        public FadingFavoritePanelButton(FavoritesListWidget widget) {
            this.widget = widget;
        }

        public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
            this.bounds.setBounds(this.updateArea(this.widget.fullBounds));
            boolean hovered = this.containsMouse(mouseX, mouseY);
            this.alpha.setTo(hovered ? 1.0 : (this.isAvailable(mouseX, mouseY) ? (double)0.3f : 0.0), 260L);
            this.alpha.update(delta);
            int buttonColor = 0xFFFFFF | Math.round(52.0f * this.alpha.floatValue()) << 24;
            this.func_238468_a_(matrices, this.bounds.x, this.bounds.y, this.bounds.getMaxX(), this.bounds.getMaxY(), buttonColor, buttonColor);
            if (this.isVisible()) {
                IRenderTypeBuffer.Impl bufferSource = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                this.renderButtonText(matrices, bufferSource);
                bufferSource.func_228461_a_();
            }
            if (hovered) {
                this.queueTooltip();
            }
        }

        protected abstract boolean isAvailable(int var1, int var2);

        protected abstract void renderButtonText(MatrixStack var1, IRenderTypeBuffer.Impl var2);

        @Override
        public Rectangle getBounds() {
            return this.bounds;
        }

        public boolean isVisible() {
            return Math.round(18.0f * this.alpha.floatValue()) > 0;
        }

        protected boolean wasClicked() {
            boolean tmp = this.wasClicked;
            this.wasClicked = false;
            return tmp;
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return Collections.emptyList();
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (this.isVisible() && this.containsMouse(mouseX, mouseY)) {
                this.wasClicked = true;
            }
            return false;
        }

        public boolean func_231048_c_(double mouseX, double mouseY, int button) {
            if (this.wasClicked() && this.isVisible() && this.containsMouse(mouseX, mouseY)) {
                this.onClick();
                return true;
            }
            return false;
        }

        protected abstract void onClick();

        protected abstract void queueTooltip();

        protected abstract Rectangle updateArea(Rectangle var1);
    }

    public static class ToggleAddFavoritePanelButton
    extends FadingFavoritePanelButton {
        public ToggleAddFavoritePanelButton(FavoritesListWidget widget) {
            super(widget);
        }

        @Override
        protected void onClick() {
            this.widget.favoritePanel.expendState.setTo(this.widget.favoritePanel.expendState.target() == 1.0 ? 0.0 : 1.0, 1500L);
            this.widget.favoritePanel.resetRows();
        }

        @Override
        protected void queueTooltip() {
            Tooltip.create(new ITextComponent[]{new TranslationTextComponent("text.rei.add_favorite_widget")}).queue();
        }

        @Override
        protected Rectangle updateArea(Rectangle fullArea) {
            return new Rectangle(fullArea.x + 4, fullArea.getMaxY() - 16 - 4, 16, 16);
        }

        @Override
        protected boolean isAvailable(int mouseX, int mouseY) {
            float expendProgress = this.widget.favoritePanel.expendState.floatValue();
            return this.widget.fullBounds.contains(mouseX, mouseY) || expendProgress > 0.1f;
        }

        @Override
        protected void renderButtonText(MatrixStack matrices, IRenderTypeBuffer.Impl bufferSource) {
            int textColor;
            float expendProgress = this.widget.favoritePanel.expendState.floatValue();
            if (expendProgress < 0.9f) {
                textColor = 0xFFFFFF | Math.round(239.0f * this.alpha.floatValue() * (1.0f - expendProgress)) << 24;
                this.font.func_228079_a_("+", (float)this.bounds.getCenterX() - 2.5f, (float)(this.bounds.getCenterY() - 3), textColor, false, matrices.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)bufferSource, false, 0, 0xF000F0);
            }
            if (expendProgress > 0.1f) {
                textColor = 0xFFFFFF | Math.round(239.0f * this.alpha.floatValue() * expendProgress) << 24;
                this.font.func_228079_a_("-", (float)this.bounds.getCenterX() - 2.5f, (float)(this.bounds.getCenterY() - 3), textColor, false, matrices.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)bufferSource, false, 0, 0xF000F0);
            }
        }
    }

    private class EntryListEntry
    extends EntryListEntryWidget {
        private final Entry entry;
        private final FavoriteEntry favoriteEntry;

        private EntryListEntry(Entry entry, int x, int y, int entrySize, FavoriteEntry favoriteEntry) {
            super(new Point(x, y), entrySize);
            this.entry = entry;
            this.favoriteEntry = favoriteEntry;
            this.clearEntries().entry(ClientEntryStacks.of(this.favoriteEntry.getRenderer(false)));
        }

        @Override
        protected FavoriteEntry asFavoriteEntry() {
            return this.favoriteEntry.copy();
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return super.containsMouse(mouseX, mouseY) && FavoritesListWidget.this.currentBounds.contains(mouseX, mouseY);
        }

        @Override
        protected boolean reverseFavoritesAction() {
            return true;
        }

        @Override
        public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
            UUID uuid;
            ContainerScreenOverlay overlay;
            boolean isOpened;
            Optional<REIOverlay> overlayOptional = REIHelper.getInstance().getOverlay();
            Optional<Supplier<Collection<FavoriteMenuEntry>>> menuEntries = this.favoriteEntry.getMenuEntries();
            if (Math.abs(this.entry.x.doubleValue() - this.entry.x.target()) < 1.0 && Math.abs(this.entry.y.doubleValue() - this.entry.y.target()) < 1.0 && overlayOptional.isPresent() && menuEntries.isPresent() && ((isOpened = (overlay = (ContainerScreenOverlay)overlayOptional.get()).isMenuOpened(uuid = this.favoriteEntry.getUuid())) || !overlay.isAnyMenuOpened())) {
                boolean inBounds;
                boolean bl = inBounds = this.containsMouse(mouseX, mouseY) || overlay.isMenuInBounds(uuid);
                if (isOpened != inBounds) {
                    if (inBounds) {
                        Menu menu = new Menu(new Point(this.getBounds().x, this.getBounds().getMaxY()), CollectionUtils.map(menuEntries.get().get(), entry -> new MenuEntry((FavoriteMenuEntry)entry, overlay){
                            final /* synthetic */ FavoriteMenuEntry val$entry;
                            final /* synthetic */ ContainerScreenOverlay val$overlay;
                            {
                                this.val$entry = favoriteMenuEntry;
                                this.val$overlay = containerScreenOverlay;
                            }

                            public List<? extends IGuiEventListener> func_231039_at__() {
                                return Collections.singletonList(this.val$entry);
                            }

                            public void func_230430_a_(MatrixStack poseStack, int i, int j, float f) {
                                this.val$entry.func_230430_a_(poseStack, i, j, f);
                            }

                            @Override
                            public int getEntryWidth() {
                                return this.val$entry.getEntryWidth();
                            }

                            @Override
                            public int getEntryHeight() {
                                return this.val$entry.getEntryHeight();
                            }

                            @Override
                            public void updateInformation(int xPos, int yPos, boolean selected, boolean containsMouse, boolean rendering, int width) {
                                this.val$entry.closeMenu = this.val$overlay::closeOverlayMenu;
                                this.val$entry.updateInformation(xPos, yPos, selected, containsMouse, rendering, width);
                            }

                            @Override
                            public int getZ() {
                                return this.val$entry.getZ();
                            }

                            @Override
                            public void setZ(int z) {
                                this.val$entry.setZ(z);
                            }
                        }));
                        if (ConfigObject.getInstance().isLeftHandSidePanel()) {
                            menu.menuStartPoint.x -= menu.getBounds().width - this.getBounds().width;
                        }
                        overlay.openMenu(uuid, menu, this::containsMouse, point -> FavoritesListWidget.this.entries.containsKey(this.entry.hashIgnoreAmount()) && !FavoritesListWidget.this.removedEntries.containsKey(this.entry.hashIgnoreAmount()));
                    } else {
                        overlay.closeOverlayMenu();
                    }
                }
            }
            Vector4f vector4f = new Vector4f((float)mouseX, (float)mouseY, 0.0f, 1.0f);
            vector4f.func_229372_a_(matrices.func_227866_c_().func_227870_a_());
            super.func_230430_a_(matrices, (int)vector4f.func_195910_a(), (int)vector4f.func_195913_b(), delta);
        }

        @Override
        protected boolean doAction(double mouseX, double mouseY, int button) {
            return this.favoriteEntry.doAction(button);
        }
    }

    public class Entry {
        private FavoriteEntry entry;
        private final EntryListEntry widget;
        private boolean hidden;
        private Point startedDraggingPosition;
        private Animator x = new Animator();
        private Animator y = new Animator();
        private Animator size = new Animator();

        public Entry(FavoriteEntry entry, int entrySize) {
            this.entry = entry;
            this.widget = (EntryListEntry)new EntryListEntry(this, 0, 0, entrySize, entry).noBackground();
        }

        public void remove() {
            if (!this.hidden) {
                this.hidden = true;
                if (!ConfigObject.getInstance().isFavoritesAnimated()) {
                    this.size.setAs(0.0);
                } else {
                    this.size.setTo(0.0, 400L);
                }
            }
        }

        public void update(double delta) {
            this.size.update(delta);
            this.x.update(delta);
            this.y.update(delta);
            this.getWidget().getBounds().width = this.getWidget().getBounds().height = (int)Math.round(this.size.doubleValue() / 100.0);
            double offsetSize = ((double)EntryListWidget.entrySize() - this.size.doubleValue() / 100.0) / 2.0;
            this.getWidget().getBounds().x = (int)Math.round(this.x.doubleValue() + offsetSize);
            this.getWidget().getBounds().y = (int)Math.round(this.y.doubleValue() + offsetSize) - (int)FavoritesListWidget.this.scrolling.scrollAmount;
        }

        public EntryListEntry getWidget() {
            return this.widget;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public int hashIgnoreAmount() {
            return this.entry.hashCode();
        }

        public FavoriteEntry getEntry() {
            return this.entry;
        }

        public void moveTo(boolean animated, int xPos, int yPos) {
            if (animated && ConfigObject.getInstance().isFavoritesAnimated()) {
                this.x.setTo(xPos, 200L);
                this.y.setTo(yPos, 200L);
            } else {
                this.x.setAs(xPos);
                this.y.setAs(yPos);
            }
        }
    }

    public class FavoriteDraggableStack
    implements DraggableStack {
        private Entry entry;
        private FavoriteEntry favoriteEntry;
        private EntryStack<?> stack;
        private boolean showcase;

        public FavoriteDraggableStack(Entry entry, boolean showcase) {
            this.entry = entry;
            this.favoriteEntry = entry.getEntry();
            this.stack = ClientEntryStacks.of(this.favoriteEntry.getRenderer(false));
            this.showcase = showcase;
        }

        @Override
        public EntryStack<?> getStack() {
            return this.stack;
        }

        @Override
        public void drag() {
            if (!this.showcase) {
                FavoritesListWidget.this.entries.remove(this.entry.hashIgnoreAmount());
                FavoritesListWidget.this.applyNewFavorites(CollectionUtils.map(FavoritesListWidget.this.entries.values(), Entry::getEntry));
            }
        }

        @Override
        public void release(boolean accepted) {
            if (!accepted) {
                FavoritesListWidget.this.drop(this.entry, this, this.favoriteEntry);
            }
        }
    }
}

