/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIHelper;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.DrawableConsumer;
import me.shedaniel.rei.api.client.gui.widgets.Arrow;
import me.shedaniel.rei.api.client.gui.widgets.BurningFire;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.DelegateWidget;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.TransferDisplayCategory;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.ClientInternals;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.gui.toast.CopyRecipeIdentifierToast;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.LateRenderable;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.ArrowWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.BurningFireWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.ButtonWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.DrawableWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.FillRectangleDrawableConsumer;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.LabelWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.PanelWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.TexturedDrawableConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public final class InternalWidgets {
    private InternalWidgets() {
    }

    public static Widget createAutoCraftingButtonWidget(Rectangle displayBounds, Rectangle rectangle, ITextComponent text, final Supplier<Display> displaySupplier, List<Widget> setupDisplay, DisplayCategory<?> category) {
        ContainerScreen<?> containerScreen = REIHelper.getInstance().getPreviousContainerScreen();
        boolean[] visible = new boolean[]{false};
        List[] errorTooltip = new List[]{null};
        Button autoCraftingButton = Widgets.createButton(rectangle, text).focusable(false).onClick(button -> {
            TransferHandler.Context context = TransferHandler.Context.create(true, containerScreen, (Display)displaySupplier.get());
            for (TransferHandler autoTransferHandler : TransferHandlerRegistry.getInstance()) {
                try {
                    TransferHandler.Result result = autoTransferHandler.handle(context);
                    if (!result.isBlocking()) continue;
                    if (!result.isReturningToScreen()) {
                        return;
                    }
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Minecraft.func_71410_x().func_147108_a((Screen)containerScreen);
            REIHelper.getInstance().getOverlay().get().queueReloadOverlay();
        }).onRender((matrices, button) -> {
            button.setEnabled(false);
            if (containerScreen == null) {
                button.setTint(0);
                return;
            }
            ArrayList error = null;
            int color = 0;
            visible[0] = false;
            IntList redSlots = null;
            TransferHandler.Context context = TransferHandler.Context.create(false, containerScreen, (Display)displaySupplier.get());
            for (TransferHandler transferHandler : TransferHandlerRegistry.getInstance()) {
                try {
                    TransferHandler.Result result = transferHandler.handle(context);
                    if (result.isApplicable()) {
                        visible[0] = true;
                    }
                    if (result.isSuccessful()) {
                        button.setEnabled(true);
                        error = null;
                        color = 0;
                        redSlots = null;
                    } else if (result.isApplicable()) {
                        if (error == null) {
                            error = Lists.newArrayList();
                        }
                        error.add(result.getError());
                        color = result.getColor();
                        if (result.getIntegers() != null && !result.getIntegers().isEmpty()) {
                            redSlots = result.getIntegers();
                        }
                    }
                    if (!result.isBlocking()) continue;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!visible[0]) {
                button.setEnabled(false);
                if (error == null) {
                    error = Lists.newArrayList();
                } else {
                    error.clear();
                }
                error.add(new TranslationTextComponent("error.rei.no.handlers.applicable"));
            }
            if ((button.containsMouse(PointHelper.ofMouse()) || button.isFocused()) && category instanceof TransferDisplayCategory && redSlots != null) {
                ((TransferDisplayCategory)category).renderRedSlots((MatrixStack)matrices, setupDisplay, displayBounds, (Display)displaySupplier.get(), redSlots);
            }
            List list = errorTooltip[0] = error == null || error.isEmpty() ? null : Lists.newArrayList();
            if (errorTooltip[0] != null) {
                for (ITextComponent s : error) {
                    if (CollectionUtils.anyMatch(errorTooltip[0], ss -> ss.getString().equalsIgnoreCase(s.getString()))) continue;
                    errorTooltip[0].add(s);
                }
            }
            button.setTint(color);
        }).textColor((button, mouse) -> {
            if (!visible[0]) {
                return 0xA0A0A0;
            }
            if (button.isEnabled() && (button.containsMouse((Point)mouse) || button.isFocused())) {
                return 0xFFFFA0;
            }
            return 0xE0E0E0;
        }).textureId((button, mouse) -> !visible[0] ? 0 : ((button.containsMouse((Point)mouse) || button.isFocused()) && button.isEnabled() ? 4 : 1)).tooltipSupplier(button -> {
            ArrayList<Object> str = new ArrayList<Object>();
            if (errorTooltip[0] == null) {
                if (((Boolean)ClientHelperImpl.getInstance().isYog.func_179281_c()).booleanValue()) {
                    str.add(new TranslationTextComponent("text.auto_craft.move_items.yog"));
                } else {
                    str.add(new TranslationTextComponent("text.auto_craft.move_items"));
                }
            } else if (errorTooltip[0].size() > 1) {
                str.add(new TranslationTextComponent("error.rei.multi.errors").func_240699_a_(TextFormatting.RED));
                for (ITextComponent component : errorTooltip[0]) {
                    str.add(new TranslationTextComponent("- ").func_240699_a_(TextFormatting.RED).func_230529_a_((ITextComponent)component.func_230532_e_().func_240699_a_(TextFormatting.RED)));
                }
            } else if (errorTooltip[0].size() == 1) {
                str.add(((ITextComponent)errorTooltip[0].get(0)).func_230532_e_().func_240699_a_(TextFormatting.RED));
            }
            if (Minecraft.func_71410_x().field_71474_y.field_82882_x && ((Display)displaySupplier.get()).getDisplayLocation().isPresent()) {
                str.add(new TranslationTextComponent("text.rei.recipe_id", new Object[]{new StringTextComponent(((Display)displaySupplier.get()).getDisplayLocation().get().toString()).func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.GRAY));
            }
            return str.toArray(new ITextComponent[0]);
        });
        return new DelegateWidget(autoCraftingButton){

            public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
                if (((Display)displaySupplier.get()).getDisplayLocation().isPresent() && ConfigObject.getInstance().getCopyRecipeIdentifierKeybind().matchesKey(keyCode, scanCode) && this.containsMouse(PointHelper.ofMouse())) {
                    this.minecraft.field_195559_v.func_197960_a(((Display)displaySupplier.get()).getDisplayLocation().get().toString());
                    if (ConfigObject.getInstance().isToastDisplayedOnCopyIdentifier()) {
                        CopyRecipeIdentifierToast.addToast(I18n.func_135052_a((String)"msg.rei.copied_recipe_id", (Object[])new Object[0]), I18n.func_135052_a((String)"msg.rei.recipe_id_details", (Object[])new Object[]{((Display)displaySupplier.get()).getDisplayLocation().get().toString()}));
                    }
                    return true;
                }
                return super.func_231046_a_(keyCode, scanCode, modifiers);
            }

            public boolean func_231044_a_(double mouseX, double mouseY, int button) {
                if (((Display)displaySupplier.get()).getDisplayLocation().isPresent() && ConfigObject.getInstance().getCopyRecipeIdentifierKeybind().matchesMouse(button) && this.containsMouse(PointHelper.ofMouse())) {
                    this.minecraft.field_195559_v.func_197960_a(((Display)displaySupplier.get()).getDisplayLocation().get().toString());
                    if (ConfigObject.getInstance().isToastDisplayedOnCopyIdentifier()) {
                        CopyRecipeIdentifierToast.addToast(I18n.func_135052_a((String)"msg.rei.copied_recipe_id", (Object[])new Object[0]), I18n.func_135052_a((String)"msg.rei.recipe_id_details", (Object[])new Object[]{((Display)displaySupplier.get()).getDisplayLocation().get().toString()}));
                    }
                    return true;
                }
                return super.func_231044_a_(mouseX, mouseY, button);
            }
        };
    }

    public static WidgetWithBounds wrapLateRenderable(Widget widget) {
        return new LateRenderableWidget(widget);
    }

    public static Widget concatWidgets(Widget widget1, Widget widget2) {
        return new MergedWidget(widget2, widget1);
    }

    public static void attach() {
        ClientInternals.attachInstance(new WidgetsProvider(), ClientInternals.WidgetsProvider.class);
    }

    private static class WidgetsProvider
    implements ClientInternals.WidgetsProvider {
        private WidgetsProvider() {
        }

        @Override
        public boolean isRenderingPanel(Panel panel) {
            return PanelWidget.isRendering(panel);
        }

        @Override
        public Widget createDrawableWidget(DrawableConsumer drawable) {
            return new DrawableWidget(drawable);
        }

        @Override
        public Slot createSlot(Point point) {
            return new EntryWidget(point);
        }

        @Override
        public Slot createSlot(Rectangle bounds) {
            return new EntryWidget(bounds);
        }

        @Override
        public Button createButton(Rectangle bounds, ITextComponent text) {
            return new ButtonWidget(bounds, text);
        }

        @Override
        public Panel createPanelWidget(Rectangle bounds) {
            return new PanelWidget(bounds);
        }

        @Override
        public Label createLabel(Point point, ITextProperties text) {
            return new LabelWidget(point, text);
        }

        @Override
        public Arrow createArrow(Rectangle rectangle) {
            return new ArrowWidget(rectangle);
        }

        @Override
        public BurningFire createBurningFire(Rectangle rectangle) {
            return new BurningFireWidget(rectangle);
        }

        @Override
        public DrawableConsumer createTexturedConsumer(ResourceLocation texture, int x, int y, int width, int height, float u, float v, int uWidth, int vHeight, int textureWidth, int textureHeight) {
            return new TexturedDrawableConsumer(texture, x, y, width, height, u, v, uWidth, vHeight, textureWidth, textureHeight);
        }

        @Override
        public DrawableConsumer createFillRectangleConsumer(Rectangle rectangle, int color) {
            return new FillRectangleDrawableConsumer(rectangle, color);
        }
    }

    private static class LateRenderableWidget
    extends DelegateWidget
    implements LateRenderable {
        private LateRenderableWidget(Widget widget) {
            super(widget);
        }
    }

    private static class MergedWidget
    extends Widget {
        private final List<Widget> widgets;

        public MergedWidget(Widget widget1, Widget widget2) {
            this.widgets = Lists.newArrayList((Object[])new Widget[]{Objects.requireNonNull(widget1), Objects.requireNonNull(widget2)});
        }

        public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
            for (Widget widget : this.widgets) {
                widget.setZ(this.getZ());
                widget.func_230430_a_(matrices, mouseX, mouseY, delta);
            }
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return this.widgets;
        }

        public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
            for (Widget widget : this.widgets) {
                if (!widget.func_231043_a_(mouseX, mouseY, amount)) continue;
                return true;
            }
            return false;
        }
    }
}

