/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.utils.Env;
import me.shedaniel.math.Point;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class QueuedTooltip
implements Tooltip {
    private Point location;
    private List<ITextComponent> text;

    private QueuedTooltip(Point location, Collection<ITextComponent> text) {
        this.location = location;
        if (this.location == null && Platform.getEnvironment() == Env.CLIENT) {
            this.setLocationToMouse();
        }
        this.text = Lists.newArrayList(text);
    }

    private void setLocationToMouse() {
        this.location = PointHelper.ofMouse();
    }

    public static QueuedTooltip create(Point location, List<ITextComponent> text) {
        return new QueuedTooltip(location, text);
    }

    public static QueuedTooltip create(Point location, Collection<ITextComponent> text) {
        return new QueuedTooltip(location, text);
    }

    public static QueuedTooltip create(Point location, ITextComponent ... text) {
        return QueuedTooltip.create(location, Arrays.asList(text));
    }

    public static QueuedTooltip create(List<ITextComponent> text) {
        return QueuedTooltip.create(null, text);
    }

    public static QueuedTooltip create(Collection<ITextComponent> text) {
        return QueuedTooltip.create(null, text);
    }

    public static QueuedTooltip create(ITextComponent ... text) {
        return QueuedTooltip.create(null, text);
    }

    @Override
    public int getX() {
        return this.location.x;
    }

    @Override
    public int getY() {
        return this.location.y;
    }

    @Override
    public List<ITextComponent> getText() {
        return this.text;
    }

    @Override
    public void queue() {
        Tooltip.super.queue();
    }
}

