/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.basewidgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.api.LazyResettable;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIHelper;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.impl.client.gui.text.TextTransformations;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import org.jetbrains.annotations.Nullable;

public final class LabelWidget
extends Label {
    private boolean focused = false;
    private boolean clickable = false;
    private int horizontalAlignment = 0;
    private boolean hasShadow = true;
    private boolean focusable = true;
    private int color = REIHelper.getInstance().isDarkThemeEnabled() ? -4473925 : -1;
    private int hoveredColor = REIHelper.getInstance().isDarkThemeEnabled() ? -1 : -10027060;
    private Point point;
    @Nullable
    private @Nullable Function<Label, @Nullable String> tooltip;
    @Nullable
    private Consumer<Label> onClick;
    @Nullable
    private BiConsumer<MatrixStack, Label> onRender;
    private ITextProperties text;
    private boolean rainbow;
    private final LazyResettable<IReorderingProcessor> orderedText = new LazyResettable(() -> LanguageMap.func_74808_a().func_241870_a(this.getMessage()));

    public LabelWidget(Point point, ITextProperties text) {
        this.point = point;
        Objects.requireNonNull(this.point);
        this.text = text;
        Objects.requireNonNull(this.text);
    }

    @Override
    public final boolean isClickable() {
        return this.clickable;
    }

    @Override
    public final void setClickable(boolean clickable) {
        this.clickable = clickable;
    }

    @Override
    @Nullable
    public final Consumer<Label> getOnClick() {
        return this.onClick;
    }

    @Override
    public final void setOnClick(@Nullable Consumer<Label> onClick) {
        this.onClick = onClick;
    }

    @Override
    @Nullable
    public final BiConsumer<MatrixStack, Label> getOnRender() {
        return this.onRender;
    }

    @Override
    public final void setOnRender(@Nullable BiConsumer<MatrixStack, Label> onRender) {
        this.onRender = onRender;
    }

    @Override
    public final boolean isFocusable() {
        return this.focusable;
    }

    @Override
    public final void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }

    @Override
    @Nullable
    public final String getTooltip() {
        if (this.tooltip == null) {
            return null;
        }
        return this.tooltip.apply(this);
    }

    @Override
    public final void setTooltip(@Nullable @Nullable Function<Label, @Nullable String> tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public final int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @Override
    public final void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    @Override
    public final boolean hasShadow() {
        return this.hasShadow;
    }

    @Override
    public final void setShadow(boolean hasShadow) {
        this.hasShadow = hasShadow;
    }

    @Override
    public final int getColor() {
        return this.color;
    }

    @Override
    public final void setColor(int color) {
        this.color = color;
    }

    @Override
    public final int getHoveredColor() {
        return this.hoveredColor;
    }

    @Override
    public final void setHoveredColor(int hoveredColor) {
        this.hoveredColor = hoveredColor;
    }

    @Override
    public final Point getPoint() {
        return this.point;
    }

    @Override
    public final void setPoint(Point point) {
        this.point = Objects.requireNonNull(point);
    }

    @Override
    public ITextProperties getMessage() {
        return this.text;
    }

    @Override
    public void setMessage(ITextProperties message) {
        this.text = Objects.requireNonNull(message);
        this.orderedText.reset();
    }

    @Override
    public void setRainbow(boolean rainbow) {
        this.rainbow = rainbow;
    }

    @Override
    public final Rectangle getBounds() {
        int width = this.font.func_238414_a_(this.text);
        Point point = this.getPoint();
        if (this.getHorizontalAlignment() == -1) {
            return new Rectangle(point.x - 1, point.y - 5, width + 2, 14);
        }
        if (this.getHorizontalAlignment() == 1) {
            return new Rectangle(point.x - width - 1, point.y - 5, width + 2, 14);
        }
        return new Rectangle(point.x - width / 2 - 1, point.y - 5, width + 2, 14);
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        String tooltip;
        if (this.getOnRender() != null) {
            this.getOnRender().accept(matrices, this);
        }
        int color = this.getColor();
        if (this.isClickable() && this.isHovered(mouseX, mouseY)) {
            color = this.getHoveredColor();
        }
        Point pos = this.getPoint();
        IReorderingProcessor sequence = (IReorderingProcessor)this.orderedText.get();
        if (this.rainbow) {
            sequence = TextTransformations.applyRainbow(sequence, pos.x, pos.y);
        }
        int width = this.font.func_243245_a(sequence);
        switch (this.getHorizontalAlignment()) {
            case -1: {
                if (this.hasShadow()) {
                    this.font.func_238407_a_(matrices, sequence, (float)pos.x, (float)pos.y, color);
                    break;
                }
                this.font.func_238422_b_(matrices, sequence, (float)pos.x, (float)pos.y, color);
                break;
            }
            case 1: {
                if (this.hasShadow()) {
                    this.font.func_238407_a_(matrices, sequence, (float)(pos.x - width), (float)pos.y, color);
                    break;
                }
                this.font.func_238422_b_(matrices, sequence, (float)(pos.x - width), (float)pos.y, color);
                break;
            }
            default: {
                if (this.hasShadow()) {
                    this.font.func_238407_a_(matrices, sequence, (float)pos.x - (float)width / 2.0f, (float)pos.y, color);
                    break;
                }
                this.font.func_238422_b_(matrices, sequence, (float)pos.x - (float)width / 2.0f, (float)pos.y, color);
            }
        }
        if (this.isHovered(mouseX, mouseY) && (tooltip = this.getTooltip()) != null) {
            if (!this.focused && this.containsMouse(mouseX, mouseY)) {
                Tooltip.create(Stream.of(tooltip.split("\n")).map(StringTextComponent::new).collect(Collectors.toList())).queue();
            } else if (this.focused) {
                Tooltip.create(this.point, Stream.of(tooltip.split("\n")).map(StringTextComponent::new).collect(Collectors.toList())).queue();
            }
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isClickable() && this.containsMouse(mouseX, mouseY)) {
            Widgets.produceClickSound();
            if (this.onClick != null) {
                this.onClick.accept(this);
            }
            return true;
        }
        return false;
    }

    public boolean func_231046_a_(int int_1, int int_2, int int_3) {
        if (!(this.isClickable() && this.isFocusable() && this.focused)) {
            return false;
        }
        if (int_1 != 257 && int_1 != 32 && int_1 != 335) {
            return false;
        }
        Widgets.produceClickSound();
        if (this.onClick != null) {
            this.onClick.accept(this);
        }
        return true;
    }

    public boolean func_231049_c__(boolean boolean_1) {
        if (!this.isClickable() || !this.isFocusable()) {
            return false;
        }
        this.focused = !this.focused;
        return true;
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return this.containsMouse(mouseX, mouseY) || this.focused;
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return Collections.emptyList();
    }
}

