/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.search;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Consumer;
import me.shedaniel.math.Color;
import me.shedaniel.math.Point;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIHelper;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.SyntaxHighlightingMode;
import me.shedaniel.rei.impl.client.gui.ContainerScreenOverlay;
import me.shedaniel.rei.impl.client.gui.text.TextTransformations;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.TextFieldWidget;
import me.shedaniel.rei.impl.client.gui.widget.search.OverlaySearchFieldSyntaxHighlighter;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentType;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentTypesRegistry;
import me.shedaniel.rei.impl.client.search.argument.type.TextArgumentType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class OverlaySearchField
extends TextFieldWidget
implements TextFieldWidget.TextFormatter {
    public static boolean isHighlighting = false;
    private static final Style SPLITTER_STYLE = Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY);
    private static final Style QUOTES_STYLE = Style.field_240709_b_.func_240712_a_(TextFormatting.GOLD);
    private static final Style ERROR_STYLE = Style.field_240709_b_.func_240718_a_(net.minecraft.util.text.Color.func_240743_a_((int)0xFF5555));
    private final OverlaySearchFieldSyntaxHighlighter highlighter = new OverlaySearchFieldSyntaxHighlighter(this);
    public long keybindFocusTime = -1L;
    public int keybindFocusKey = -1;
    public boolean isMain = true;
    protected Tuple<Long, Point> lastClickedDetails = null;
    private List<String> history = Lists.newArrayListWithCapacity((int)100);

    public OverlaySearchField(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setMaxLength(10000);
        this.setFormatter(this);
        super.setResponder(this.highlighter);
    }

    @Override
    public IReorderingProcessor format(TextFieldWidget widget, String text, int index) {
        boolean isPlain = ConfigObject.getInstance().getSyntaxHighlightingMode() == SyntaxHighlightingMode.PLAIN || ConfigObject.getInstance().getSyntaxHighlightingMode() == SyntaxHighlightingMode.PLAIN_UNDERSCORED;
        boolean hasUnderscore = ConfigObject.getInstance().getSyntaxHighlightingMode() == SyntaxHighlightingMode.PLAIN_UNDERSCORED || ConfigObject.getInstance().getSyntaxHighlightingMode() == SyntaxHighlightingMode.COLORFUL_UNDERSCORED;
        return TextTransformations.forwardWithTransformation(text, (s, charIndex, c) -> {
            byte arg = this.highlighter.highlighted[charIndex + index];
            Style style = Style.field_240709_b_;
            if (this.isMain && ContainerScreenOverlay.getEntryListWidget().getAllStacks().isEmpty() && !this.getText().isEmpty()) {
                style = ERROR_STYLE;
            }
            if (arg > 0) {
                ArgumentType<?, ?> argumentType = ArgumentTypesRegistry.ARGUMENT_TYPE_LIST.get((arg - 1) / 2);
                if (!isPlain) {
                    style = argumentType.getHighlightedStyle();
                }
                if (!(argumentType instanceof TextArgumentType) && hasUnderscore && arg % 2 == 1) {
                    style = style.func_244282_c(Boolean.valueOf(true));
                }
            } else if (!isPlain) {
                if (arg == -1) {
                    style = SPLITTER_STYLE;
                } else if (arg == -2) {
                    style = QUOTES_STYLE;
                }
            }
            if (this.containsMouse(PointHelper.ofMouse()) || this.isFocused()) {
                return style;
            }
            return style.func_240718_a_(net.minecraft.util.text.Color.func_240743_a_((int)Color.ofOpaque((int)(style.func_240711_a_() == null ? -1 : style.func_240711_a_().func_240742_a_())).brighter(0.75).getColor()));
        });
    }

    @Override
    public void setResponder(Consumer<String> responder) {
        super.setResponder(this.highlighter.andThen(responder));
    }

    @Override
    public void setFocused(boolean boolean_1) {
        if (this.isFocused() != boolean_1 && this.isMain) {
            this.addToHistory(this.getText());
        }
        super.setFocused(boolean_1);
    }

    @ApiStatus.Internal
    public void addToHistory(String text) {
        if (!text.isEmpty()) {
            this.history.removeIf(str -> str.equalsIgnoreCase(text));
            if (this.history.size() > 100) {
                this.history.remove(0);
            }
            this.history.add(text);
        }
    }

    public void laterRender(MatrixStack matrices, int int_1, int int_2, float float_1) {
        RenderSystem.disableDepthTest();
        this.setSuggestion(!this.isFocused() && this.getText().isEmpty() ? I18n.func_135052_a((String)"text.rei.search.field.suggestion", (Object[])new Object[0]) : null);
        super.func_230430_a_(matrices, int_1, int_2, float_1);
        RenderSystem.enableDepthTest();
    }

    @Override
    protected void renderSuggestion(MatrixStack matrices, int x, int y) {
        matrices.func_227860_a_();
        matrices.func_227861_a_(0.0, 0.0, 400.0);
        int color = this.containsMouse(PointHelper.ofMouse()) || this.isFocused() ? -571806998 : -6250336;
        this.font.func_238405_a_(matrices, this.font.func_238412_a_(this.getSuggestion(), this.getWidth()), (float)x, (float)y, color);
        matrices.func_227865_b_();
    }

    @Override
    public void renderBorder(MatrixStack matrices) {
        boolean bl = isHighlighting = isHighlighting && ConfigObject.getInstance().isInventoryHighlightingAllowed();
        if (this.isMain && isHighlighting) {
            OverlaySearchField.func_238467_a_((MatrixStack)matrices, (int)(this.getBounds().x - 1), (int)(this.getBounds().y - 1), (int)(this.getBounds().x + this.getBounds().width + 1), (int)(this.getBounds().y + this.getBounds().height + 1), (int)-852212);
        } else if (this.isMain && ContainerScreenOverlay.getEntryListWidget().getAllStacks().isEmpty() && !this.getText().isEmpty()) {
            OverlaySearchField.func_238467_a_((MatrixStack)matrices, (int)(this.getBounds().x - 1), (int)(this.getBounds().y - 1), (int)(this.getBounds().x + this.getBounds().width + 1), (int)(this.getBounds().y + this.getBounds().height + 1), (int)-43691);
        } else {
            super.renderBorder(matrices);
            return;
        }
        OverlaySearchField.func_238467_a_((MatrixStack)matrices, (int)this.getBounds().x, (int)this.getBounds().y, (int)(this.getBounds().x + this.getBounds().width), (int)(this.getBounds().y + this.getBounds().height), (int)-16777216);
    }

    public int getManhattanDistance(Point point1, Point point2) {
        int e = Math.abs(point1.getX() - point2.getX());
        int f = Math.abs(point1.getY() - point2.getY());
        return e + f;
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        boolean contains = this.containsMouse(mouseX, mouseY);
        if (this.isVisible() && contains && button == 1) {
            this.setText("");
        }
        if (contains && button == 0 && this.isMain && ConfigObject.getInstance().isInventoryHighlightingAllowed()) {
            if (this.lastClickedDetails == null) {
                this.lastClickedDetails = new Tuple((Object)System.currentTimeMillis(), (Object)new Point(mouseX, mouseY));
            } else if (System.currentTimeMillis() - (Long)this.lastClickedDetails.func_76341_a() > 1500L) {
                this.lastClickedDetails = null;
            } else if (this.getManhattanDistance((Point)this.lastClickedDetails.func_76340_b(), new Point(mouseX, mouseY)) <= 25) {
                this.lastClickedDetails = null;
                isHighlighting = !isHighlighting;
                this.minecraft.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            } else {
                this.lastClickedDetails = new Tuple((Object)System.currentTimeMillis(), (Object)new Point(mouseX, mouseY));
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    @Override
    public boolean func_231046_a_(int int_1, int int_2, int int_3) {
        if (this.isVisible() && this.isFocused() && this.isMain) {
            int i;
            if (int_1 == 257 || int_1 == 335) {
                this.addToHistory(this.getText());
                this.setFocused(false);
                return true;
            }
            if (int_1 == 265) {
                int i2 = this.history.indexOf(this.getText()) - 1;
                if (i2 < -1 && this.getText().isEmpty()) {
                    i2 = this.history.size() - 1;
                } else if (i2 < -1) {
                    this.addToHistory(this.getText());
                    i2 = this.history.size() - 2;
                }
                if (i2 >= 0) {
                    this.setText(this.history.get(i2));
                    return true;
                }
            } else if (int_1 == 264 && (i = this.history.indexOf(this.getText()) + 1) > 0) {
                this.setText(i < this.history.size() ? this.history.get(i) : "");
                return true;
            }
        }
        return super.func_231046_a_(int_1, int_2, int_3);
    }

    @Override
    public boolean func_231042_a_(char char_1, int int_1) {
        if (System.currentTimeMillis() - this.keybindFocusTime < 1000L && InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)this.keybindFocusKey)) {
            this.keybindFocusTime = -1L;
            this.keybindFocusKey = -1;
            return true;
        }
        return super.func_231042_a_(char_1, int_1);
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        return (!this.isMain || REIHelper.getInstance().getOverlay().get().isNotInExclusionZones(mouseX, mouseY)) && super.containsMouse(mouseX, mouseY);
    }

    @Override
    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
    }
}

