/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.registry.category;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.ButtonArea;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class CategoryRegistryImpl
implements CategoryRegistry {
    private final Map<CategoryIdentifier<?>, Configuration<?>> categories = new LinkedHashMap();
    private final Map<CategoryIdentifier<?>, List<Consumer<CategoryRegistry.CategoryConfiguration<?>>>> listeners = new HashMap();

    @Override
    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerCategories(this);
    }

    @Override
    public void startReload() {
        this.categories.clear();
    }

    @Override
    public void endReload() {
        ArrayList notRegisteredSerializers = new ArrayList();
        for (CategoryIdentifier<?> identifier : this.categories.keySet()) {
            if (DisplaySerializerRegistry.getInstance().hasRegistered(identifier)) continue;
            notRegisteredSerializers.add(identifier);
        }
        if (!notRegisteredSerializers.isEmpty()) {
            throw new IllegalStateException(notRegisteredSerializers.size() + " categories did not register their serializers! " + CollectionUtils.mapAndJoinToString(notRegisteredSerializers, Object::toString, (CharSequence)", "));
        }
    }

    @Override
    public <T extends Display> void add(DisplayCategory<T> category, Consumer<CategoryRegistry.CategoryConfiguration<T>> configurator) {
        Configuration<T> configuration = new Configuration<T>(category);
        this.categories.put(category.getCategoryIdentifier(), configuration);
        configurator.accept(configuration);
        List<Consumer<CategoryRegistry.CategoryConfiguration<?>>> listeners = this.listeners.get(category.getCategoryIdentifier());
        if (listeners != null) {
            this.listeners.remove(category.getCategoryIdentifier());
            for (Consumer<CategoryRegistry.CategoryConfiguration<?>> listener : listeners) {
                listener.accept(configuration);
            }
        }
    }

    @Override
    public <T extends Display> CategoryRegistry.CategoryConfiguration<T> get(CategoryIdentifier<T> category) {
        return Objects.requireNonNull(this.categories.get(category), category.toString());
    }

    @Override
    public <T extends Display> void configure(CategoryIdentifier<T> category, Consumer<CategoryRegistry.CategoryConfiguration<T>> action) {
        if (this.categories.containsKey(category)) {
            action.accept(this.get(category));
        } else {
            this.listeners.computeIfAbsent(category, location -> new ArrayList()).add(action);
        }
    }

    @Override
    public Iterator<CategoryRegistry.CategoryConfiguration<?>> iterator() {
        return this.categories.values().iterator();
    }

    @Override
    public int size() {
        return this.categories.size();
    }

    private static class Configuration<T extends Display>
    implements CategoryRegistry.CategoryConfiguration<T> {
        private final DisplayCategory<T> category;
        private final List<EntryIngredient> workstations = Collections.synchronizedList(new ArrayList());
        private Optional<ButtonArea> plusButtonArea = Optional.of(ButtonArea.defaultArea());

        public Configuration(DisplayCategory<T> category) {
            this.category = category;
        }

        @Override
        public void addWorkstations(EntryIngredient ... stations) {
            this.workstations.addAll(Arrays.asList(stations));
        }

        @Override
        public void setPlusButtonArea(ButtonArea area) {
            this.plusButtonArea = Optional.ofNullable(area);
        }

        @Override
        public Optional<ButtonArea> getPlusButtonArea() {
            return this.plusButtonArea;
        }

        @Override
        public List<EntryIngredient> getWorkstations() {
            return Collections.unmodifiableList(this.workstations);
        }

        @Override
        public DisplayCategory<T> getCategory() {
            return this.category;
        }

        @Override
        public CategoryIdentifier<?> getCategoryIdentifier() {
            return this.category.getCategoryIdentifier();
        }
    }
}

