/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.registry.display;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.LiveDisplayGenerator;
import me.shedaniel.rei.api.client.registry.display.visibility.DisplayVisibilityPredicate;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.impl.common.registry.RecipeManagerContextImpl;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ActionResultType;
import org.apache.commons.lang3.mutable.MutableInt;

public class DisplayRegistryImpl
extends RecipeManagerContextImpl<REIClientPlugin>
implements DisplayRegistry {
    private final Map<CategoryIdentifier<?>, List<Display>> displays = new ConcurrentHashMap();
    private final Map<CategoryIdentifier<?>, List<LiveDisplayGenerator<?>>> displayGenerators = new ConcurrentHashMap();
    private final List<LiveDisplayGenerator<?>> globalDisplayGenerators = new ArrayList();
    private final List<DisplayVisibilityPredicate> visibilityPredicates = new ArrayList<DisplayVisibilityPredicate>();
    private final List<DisplayFiller<?, ?>> fillers = new ArrayList();
    private final MutableInt displayCount = new MutableInt(0);

    public DisplayRegistryImpl() {
        super(RecipeManagerContextImpl.supplier());
    }

    @Override
    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerDisplays(this);
    }

    @Override
    public int displaySize() {
        return this.displayCount.getValue();
    }

    @Override
    public void add(Display display) {
        this.displays.computeIfAbsent(display.getCategoryIdentifier(), location -> new ArrayList()).add(display);
        this.displayCount.increment();
    }

    public void registerDisplay(int index, Display display) {
        this.displays.computeIfAbsent(display.getCategoryIdentifier(), location -> new ArrayList()).add(index, display);
        this.displayCount.increment();
    }

    @Override
    public Map<CategoryIdentifier<?>, List<Display>> getAll() {
        return Collections.unmodifiableMap(this.displays);
    }

    @Override
    public <A extends Display> void registerGlobalDisplayGenerator(LiveDisplayGenerator<A> generator) {
        this.globalDisplayGenerators.add(generator);
    }

    @Override
    public <A extends Display> void registerDisplayGenerator(CategoryIdentifier<A> categoryId, LiveDisplayGenerator<A> generator) {
        this.displayGenerators.computeIfAbsent(categoryId, location -> new ArrayList()).add(generator);
    }

    @Override
    public Map<CategoryIdentifier<?>, List<LiveDisplayGenerator<?>>> getCategoryDisplayGenerators() {
        return Collections.unmodifiableMap(this.displayGenerators);
    }

    @Override
    public List<LiveDisplayGenerator<?>> getGlobalDisplayGenerators() {
        return Collections.unmodifiableList(this.globalDisplayGenerators);
    }

    @Override
    public void registerVisibilityPredicate(DisplayVisibilityPredicate predicate) {
        this.visibilityPredicates.add(predicate);
        this.visibilityPredicates.sort(Comparator.reverseOrder());
    }

    @Override
    public boolean isDisplayVisible(Display display) {
        DisplayCategory<?> category = CategoryRegistry.getInstance().get(display.getCategoryIdentifier()).getCategory();
        for (DisplayVisibilityPredicate predicate : this.visibilityPredicates) {
            try {
                ActionResultType result = predicate.handleDisplay(category, display);
                if (result == ActionResultType.PASS) continue;
                return result == ActionResultType.SUCCESS;
            }
            catch (Throwable throwable) {
                RoughlyEnoughItemsCore.LOGGER.error("Failed to check if the recipe is visible!", throwable);
            }
        }
        return true;
    }

    @Override
    public List<DisplayVisibilityPredicate> getVisibilityPredicates() {
        return Collections.unmodifiableList(this.visibilityPredicates);
    }

    @Override
    public <T, D extends Display> void registerFiller(Class<T> typeClass, Predicate<? extends T> predicate, Function<T, D> filler) {
        this.fillers.add(new DisplayFiller<T, D>(typeClass, predicate, filler));
    }

    @Override
    public void startReload() {
        super.startReload();
        this.displays.clear();
        this.displayGenerators.clear();
        this.visibilityPredicates.clear();
        this.fillers.clear();
        this.displayCount.setValue(0);
    }

    @Override
    public void endReload() {
        if (!this.fillers.isEmpty()) {
            List<IRecipe<?>> allSortedRecipes = this.getAllSortedRecipes();
            for (int i = allSortedRecipes.size() - 1; i >= 0; --i) {
                IRecipe<?> recipe = allSortedRecipes.get(i);
                Collection<Display> displays = this.tryFillDisplay(recipe);
                for (Display display : displays) {
                    this.registerDisplay(0, display);
                }
            }
        }
    }

    @Override
    public <T> Collection<Display> tryFillDisplay(T value) {
        if (value instanceof Display) {
            return Collections.singleton((Display)value);
        }
        List<?> displays = null;
        for (DisplayFiller<?, ?> filler : this.fillers) {
            Object display = this.tryFillDisplayGenerics(filler, value);
            if (display == null) continue;
            if (displays == null) {
                displays = Collections.singletonList(display);
                continue;
            }
            if (!(displays instanceof ArrayList)) {
                displays = new ArrayList(displays);
            }
            displays.add(display);
        }
        if (displays != null) {
            return displays;
        }
        return Collections.emptyList();
    }

    private <T, D extends Display> D tryFillDisplayGenerics(DisplayFiller<T, D> filler, Object value) {
        try {
            if (((DisplayFiller)filler).typeClass.isInstance(value) && ((DisplayFiller)filler).predicate.test(value)) {
                return (D)((Display)((DisplayFiller)filler).mappingFunction.apply(value));
            }
        }
        catch (Throwable e) {
            RoughlyEnoughItemsCore.LOGGER.error("Failed to fill displays!", e);
        }
        return null;
    }

    private static class DisplayFiller<T, D extends Display> {
        private final Class<T> typeClass;
        private final Predicate<T> predicate;
        private final Function<T, D> mappingFunction;

        public DisplayFiller(Class<T> typeClass, Predicate<T> predicate, Function<T, D> mappingFunction) {
            this.typeClass = typeClass;
            this.predicate = predicate;
            this.mappingFunction = mappingFunction;
        }
    }
}

