/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.registry.screen;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.config.DisplayPanelLocation;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZonesProvider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ActionResultType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class ExclusionZonesImpl
implements ExclusionZones {
    private static final Comparator<? super Rectangle> RECTANGLE_COMPARER = Comparator.comparingLong(Rectangle::hashCode);
    private long lastArea = -1L;
    private Multimap<Class<?>, Supplier<Collection<Rectangle>>> list = HashMultimap.create();

    @Override
    public <R extends Screen> boolean isHandingScreen(Class<R> screen) {
        return Screen.class.isAssignableFrom(screen);
    }

    @Override
    public double getPriority() {
        return -5.0;
    }

    @Override
    public ActionResultType isInZone(double mouseX, double mouseY) {
        Class<?> screenClass = Minecraft.func_71410_x().field_71462_r.getClass();
        for (Map.Entry collectionEntry : this.list.asMap().entrySet()) {
            if (!((Class)collectionEntry.getKey()).isAssignableFrom(screenClass)) continue;
            for (Supplier listSupplier : (Collection)collectionEntry.getValue()) {
                for (Rectangle zone : (Collection)listSupplier.get()) {
                    if (!zone.contains(mouseX, mouseY)) continue;
                    return ActionResultType.FAIL;
                }
            }
        }
        return ActionResultType.PASS;
    }

    @Override
    public boolean shouldRecalculateArea(DisplayPanelLocation location, Rectangle rectangle) {
        long current = this.currentHashCode(location);
        if (this.lastArea == current) {
            return false;
        }
        this.lastArea = current;
        return true;
    }

    private long currentHashCode(DisplayPanelLocation location) {
        return this.areasHashCode(ScreenRegistry.getInstance().getOverlayBounds(location, Minecraft.func_71410_x().field_71462_r), this.getExclusionZones(Minecraft.func_71410_x().field_71462_r.getClass(), false));
    }

    @Override
    public List<Rectangle> getExclusionZones(Class<?> currentScreenClass, boolean sort) {
        ArrayList rectangles = Lists.newArrayList();
        for (Map.Entry collectionEntry : this.list.asMap().entrySet()) {
            if (!((Class)collectionEntry.getKey()).isAssignableFrom(currentScreenClass)) continue;
            for (Supplier listSupplier : (Collection)collectionEntry.getValue()) {
                rectangles.addAll((Collection)listSupplier.get());
            }
        }
        if (sort) {
            rectangles.sort(RECTANGLE_COMPARER);
        }
        return rectangles;
    }

    @Override
    public int getZonesCount() {
        return this.list.size();
    }

    @Override
    public <T> void register(Class<? extends T> screenClass, ExclusionZonesProvider<? extends T> provider) {
        this.list.put(screenClass, () -> provider.provide(Minecraft.func_71410_x().field_71462_r));
    }

    private long areasHashCode(Rectangle rectangle, List<Rectangle> exclusionZones) {
        int hashCode = 31 + (rectangle == null ? 0 : rectangle.hashCode());
        for (Rectangle e : exclusionZones) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }
}

