/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.search.SearchFilter;
import me.shedaniel.rei.api.client.search.SearchProvider;
import me.shedaniel.rei.api.client.view.Views;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.gui.ContainerScreenOverlay;

public class AsyncSearchManager {
    private final Supplier<List<EntryStack<?>>> stacksProvider;
    private final Supplier<Predicate<EntryStack<?>>> additionalPredicateSupplier;
    private final UnaryOperator<EntryStack<?>> transformer;
    private Predicate<EntryStack<?>> additionalPredicate;
    private SearchFilter filter;
    private boolean dirty = false;
    private List<EntryStack<?>> last;

    public AsyncSearchManager(Supplier<List<EntryStack<?>>> stacksProvider, Supplier<Predicate<EntryStack<?>>> additionalPredicateSupplier, UnaryOperator<EntryStack<?>> transformer) {
        this.stacksProvider = stacksProvider;
        this.additionalPredicateSupplier = additionalPredicateSupplier;
        this.transformer = transformer;
    }

    public static AsyncSearchManager createDefault() {
        return new AsyncSearchManager(EntryRegistry.getInstance()::getPreFilteredList, () -> {
            LongOpenHashSet workingItems;
            boolean checkCraftable = ConfigManager.getInstance().isCraftableOnlyEnabled() && !ContainerScreenOverlay.getInstance().inventoryStacks.isEmpty();
            LongOpenHashSet longOpenHashSet = workingItems = checkCraftable ? new LongOpenHashSet() : null;
            if (checkCraftable) {
                for (EntryStack<?> stack2 : Views.getInstance().findCraftableEntriesByMaterials(ContainerScreenOverlay.getInstance().inventoryStacks)) {
                    workingItems.add(EntryStacks.hashExact(stack2));
                }
            }
            return checkCraftable ? arg_0 -> AsyncSearchManager.lambda$null$0((LongSet)workingItems, arg_0) : stack -> true;
        }, EntryStack::normalize);
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void updateFilter(String filter) {
        if (this.filter == null || !this.filter.getFilter().equals(filter)) {
            this.filter = SearchProvider.getInstance().createFilter(filter);
            this.markDirty();
        }
    }

    public boolean isDirty() {
        return this.last == null || this.dirty;
    }

    public List<EntryStack<?>> get() {
        if (this.isDirty()) {
            this.additionalPredicate = this.additionalPredicateSupplier.get();
            int searchPartitionSize = ConfigObject.getInstance().getAsyncSearchPartitionSize();
            List<EntryStack<?>> stacks = this.stacksProvider.get();
            this.last = new ArrayList();
            if (!stacks.isEmpty()) {
                if (ConfigObject.getInstance().shouldAsyncSearch() && stacks.size() > searchPartitionSize * 4) {
                    ArrayList futures = Lists.newArrayList();
                    for (Iterable iterable : CollectionUtils.partition(stacks, searchPartitionSize)) {
                        futures.add(CompletableFuture.supplyAsync(() -> {
                            ArrayList filtered = Lists.newArrayList();
                            for (EntryStack stack : partitionStacks) {
                                if (!this.matches(stack) || !this.additionalPredicate.test(stack)) continue;
                                filtered.add(this.transformer.apply(stack));
                            }
                            return filtered;
                        }));
                    }
                    try {
                        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get(10L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                        e.printStackTrace();
                    }
                    for (CompletableFuture completableFuture : futures) {
                        List now = completableFuture.getNow(null);
                        if (now == null) continue;
                        this.last.addAll(now);
                    }
                } else {
                    for (EntryStack<?> stack : stacks) {
                        if (!this.matches(stack) || !this.additionalPredicate.test(stack)) continue;
                        this.last.add((EntryStack<?>)this.transformer.apply(stack));
                    }
                }
            }
            this.dirty = false;
        }
        return this.last;
    }

    public boolean matches(EntryStack<?> stack) {
        return this.filter.test(stack);
    }

    private static /* synthetic */ boolean lambda$null$0(LongSet workingItems, EntryStack stack) {
        return workingItems.contains(EntryStacks.hashExact(stack));
    }
}

