/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.subsets;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.subsets.SubsetsRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class SubsetsRegistryImpl
implements SubsetsRegistry {
    private final Map<String, Set<EntryStack<?>>> paths = Maps.newHashMap();

    @Override
    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerSubsets(this);
    }

    @Override
    public void startReload() {
        this.paths.clear();
    }

    @Override
    public List<String> getEntryPaths(EntryStack<?> stack) {
        ArrayList<String> strings = null;
        for (Map.Entry<String, Set<EntryStack<?>>> entry : this.paths.entrySet()) {
            if (CollectionUtils.findFirstOrNullEqualsExact((Iterable)entry.getValue(), stack) == null) continue;
            if (strings == null) {
                strings = new ArrayList<String>();
            }
            strings.add(entry.getKey());
        }
        return strings == null ? Collections.emptyList() : strings;
    }

    @Override
    public void registerPathEntry(String path, EntryStack<?> stack) {
        this.getOrCreatePathEntries(path).add(stack.normalize());
    }

    @Override
    public void registerPathEntries(String path, Collection<? extends EntryStack<?>> stacks) {
        Set<EntryStack<?>> entries = this.getOrCreatePathEntries(path);
        for (EntryStack<?> stack : stacks) {
            entries.add(stack.normalize());
        }
    }

    @Override
    @Nullable
    public Set<EntryStack<?>> getPathEntries(String path) {
        if (!this.isPathValid(path)) {
            throw new IllegalArgumentException("Illegal path: " + path);
        }
        return this.paths.get(path);
    }

    @Override
    public Set<String> getPaths() {
        return this.paths.keySet();
    }

    @Override
    public Set<EntryStack<?>> getOrCreatePathEntries(String path) {
        Set<EntryStack<?>> paths = this.getPathEntries(path);
        if (paths == null) {
            this.paths.put(path, Sets.newLinkedHashSet());
            paths = Objects.requireNonNull(this.getPathEntries(path));
        }
        return paths;
    }

    private boolean isPathValid(String path) {
        String[] pathSegments;
        for (String pathSegment : pathSegments = path.split("/")) {
            if (ResourceLocation.func_217855_b((String)pathSegment)) continue;
            return false;
        }
        return true;
    }
}

