/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.view;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.LiveDisplayGenerator;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.client.view.Views;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ViewsImpl
implements Views {
    @Override
    public Map<DisplayCategory<?>, List<Display>> buildMapFor(ViewSearchBuilder builder) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Set<CategoryIdentifier<?>> categories = builder.getCategories();
        List<EntryStack<?>> recipesFor = builder.getRecipesFor();
        List<EntryStack<?>> usagesFor = builder.getUsagesFor();
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Object categoryConfiguration : CategoryRegistry.getInstance()) {
            DisplayCategory displayCategory = categoryConfiguration.getCategory();
            CategoryIdentifier<?> categoryIdentifier = categoryConfiguration.getCategoryIdentifier();
            List<?> allRecipesFromCategory = DisplayRegistry.getInstance().get(categoryIdentifier);
            LinkedHashSet set = Sets.newLinkedHashSet();
            if (categories.contains(categoryIdentifier)) {
                for (Display display2 : allRecipesFromCategory) {
                    if (!this.isDisplayVisible(display2)) continue;
                    set.add(display2);
                }
                if (set.isEmpty()) continue;
                CollectionUtils.getOrPutEmptyList(result, displayCategory).addAll(set);
                continue;
            }
            block2: for (Display display3 : allRecipesFromCategory) {
                if (!this.isDisplayVisible(display3)) continue;
                if (!recipesFor.isEmpty()) {
                    block3: for (List list : display3.getOutputEntries()) {
                        for (EntryStack otherEntry : list) {
                            for (EntryStack<?> stack : recipesFor) {
                                if (!EntryStacks.equalsExact(otherEntry, stack)) continue;
                                set.add(display3);
                                break block3;
                            }
                        }
                    }
                }
                if (usagesFor.isEmpty()) continue;
                for (List list : display3.getInputEntries()) {
                    for (EntryStack otherEntry : list) {
                        for (EntryStack<?> stack : usagesFor) {
                            if (!EntryStacks.equalsExact(otherEntry, stack)) continue;
                            set.add(display3);
                            continue block2;
                        }
                    }
                }
            }
            for (EntryStack entryStack : usagesFor) {
                if (!this.isStackWorkStationOfCategory((CategoryRegistry.CategoryConfiguration<?>)categoryConfiguration, entryStack)) continue;
                set.addAll(CollectionUtils.filterToSet(allRecipesFromCategory, this::isDisplayVisible));
                break;
            }
            if (set.isEmpty()) continue;
            CollectionUtils.getOrPutEmptyList(result, displayCategory).addAll(set);
        }
        int generatorsCount = 0;
        for (Map.Entry entry : DisplayRegistry.getInstance().getCategoryDisplayGenerators().entrySet()) {
            CategoryIdentifier categoryIdentifier = (CategoryIdentifier)entry.getKey();
            LinkedHashSet set = new LinkedHashSet();
            generatorsCount += ((List)entry.getValue()).size();
            for (LiveDisplayGenerator generator : (List)entry.getValue()) {
                this.generateLiveDisplays(generator, builder, set::add);
            }
            if (set.isEmpty()) continue;
            CollectionUtils.getOrPutEmptyList(result, CategoryRegistry.getInstance().get(categoryIdentifier).getCategory()).addAll(set);
        }
        Consumer<Display> displayConsumer = display -> CollectionUtils.getOrPutEmptyList(result, CategoryRegistry.getInstance().get(display.getCategoryIdentifier()).getCategory()).add(display);
        for (LiveDisplayGenerator<?> liveDisplayGenerator : DisplayRegistry.getInstance().getGlobalDisplayGenerators()) {
            ++generatorsCount;
            this.generateLiveDisplays(liveDisplayGenerator, builder, displayConsumer);
        }
        String string = String.format("Built Recipe View in %s for %d categories, %d recipes for, %d usages for and %d live recipe generators.", stopwatch.stop().toString(), categories.size(), recipesFor.size(), usagesFor.size(), generatorsCount);
        if (ConfigObject.getInstance().doDebugSearchTimeRequired()) {
            RoughlyEnoughItemsCore.LOGGER.info(string);
        } else {
            RoughlyEnoughItemsCore.LOGGER.trace(string);
        }
        return result;
    }

    private <T extends Display> void generateLiveDisplays(LiveDisplayGenerator<T> generator, ViewSearchBuilder builder, Consumer<T> displayConsumer) {
        for (EntryStack<?> stack : builder.getRecipesFor()) {
            Optional<List<T>> recipeForDisplays = generator.getRecipeFor(stack);
            if (!recipeForDisplays.isPresent()) continue;
            for (Display display : recipeForDisplays.get()) {
                if (!this.isDisplayVisible(display)) continue;
                displayConsumer.accept(display);
            }
        }
        for (EntryStack<?> stack : builder.getUsagesFor()) {
            Optional<List<T>> usageForDisplays = generator.getUsageFor(stack);
            if (!usageForDisplays.isPresent()) continue;
            for (Display display : usageForDisplays.get()) {
                if (!this.isDisplayVisible(display)) continue;
                displayConsumer.accept(display);
            }
        }
        Optional<List<T>> displaysGenerated = generator.generate(builder);
        if (displaysGenerated.isPresent()) {
            for (Display display : displaysGenerated.get()) {
                if (!this.isDisplayVisible(display)) continue;
                displayConsumer.accept(display);
            }
        }
    }

    @Override
    public Collection<EntryStack<?>> findCraftableEntriesByMaterials(Iterable<? extends EntryStack<?>> inventoryItems) {
        HashSet craftables = new HashSet();
        for (List<Display> displays : DisplayRegistry.getInstance().getAll().values()) {
            for (Display display : displays) {
                int slotsCraftable = 0;
                List<EntryIngredient> requiredInput = display.getRequiredEntries();
                block2: for (EntryIngredient slot : requiredInput) {
                    if (slot.isEmpty()) {
                        ++slotsCraftable;
                        continue;
                    }
                    for (EntryStack<?> possibleType : inventoryItems) {
                        for (EntryStack slotPossible : slot) {
                            if (!EntryStacks.equalsExact(possibleType, slotPossible)) continue;
                            ++slotsCraftable;
                            continue block2;
                        }
                    }
                }
                if (slotsCraftable != display.getRequiredEntries().size()) continue;
                display.getOutputEntries().stream().flatMap(Collection::stream).collect(Collectors.toCollection(() -> craftables));
            }
        }
        return craftables;
    }

    private <T> boolean isStackWorkStationOfCategory(CategoryRegistry.CategoryConfiguration<?> category, EntryStack<T> stack) {
        for (EntryIngredient ingredient : category.getWorkstations()) {
            if (!EntryIngredients.testFuzzy(ingredient, stack)) continue;
            return true;
        }
        return false;
    }

    private boolean isDisplayVisible(Display display) {
        return DisplayRegistry.getInstance().isDisplayVisible(display);
    }

    @Override
    public void startReload() {
    }
}

