/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.display;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import net.minecraft.nbt.CompoundNBT;

public class DisplaySerializerRegistryImpl
implements DisplaySerializerRegistry {
    private final Map<CategoryIdentifier<?>, Holder<?>> serializers = new HashMap();

    @Override
    public <D extends Display> void register(CategoryIdentifier<? extends D> categoryId, DisplaySerializer<D> serializer) {
        Holder holder = this.serializers.computeIfAbsent(categoryId, id -> new Holder());
        holder.serializer = Optional.of(serializer);
    }

    @Override
    public <D extends Display> void registerNotSerializable(CategoryIdentifier<D> categoryId) {
        this.serializers.computeIfAbsent(categoryId, id -> new Holder()).serializer = Optional.empty();
    }

    @Override
    public <D extends Display> boolean hasRegistered(CategoryIdentifier<D> categoryId) {
        return this.serializers.containsKey(categoryId);
    }

    @Override
    public <D extends Display> boolean hasSerializer(CategoryIdentifier<D> categoryId) {
        Holder<?> holder = this.serializers.get(categoryId);
        return holder != null && ((Holder)holder).serializer.isPresent();
    }

    @Override
    public <D extends Display> CompoundNBT save(CategoryIdentifier<? extends D> categoryId, D display, CompoundNBT tag) {
        return ((DisplaySerializer)((Holder)this.serializers.get(categoryId)).serializer.get()).save(tag, display);
    }

    @Override
    public <D extends Display> D read(CategoryIdentifier<? extends D> categoryId, CompoundNBT tag) {
        return ((DisplaySerializer)((Holder)this.serializers.get(categoryId)).serializer.get()).read(tag);
    }

    @Override
    public void startReload() {
        this.serializers.clear();
    }

    @Override
    public void acceptPlugin(REIPlugin<?> plugin) {
        plugin.registerDisplaySerializer(this);
    }

    private static class Holder<D extends Display> {
        private Optional<DisplaySerializer<D>> serializer = Optional.empty();

        private Holder() {
        }
    }
}

