/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMaps;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.Collection;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.utils.Env;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.gui.AbstractRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.common.entry.TypedEntryStack;
import net.minecraft.client.Minecraft;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class AbstractEntryStack<A>
extends AbstractRenderer
implements EntryStack<A> {
    private static final Short2ObjectMap<Object> EMPTY_SETTINGS = Short2ObjectMaps.emptyMap();
    private Short2ObjectMap<Object> settings = null;

    @Override
    public <T> EntryStack<A> setting(EntryStack.Settings<T> settings, T value) {
        short settingsId = settings.getId();
        if (this.settings == null) {
            this.settings = Short2ObjectMaps.singleton((short)settingsId, value);
        } else {
            if (this.settings.size() == 1) {
                if (this.settings.containsKey(settingsId)) {
                    this.settings = Short2ObjectMaps.singleton((short)settingsId, value);
                    return this;
                }
                Short2ObjectMap<Object> singletonSettings = this.settings;
                this.settings = new Short2ObjectOpenHashMap(2);
                this.settings.putAll(singletonSettings);
            }
            this.settings.put(settingsId, value);
        }
        return this;
    }

    @Override
    public <T> EntryStack<A> removeSetting(EntryStack.Settings<T> settings) {
        if (this.settings != null) {
            short settingsId = settings.getId();
            if (this.settings.size() == 1) {
                if (this.settings.containsKey(settingsId)) {
                    this.settings = null;
                }
            } else if (this.settings.remove(settingsId) != null && this.settings.isEmpty()) {
                this.settings = null;
            }
        }
        return this;
    }

    @Override
    public EntryStack<A> clearSettings() {
        this.settings = null;
        return this;
    }

    protected Short2ObjectMap<Object> getSettings() {
        return this.settings == null ? EMPTY_SETTINGS : this.settings;
    }

    @Override
    @Nullable
    public ResourceLocation getIdentifier() {
        return this.getDefinition().getIdentifier(this, this.getValue());
    }

    @Override
    public boolean isEmpty() {
        return this.getDefinition().isEmpty(this, this.getValue());
    }

    @Override
    public EntryStack<A> copy() {
        return this.wrap(this.getDefinition().copy(this, this.getValue()), true);
    }

    @Override
    public EntryStack<A> rewrap() {
        return this.wrap(this.getValue(), true);
    }

    @Override
    public EntryStack<A> normalize() {
        return this.wrap(this.getDefinition().normalize(this, this.getValue()), false);
    }

    protected EntryStack<A> wrap(A value, boolean copySettings) {
        TypedEntryStack<A> stack = new TypedEntryStack<A>(this.getDefinition(), value);
        if (copySettings) {
            for (Short2ObjectMap.Entry entry : this.getSettings().short2ObjectEntrySet()) {
                stack.setting(EntryStack.Settings.getById(entry.getShortKey()), (A)entry.getValue());
            }
        }
        return stack;
    }

    @Override
    public <T> T get(EntryStack.Settings<T> settings) {
        Object o;
        Object object = o = this.settings == null ? null : this.settings.get(settings.getId());
        if (o == null) {
            return settings.getDefaultValue();
        }
        return (T)o;
    }

    @Override
    public void render(MatrixStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
        this.getRenderer().render(this, matrices, bounds, mouseX, mouseY, delta);
    }

    @Override
    @Nullable
    public Tooltip getTooltip(Point mouse, boolean appendModName) {
        ResourceLocation location;
        MutableObject tooltip = new MutableObject((Object)this.getRenderer().cast().getTooltip(this, mouse));
        if (tooltip.getValue() == null) {
            return null;
        }
        ((Tooltip)tooltip.getValue()).getText().addAll((Collection<ITextComponent>)this.get((EntryStack.Settings)EntryStack.Settings.TOOLTIP_APPEND_EXTRA).apply(this));
        tooltip.setValue((Object)this.get((EntryStack.Settings)EntryStack.Settings.TOOLTIP_PROCESSOR).apply(this, (Tooltip)tooltip.getValue()));
        if (tooltip.getValue() == null) {
            return null;
        }
        if (appendModName && (location = this.getIdentifier()) != null) {
            ClientHelper.getInstance().appendModIdToTooltips(((Tooltip)tooltip.getValue()).getText(), location.func_110624_b());
        }
        return (Tooltip)tooltip.getValue();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractEntryStack)) {
            return false;
        }
        AbstractEntryStack that = (AbstractEntryStack)o;
        return EntryStacks.equalsExact(this, that);
    }

    @Override
    public int hashCode() {
        return Long.hashCode(EntryStacks.hashExact(this));
    }

    @Override
    public Collection<ResourceLocation> getTagsFor() {
        ITagCollectionSupplier container = Platform.getEnvironment() == Env.CLIENT ? AbstractEntryStack.getClientTagContainer() : TagCollectionManager.func_242178_a();
        return this.getDefinition().getTagsFor(container, this, this.getValue());
    }

    @OnlyIn(value=Dist.CLIENT)
    private static ITagCollectionSupplier getClientTagContainer() {
        return Minecraft.func_71410_x().func_147114_u().func_199724_l();
    }

    @Override
    public ITextComponent asFormattedText() {
        return this.getDefinition().asFormattedText(this, this.getValue());
    }
}

