/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry.comparison;

import java.util.IdentityHashMap;
import java.util.Map;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparator;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ItemComparatorRegistryImpl
implements ItemComparatorRegistry {
    private static final Logger LOGGER = LogManager.getLogger(ItemComparatorRegistryImpl.class);
    private final Map<Item, ItemComparator> comparators = new IdentityHashMap<Item, ItemComparator>();

    @Override
    public void register(ItemComparator comparator, Item item) {
        ItemComparator put = this.comparators.put(item, comparator);
        if (put != null) {
            LOGGER.warn("[REI] Overriding " + put + "item comparator with " + comparator + "for " + Registry.field_212630_s.func_177774_c((Object)item) + "! This may result in unwanted comparisons!");
        }
    }

    @Override
    public void startReload() {
        this.comparators.clear();
    }

    @Override
    public void acceptPlugin(REIPlugin<?> plugin) {
        plugin.registerItemComparators(this);
    }

    @Override
    public long hashOf(ComparisonContext context, ItemStack stack) {
        ItemComparator comparator = this.comparators.get(stack.func_77973_b());
        if (comparator != null) {
            return comparator.hash(context, stack);
        }
        return 1L;
    }

    @Override
    public boolean containsComparator(Item item) {
        return this.comparators.containsKey(item);
    }

    @Override
    public int comparatorSize() {
        return this.comparators.size();
    }
}

