/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry.comparison;

import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import me.shedaniel.rei.impl.Internals;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import org.jetbrains.annotations.Nullable;

public class NbtHasherProviderImpl
implements Internals.NbtHasherProvider {
    private final ToLongFunction<INBT> defaultHasher = this._provide(new String[0]);

    @Override
    public ToLongFunction<INBT> provide(String ... ignoredKeys) {
        if (ignoredKeys == null || ignoredKeys.length == 0) {
            return this.defaultHasher;
        }
        return this._provide(ignoredKeys);
    }

    private ToLongFunction<INBT> _provide(String ... ignoredKeys) {
        return new Hasher(ignoredKeys);
    }

    private static class Hasher
    implements ToLongFunction<INBT> {
        @Nullable
        private final Predicate<String> filter;

        private Hasher(@Nullable String[] ignoredKeys) {
            if (ignoredKeys == null || ignoredKeys.length == 0) {
                this.filter = key -> true;
            } else if (ignoredKeys.length == 1) {
                String s = ignoredKeys[0];
                this.filter = key -> !Objects.equals(s, key);
            } else {
                HashSet<String> set = new HashSet<String>(Arrays.asList(ignoredKeys));
                this.filter = Predicates.not(set::contains);
            }
        }

        private boolean shouldHash(String key) {
            return this.filter.test(key);
        }

        @Override
        public long applyAsLong(INBT value) {
            return this.hashTag(value);
        }

        private int hashTag(INBT tag) {
            if (tag == null) {
                return 0;
            }
            if (tag instanceof ListNBT) {
                return this.hashListTag((ListNBT)tag);
            }
            if (tag instanceof CompoundNBT) {
                return this.hashCompoundTag((CompoundNBT)tag);
            }
            return tag.hashCode();
        }

        private int hashListTag(ListNBT tag) {
            int i = tag.size();
            for (INBT innerTag : tag) {
                i = i * 31 + this.hashTag(innerTag);
            }
            return i;
        }

        private int hashCompoundTag(CompoundNBT tag) {
            int i = 1;
            for (Map.Entry entry : tag.field_74784_a.entrySet()) {
                if (!this.shouldHash((String)entry.getKey())) continue;
                i = i * 31 + (Objects.hashCode(entry.getKey()) ^ this.hashTag((INBT)entry.getValue()));
            }
            return i;
        }
    }
}

