/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry.type;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.EntryTypeBridge;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class EntryTypeRegistryImpl
implements EntryTypeRegistry {
    private final BiMap<ResourceLocation, EntryDefinition<?>> entryTypes = HashBiMap.create();
    private final Table<ResourceLocation, ResourceLocation, List<EntryTypeBridge<?, ?>>> typeBridges = HashBasedTable.create();

    @Override
    public void acceptPlugin(REIPlugin<?> plugin) {
        plugin.registerEntryTypes(this);
    }

    @Override
    public <T> void register(ResourceLocation id, EntryDefinition<T> definition) {
        this.entryTypes.put((Object)id, definition);
    }

    @Override
    public <A, B> void registerBridge(EntryType<A> original, EntryType<B> destination, EntryTypeBridge<A, B> bridge) {
        ArrayList<EntryTypeBridge<A, B>> list = (ArrayList<EntryTypeBridge<A, B>>)this.typeBridges.get((Object)original.getId(), (Object)destination.getId());
        if (list == null) {
            list = new ArrayList<EntryTypeBridge<A, B>>();
            this.typeBridges.put((Object)original.getId(), (Object)destination.getId(), list);
        }
        list.add(bridge);
    }

    @Override
    public EntryDefinition<?> get(ResourceLocation id) {
        return (EntryDefinition)this.entryTypes.get((Object)id);
    }

    @Override
    public Set<ResourceLocation> keySet() {
        return this.entryTypes.keySet();
    }

    @Override
    public Set<EntryDefinition<?>> values() {
        return this.entryTypes.values();
    }

    @Override
    public <A, B> Iterable<EntryTypeBridge<A, B>> getBridgesFor(EntryType<A> original, EntryType<B> destination) {
        List list = (List)this.typeBridges.get((Object)original.getId(), (Object)destination.getId());
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public void startReload() {
        this.entryTypes.clear();
        this.typeBridges.clear();
    }
}

