/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.fluid;

import com.google.common.collect.ForwardingList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import me.shedaniel.architectury.fluid.FluidStack;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.fluid.FluidSupportProvider;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FluidSupportProviderImpl
extends ForwardingList<FluidSupportProvider.Provider>
implements FluidSupportProvider {
    private final List<FluidSupportProvider.Provider> providers = Lists.newCopyOnWriteArrayList();
    private final List<FluidSupportProvider.Provider> immutable = Collections.unmodifiableList(this.providers);

    @Override
    public void acceptPlugin(REIPlugin<?> plugin) {
        plugin.registerFluidSupport(this);
    }

    @Override
    public void startReload() {
        this.providers.clear();
    }

    @Override
    public void register(FluidSupportProvider.Provider provider) {
        this.providers.add(Objects.requireNonNull(provider, "Registered provider is null!"));
    }

    @Override
    public Optional<Stream<EntryStack<FluidStack>>> itemToFluids(EntryStack<? extends ItemStack> itemStack) {
        if (itemStack.isEmpty()) {
            return Optional.empty();
        }
        for (FluidSupportProvider.Provider provider : this.providers) {
            ActionResult<@Nullable Stream<EntryStack<FluidStack>>> resultHolder = Objects.requireNonNull(provider.itemToFluid(itemStack));
            Stream stream = (Stream)resultHolder.func_188398_b();
            if (stream == null) continue;
            if (resultHolder.func_188397_a().func_226246_a_()) {
                return Optional.of(stream);
            }
            if (resultHolder.func_188397_a() != ActionResultType.FAIL) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    protected List<FluidSupportProvider.Provider> delegate() {
        return this.immutable;
    }
}

