/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.plugins;

import com.google.common.base.MoreObjects;
import com.google.common.base.Stopwatch;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.UnaryOperator;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.PluginView;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.plugins.REIPluginProvider;
import me.shedaniel.rei.api.common.registry.Reloadable;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.util.Util;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PluginManagerImpl<P extends REIPlugin<?>>
implements PluginManager<P>,
PluginView<P> {
    private final List<Reloadable<P>> reloadables = new ArrayList<Reloadable<P>>();
    private final Map<Class<? extends Reloadable<P>>, Reloadable<? super P>> cache = new ConcurrentHashMap<Class<? extends Reloadable<P>>, Reloadable<? super P>>();
    private final Class<P> pluginClass;
    private final UnaryOperator<PluginView<P>> view;
    private boolean arePluginsLoading = false;
    private final List<REIPluginProvider<P>> plugins = new ArrayList<REIPluginProvider<P>>();
    private final LongConsumer reloadDoneListener;

    @SafeVarargs
    public PluginManagerImpl(Class<P> pluginClass, UnaryOperator<PluginView<P>> view, LongConsumer reloadDoneListener, Reloadable<? extends P> ... reloadables) {
        this.pluginClass = pluginClass;
        this.view = view;
        this.reloadDoneListener = reloadDoneListener;
        for (Reloadable<? extends P> reloadable : reloadables) {
            this.registerReloadable(reloadable);
        }
    }

    @Override
    public void registerReloadable(Reloadable<? extends P> reloadable) {
        this.reloadables.add(reloadable);
    }

    @Override
    public boolean arePluginsReloading() {
        return this.arePluginsLoading;
    }

    @Override
    public <T extends Reloadable<? super P>> T get(Class<T> reloadableClass) {
        Reloadable<? super P> reloadable = this.cache.get(reloadableClass);
        if (reloadable != null) {
            return (T)reloadable;
        }
        for (Reloadable<P> r : this.reloadables) {
            if (!reloadableClass.isInstance(r)) continue;
            this.cache.put(reloadableClass, r);
            return (T)r;
        }
        throw new IllegalArgumentException("Unknown reloadable type! " + reloadableClass.getName());
    }

    @Override
    public List<Reloadable<P>> getReloadables() {
        return Collections.unmodifiableList(this.reloadables);
    }

    @Override
    public PluginView<P> view() {
        return (PluginView)this.view.apply(this);
    }

    @Override
    public void registerPlugin(REIPluginProvider<? extends P> plugin) {
        this.plugins.add(plugin);
        RoughlyEnoughItemsCore.LOGGER.info("Registered plugin provider %s for %s", (Object)plugin.getPluginProviderName(), (Object)this.pluginClass.getSimpleName());
    }

    @Override
    public List<REIPluginProvider<P>> getPluginProviders() {
        return Collections.unmodifiableList(this.plugins);
    }

    @Override
    public FluentIterable<P> getPlugins() {
        return FluentIterable.concat((Iterable)Iterables.transform(this.plugins, REIPluginProvider::provide));
    }

    private SectionClosable section(MutablePair<Stopwatch, String> sectionData, String section) {
        return new SectionClosable(sectionData, section);
    }

    private void pluginSection(MutablePair<Stopwatch, String> sectionData, String sectionName, List<P> list, Consumer<P> consumer) {
        for (REIPlugin plugin : list) {
            try {
                SectionClosable section = this.section(sectionData, sectionName + " for " + plugin.getPluginName());
                Throwable throwable = null;
                try {
                    consumer.accept(plugin);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (section == null) continue;
                    if (throwable != null) {
                        try {
                            section.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    section.close();
                }
            }
            catch (Throwable throwable) {
                RoughlyEnoughItemsCore.LOGGER.error(plugin.getPluginName() + " plugin failed to " + sectionName + "!", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startReload() {
        try {
            Class<?> reloadableClass;
            this.arePluginsLoading = true;
            long startTime = Util.func_211177_b();
            MutablePair sectionData = new MutablePair((Object)Stopwatch.createUnstarted(), (Object)"");
            for (Reloadable<P> reloadable : this.reloadables) {
                Class<?> reloadableClass2 = reloadable.getClass();
                try {
                    SectionClosable startReload = this.section((MutablePair<Stopwatch, String>)sectionData, "start-reload-" + (String)MoreObjects.firstNonNull((Object)reloadableClass2.getSimpleName(), (Object)reloadableClass2.getName()));
                    Throwable throwable = null;
                    try {
                        reloadable.startReload();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (startReload == null) continue;
                        if (throwable != null) {
                            try {
                                startReload.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        startReload.close();
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            ArrayList<REIPlugin> plugins = new ArrayList<REIPlugin>((Collection<REIPlugin>)this.getPlugins().toList());
            plugins.sort(Comparator.comparingInt(REIPlugin::getPriority).reversed());
            RoughlyEnoughItemsCore.LOGGER.info("Reloading Plugin Manager [%s], registered %d plugins: %s", (Object)this.pluginClass.getSimpleName(), (Object)plugins.size(), (Object)CollectionUtils.mapAndJoinToString(plugins, REIPlugin::getPluginName, (CharSequence)", "));
            Collections.reverse(plugins);
            this.pluginSection((MutablePair<Stopwatch, String>)sectionData, "pre-register", plugins, REIPlugin::preRegister);
            for (Reloadable<P> reloadable : this.getReloadables()) {
                reloadableClass = reloadable.getClass();
                this.pluginSection((MutablePair<Stopwatch, String>)sectionData, "reloadable-plugin-" + (String)MoreObjects.firstNonNull((Object)reloadableClass.getSimpleName(), (Object)reloadableClass.getName()), plugins, reloadable::acceptPlugin);
            }
            this.pluginSection((MutablePair<Stopwatch, String>)sectionData, "post-register", plugins, REIPlugin::postRegister);
            for (Reloadable<P> reloadable : this.reloadables) {
                reloadableClass = reloadable.getClass();
                try {
                    SectionClosable endReload = this.section((MutablePair<Stopwatch, String>)sectionData, "end-reload-" + (String)MoreObjects.firstNonNull((Object)reloadableClass.getSimpleName(), (Object)reloadableClass.getName()));
                    Throwable throwable = null;
                    try {
                        reloadable.endReload();
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (endReload == null) continue;
                        if (throwable != null) {
                            try {
                                endReload.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        endReload.close();
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            long l = Util.func_211177_b() - startTime;
            this.reloadDoneListener.accept(l);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            this.arePluginsLoading = false;
        }
    }

    private static class SectionClosable
    implements Closeable {
        private MutablePair<Stopwatch, String> sectionData;

        public SectionClosable(MutablePair<Stopwatch, String> sectionData, String section) {
            this.sectionData = sectionData;
            sectionData.setRight((Object)section);
            RoughlyEnoughItemsCore.LOGGER.debug("Reloading Section: \"%s\"", (Object)section);
            ((Stopwatch)sectionData.getLeft()).reset().start();
        }

        @Override
        public void close() {
            ((Stopwatch)this.sectionData.getLeft()).stop();
            String section = (String)this.sectionData.getRight();
            RoughlyEnoughItemsCore.LOGGER.debug("Reloading Section: \"%s\" done in %s", (Object)section, (Object)((Stopwatch)this.sectionData.getLeft()).toString());
            ((Stopwatch)this.sectionData.getLeft()).reset();
        }
    }
}

