/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.unwrap;

import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class JEIIngredientHelper<T>
implements IIngredientHelper<T> {
    private final EntryDefinition<T> definition;

    public JEIIngredientHelper(EntryDefinition<T> definition) {
        this.definition = definition;
    }

    @Override
    @Nullable
    public T getMatch(Iterable<T> ingredients, T ingredientToMatch) {
        return this.getMatch(ingredients, ingredientToMatch, UidContext.Ingredient);
    }

    @Override
    @Nullable
    public T getMatch(Iterable<T> ingredients, T ingredientToMatch, UidContext context) {
        ComparisonContext comparisonContext = JEIPluginDetector.wrapContext(context);
        return (T)CollectionUtils.findFirstOrNull(ingredients, t -> this.definition.equals(t, ingredientToMatch, comparisonContext));
    }

    @Override
    public String getDisplayName(T ingredient) {
        return this.definition.asFormattedText(JEIPluginDetector.wrap(this.definition, ingredient), ingredient).getString();
    }

    @Override
    public String getUniqueId(T ingredient) {
        return this.getUniqueId(ingredient, UidContext.Ingredient);
    }

    @Override
    public String getUniqueId(T ingredient, UidContext context) {
        ComparisonContext comparisonContext = JEIPluginDetector.wrapContext(context);
        return String.valueOf(EntryStacks.hash(JEIPluginDetector.wrap(this.definition, ingredient), comparisonContext));
    }

    @Override
    public String getModId(T ingredient) {
        ResourceLocation location = this.definition.getIdentifier(JEIPluginDetector.wrap(this.definition, ingredient), ingredient);
        return location == null ? "minecraft" : location.func_110624_b();
    }

    @Override
    public String getResourceId(T ingredient) {
        ResourceLocation location = this.definition.getIdentifier(JEIPluginDetector.wrap(this.definition, ingredient), ingredient);
        return location == null ? "minecraft:unknown" : location.toString();
    }

    @Override
    public T copyIngredient(T ingredient) {
        return this.definition.copy(JEIPluginDetector.wrap(this.definition, ingredient), ingredient);
    }

    @Override
    public String getErrorInfo(@Nullable T ingredient) {
        try {
            return this.getResourceId(ingredient);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return throwable.getClass().getName() + ": " + throwable.getLocalizedMessage();
        }
    }
}

