/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.mojang.blaze3d.matrix.MatrixStack;
import me.shedaniel.clothconfig2.forge.api.PointHelper;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.JEIGuiHelper;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class JEIDrawableBuilder
implements IDrawableBuilder {
    private ResourceLocation texture;
    private int u;
    private int v;
    private int width;
    private int height;
    private int textureWidth = 256;
    private int textureHeight = 256;
    private int paddingTop;
    private int paddingBottom;
    private int paddingLeft;
    private int paddingRight;

    public JEIDrawableBuilder(ResourceLocation texture, int u, int v, int width, int height) {
        this.texture = texture;
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
    }

    @Override
    @NotNull
    public IDrawableBuilder setTextureSize(int width, int height) {
        this.textureWidth = width;
        this.textureHeight = height;
        return this;
    }

    @Override
    @NotNull
    public IDrawableBuilder addPadding(int paddingTop, int paddingBottom, int paddingLeft, int paddingRight) {
        this.paddingTop = paddingTop;
        this.paddingBottom = paddingBottom;
        this.paddingLeft = paddingLeft;
        this.paddingRight = paddingRight;
        return this;
    }

    @Override
    @NotNull
    public IDrawableBuilder trim(int trimTop, int trimBottom, int trimLeft, int trimRight) {
        this.u += trimLeft;
        this.v += trimTop;
        this.width -= trimLeft + trimRight;
        this.height -= trimTop + trimBottom;
        return this;
    }

    @Override
    @NotNull
    public IDrawableStatic build() {
        final int actualWidth = this.width + this.paddingLeft + this.paddingRight;
        final int actualHeight = this.height + this.paddingTop + this.paddingBottom;
        final Widget widget = Widgets.createTexturedWidget(this.texture, 0, 0, this.u, this.v, this.width, this.height, this.textureWidth, this.textureHeight);
        return new IDrawableStatic(){

            @Override
            public void draw(@NotNull MatrixStack matrixStack, int xOffset, int yOffset, int maskTop, int maskBottom, int maskLeft, int maskRight) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)(xOffset + JEIDrawableBuilder.this.paddingLeft), (double)(yOffset + JEIDrawableBuilder.this.paddingTop), 0.0);
                widget.func_230430_a_(matrixStack, PointHelper.getMouseX(), PointHelper.getMouseY(), 0.0f);
                matrixStack.func_227865_b_();
            }

            @Override
            public void draw(@NotNull MatrixStack matrixStack, int xOffset, int yOffset) {
                this.draw(matrixStack, xOffset, yOffset, 0, 0, 0, 0);
            }

            @Override
            public int getWidth() {
                return actualWidth;
            }

            @Override
            public int getHeight() {
                return actualHeight;
            }
        };
    }

    @Override
    @NotNull
    public IDrawableAnimated buildAnimated(int ticksPerCycle, @NotNull IDrawableAnimated.StartDirection startDirection, boolean inverted) {
        return JEIGuiHelper.INSTANCE.createAnimatedDrawable(this.build(), ticksPerCycle, startDirection, inverted);
    }

    @Override
    @NotNull
    public IDrawableAnimated buildAnimated(@NotNull ITickTimer tickTimer, @NotNull IDrawableAnimated.StartDirection startDirection) {
        throw JEIPluginDetector.TODO();
    }
}

