/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.mojang.blaze3d.matrix.MatrixStack;
import me.shedaniel.clothconfig2.forge.api.PointHelper;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.JEIDrawableBuilder;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.helpers.IGuiHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.jetbrains.annotations.NotNull;

public enum JEIGuiHelper implements IGuiHelper
{
    INSTANCE;


    @Override
    @NotNull
    public IDrawableBuilder drawableBuilder(@NotNull ResourceLocation resourceLocation, int u, int v, int width, int height) {
        return new JEIDrawableBuilder(resourceLocation, u, v, width, height);
    }

    @Override
    @NotNull
    public IDrawableAnimated createAnimatedDrawable(final @NotNull IDrawableStatic drawable, int ticksPerCycle, @NotNull IDrawableAnimated.StartDirection startDirection, boolean inverted) {
        return new IDrawableAnimated(){

            @Override
            public int getWidth() {
                return drawable.getWidth();
            }

            @Override
            public int getHeight() {
                return drawable.getHeight();
            }

            @Override
            public void draw(@NotNull MatrixStack matrixStack, int xOffset, int yOffset) {
                drawable.draw(matrixStack, xOffset, yOffset);
            }
        };
    }

    @Override
    @NotNull
    public IDrawableStatic getSlotDrawable() {
        final Panel base = Widgets.createSlotBase(new Rectangle(0, 0, 18, 18));
        return new IDrawableStatic(){

            @Override
            public void draw(@NotNull MatrixStack matrixStack, int xOffset, int yOffset, int maskTop, int maskBottom, int maskLeft, int maskRight) {
                base.getBounds().setLocation(xOffset, yOffset);
                base.func_230430_a_(matrixStack, PointHelper.getMouseX(), PointHelper.getMouseY(), 0.0f);
            }

            @Override
            public void draw(@NotNull MatrixStack matrixStack, int xOffset, int yOffset) {
                this.draw(matrixStack, xOffset, yOffset, 0, 0, 0, 0);
            }

            @Override
            public int getWidth() {
                return base.getBounds().getWidth();
            }

            @Override
            public int getHeight() {
                return base.getBounds().getHeight();
            }
        };
    }

    @Override
    @NotNull
    public IDrawableStatic createBlankDrawable(final int width, final int height) {
        return new IDrawableStatic(){

            @Override
            public void draw(@NotNull MatrixStack matrixStack, int xOffset, int yOffset, int maskTop, int maskBottom, int maskLeft, int maskRight) {
            }

            @Override
            public void draw(@NotNull MatrixStack matrixStack, int xOffset, int yOffset) {
            }

            @Override
            public int getWidth() {
                return width;
            }

            @Override
            public int getHeight() {
                return height;
            }
        };
    }

    @Override
    @NotNull
    public <V> IDrawable createDrawableIngredient(@NotNull V ingredient) {
        final EntryStack<?> stack = JEIPluginDetector.wrap(ingredient);
        return new IDrawable(){

            @Override
            public int getWidth() {
                return 16;
            }

            @Override
            public int getHeight() {
                return 16;
            }

            @Override
            public void draw(@NotNull MatrixStack matrixStack, int xOffset, int yOffset) {
                stack.render(matrixStack, new Rectangle(xOffset, yOffset, this.getWidth(), this.getHeight()), PointHelper.getMouseX(), PointHelper.getMouseY(), 0.0f);
            }
        };
    }

    @Override
    @NotNull
    public ICraftingGridHelper createCraftingGridHelper(int craftInputSlot1) {
        throw JEIPluginDetector.TODO();
    }

    @Override
    @NotNull
    public ITickTimer createTickTimer(final int ticksPerCycle, final int maxValue, final boolean countDown) {
        return new ITickTimer(){
            private double animationDuration;
            {
                this.animationDuration = (double)ticksPerCycle * 50.0;
            }

            @Override
            public int getValue() {
                int i = MathHelper.func_76143_f((double)((double)System.currentTimeMillis() / (this.animationDuration / (double)maxValue) % (double)maxValue));
                if (countDown) {
                    return maxValue - i;
                }
                return i;
            }

            @Override
            public int getMaxValue() {
                return maxValue;
            }
        };
    }
}

