/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.unwrap.JEIIngredientHelper;
import me.shedaniel.rei.jeicompat.unwrap.JEIIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientManager;
import org.jetbrains.annotations.NotNull;

public enum JEIIngredientManager implements IIngredientManager
{
    INSTANCE;


    @Override
    @NotNull
    public <V> Collection<V> getAllIngredients(@NotNull IIngredientType<V> ingredientType) {
        EntryDefinition definition = JEIPluginDetector.wrapEntryDefinition(ingredientType);
        return EntryRegistry.getInstance().getEntryStacks().filter(stack -> Objects.equals(stack.getDefinition(), definition)).map(EntryStack::cast).map(JEIPluginDetector::unwrap).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public <V> IIngredientHelper<V> getIngredientHelper(@NotNull V ingredient) {
        return new JEIIngredientHelper(JEIPluginDetector.findEntryDefinition(ingredient).cast());
    }

    @Override
    @NotNull
    public <V> IIngredientHelper<V> getIngredientHelper(@NotNull IIngredientType<V> ingredientType) {
        return new JEIIngredientHelper(JEIPluginDetector.findEntryDefinition(ingredientType).cast());
    }

    @Override
    @NotNull
    public <V> IIngredientRenderer<V> getIngredientRenderer(@NotNull V ingredient) {
        return this.getIngredientRenderer(JEIPluginDetector.findEntryDefinition(ingredient).cast()::getValueType);
    }

    @Override
    @NotNull
    public <V> IIngredientRenderer<V> getIngredientRenderer(@NotNull IIngredientType<V> ingredientType) {
        return new JEIIngredientRenderer<V>(ingredientType, JEIPluginDetector.wrapEntryDefinition(ingredientType).cast().getRenderer());
    }

    @Override
    @NotNull
    public Collection<IIngredientType<?>> getRegisteredIngredientTypes() {
        return CollectionUtils.map(EntryTypeRegistry.getInstance().values(), definition -> definition::getValueType);
    }

    @Override
    public <V> void addIngredientsAtRuntime(@NotNull IIngredientType<V> ingredientType, @NotNull Collection<V> ingredients) {
        EntryRegistry.getInstance().addEntries(CollectionUtils.map(ingredients, v -> JEIPluginDetector.wrap(ingredientType, v)));
    }

    @Override
    public <V> void removeIngredientsAtRuntime(@NotNull IIngredientType<V> ingredientType, @NotNull Collection<V> ingredients) {
        LongOpenHashSet hash = new LongOpenHashSet();
        for (V ingredient : ingredients) {
            hash.add(EntryStacks.hashExact(JEIPluginDetector.wrap(ingredientType, ingredient)));
        }
        EntryRegistry.getInstance().removeEntryExactHashIf(arg_0 -> ((LongSet)hash).contains(arg_0));
    }

    @Override
    @NotNull
    public <V> IIngredientType<V> getIngredientType(@NotNull V ingredient) {
        return JEIPluginDetector.wrap(ingredient).getDefinition().cast()::getValueType;
    }

    @Override
    @NotNull
    public <V> IIngredientType<V> getIngredientType(@NotNull Class<? extends V> ingredientClass) {
        return () -> ingredientClass;
    }
}

